# PUT together plots which are plotted as polar coordinates.  For now
#   this could be the plasmasphere or the measured EUV image if it
#   is plotted in SM equatorial plane

package provide EUVSim 1.0

proc EquatorialPlot { iD } {
   global euvANS HdM PHdM psImG rgImG agImG gHDM Yr Dy Msec \
          gMEP gIMG miImG eqImG raImG

   if [string match $iD MI] {
      if { $euvANS(eqDo) == 0 } { return }
      if { $euvANS(eqDo) == 1 } { set miF XY } else { set miF PT }
   }

   switch -exact -- $iD {
      PS { 
         set TotGrids [expr $gHDM(4) * $gHDM(5)]

# SET up the plasmasphere map

        for { set gN 0  } { $gN < $TotGrids } { incr gN  } {
           if { $HdM($gN) <= 0.0 } { 
              set psImG($gN) 0.0 
           } else { set psImG($gN) $HdM($gN) }
        }

# DO print before any smoothing or decimation.  Also need to set up the
#   corresponding error map 

         if $euvANS(doPrnt) { 
            XformMap $euvANS(SolGrid) raImG erImG gHDM

            set TiMe [TUtimeFmt 2 $Yr(0) $Dy(0) $Msec(0)]
            set fName "${TiMe}.sim"
            set euvANS(prFile) [open $fName w]
            puts $euvANS(prFile) "TIME   : $TiMe"
            puts $euvANS(prFile) "FORMAT : $euvANS(SolGrid)"
            puts $euvANS(prFile) "NITER  : $euvANS(prIter)"
            puts $euvANS(prFile) "SDEV   : $euvANS(prVar)"
            TUgridPrint $euvANS(prFile) psImG erImG gHDM Opened 
         }

# COMPUTE THE GRADIENTS IF TO BE OUTPUT

         if { ($euvANS(rgDo) > 0) || ($euvANS(agDo) > 0) } { 
            if [string match PT $euvANS(SolGrid)] {
               TUgridMath psImG GRADCY agImG rgImG gHDM 
            } else {
               TUgridMath psImG GRADRCY agImG rgImG gHDM 
            }
         }
      }

      MI { XformMap $miF miImG eqImG gMEP }
   }
}
