/*  The C equivalent of ZeroSol,  It is a straight C interface              */
/*                                                                          */
/*  There are  4 OBJV elements.  These are:                                 */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Number of Steps                       (nP)                 */
/*     OBJV[2]:  MaxZ                                  (mZ)                 */
/*     OBJV[3]:  Step Size                             (dH)                 */
/*     OBJV[4]:  Zero Matrix                           (zI)                 */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TeuvsimAnsi.h"
#include "TutilAnsi.h"

int ZeroSolCmd (ClientData Cd, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   static void *memPtr;
   register ByTe_2 *V;
   ReaL_8 cDm, T, XY, lS, gL, dH, mZ, RaD, AnG;
   ReaL_8 X, Y, Z, A, B, C, D;
   ReaL_8 sTm[3], tA[3], bX, bY, eX, eY, IncX, IncY;
   ReaL_8 hIncX, hIncY, R;
   int    nGX, nGY, pStat, Bytes, nP, gF = 0;
   ByTe_4  I, J, K, nG, Loc, RoW, CoL;
   char *Value, Index[10], InDeX[10];
   int Flg = TCL_LEAVE_ERR_MSG;

/* Make sure that all the IO parameters are present */

   if (objc < 5 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: ZeroSol nP mZ dH zImG");
      return TCL_ERROR;
   }

/* Get the non-array inputs                                                 */

   Tcl_GetIntFromObj (tI, objv[1], &nP);
   Tcl_GetDoubleFromObj (tI, objv[2], &mZ);
   Tcl_GetDoubleFromObj (tI, objv[3], &dH);

/* Get the global inputs                                                    */

   Tcl_UpVar (tI, "#0", "pStat",  "pS", 0);
   Tcl_UpVar (tI, "#0", "SaTm",   "sT", 0);
   Tcl_UpVar (tI, "#0", "HaTm",   "hT", 0);
   Tcl_UpVar (tI, "#0", "gHDM",   "Hd", 0);
   Tcl_UpVar (tI, "#0", "cDm",    "Cd", 0);
   Tcl_UpVar (tI, "#0", "euvANS", "AnS", 0);

   if ((Value = Tcl_GetVar2(tI, "Hd", "0", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bX);
   } 
   if ((Value = Tcl_GetVar2(tI, "Hd", "1", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &eX);
   }
   if ((Value = Tcl_GetVar2(tI, "Hd", "2", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bY);
   } 
   if ((Value = Tcl_GetVar2(tI, "Hd", "3", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &eY);
   }
   if ((Value = Tcl_GetVar2(tI, "Hd", "4", Flg)) != NULL) {
      Tcl_GetInt (tI, Value, &nGX);
   } 
   if ((Value = Tcl_GetVar2(tI, "Hd", "5", Flg)) != NULL) {
      Tcl_GetInt (tI, Value, &nGY);
   }
   if ((Value = Tcl_GetVar2(tI, "AnS", "SolGrid", Flg)) != NULL) {
      gF = (strcmp(Value, "PT") == 0) ? 0 : 1;
   }

   IncX = (eX - bX) / (ReaL_4)nGX;
   IncY = (eY - bY) / (ReaL_4)nGY;
   nG = nGX * nGY;

   Bytes = nG * sizeof(ByTe_2);
   if ((memPtr = malloc (Bytes)) == NULL)
      return TCL_ERROR;
   V = (ByTe_2 *)memPtr; 

   for (I = 0; I < nG; ) { V[I++] = 1; }

   V = (ByTe_2 *)memPtr; 
   for (I = 0; I < 3; ++I) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "sT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &sTm[I]);
      }
   }

   for (K = 0; K < nP; ++K) {
      sprintf (InDeX, "%d", K);
      if ((Value = Tcl_GetVar2(tI, "pS", InDeX, Flg)) != NULL) {
         Tcl_GetInt (tI, Value, &pStat);
      } 
      if ((Value = Tcl_GetVar2(tI, "Cd", InDeX, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &cDm);
      } 
      if ( (pStat == 0) || (cDm > 0.0) ) { continue; }

      J = 3 * K; 
      for (I = 0; I < 3; ++I, ++J) {
         sprintf (Index, "%d", J);
         if ((Value = Tcl_GetVar2(tI, "hT", Index, Flg)) != NULL) {
            Tcl_GetDouble (tI, Value, &tA[I]);
         }
      }

      A = tA[0] / tA[2];
      B = tA[1] / tA[2];
      C = -A * sTm[2] + sTm[0];
      D = -B * sTm[2] + sTm[1];
 
      Z = -mZ;
      while (Z <= mZ) {
         X = A * Z + C;
         Y = B * Z + D;
         XY = X * X + Y * Y;
         T = sqrt(XY + Z * Z);
         lS = T * T * T / (XY + 1.0e-9);
         gL = atan2(Y, X);
         if (gF == 1) {
            RaD = lS;
           AnG = gL;
            gL = RaD * cos(AnG);
            lS = RaD * sin(AnG);
         }
         RoW = (lS - bY) / IncY;
         if ((RoW >= 0) && (RoW < nGY) ) {
            CoL = (gL - bX) / IncX;
            if (gF == 0) { if (CoL < 0) { CoL += nGX; } } 
            if ((CoL >= 0) && (CoL < nGX) ) {
               CoL = CoL % nGX;
               Loc = (ByTe_4)(RoW * nGX + CoL);
               V[Loc] = 0;
            }
         }
         Z += dH;
      }
   }

/* FOR XY solution grids we need to mask out the area inside of Re = 1. */

   if ( gF == 1 ) {
      hIncX = fabs(IncX/2.0);
      hIncY = fabs(IncY/2.0);
      for (X = -1.0; X <= 1.0; X += hIncX ) { 
         for (Y = -1.0; Y <= 1.0; Y += hIncY ) { 
            R = X * X + Y * Y;
            if ( R <= 1.0 ) {
               RoW = (Y - bY) / IncY;
               CoL = (X - bX) / IncX;
               Loc = (ByTe_4)(RoW * nGX + CoL);
               V[Loc] = 0;
            }
         }
      }
   }
   
   CArrayToTcl (tI, objv[4], V, nG, 0, 'S'); 
   free (memPtr);

   return TCL_OK;
}
