
/*  The C equivalent of ZeroSol,  It is a straight C interface              */
/*                                                                          */
/*  There are  4 OBJV elements.  These are:                                 */
/*     OBJV[0]:  Routine name                                               */
/*     OBJV[1]:  Grid Number                           (gN)                 */
/*     OBJV[2]:  Maximum L-Shell                       (mxL)                */
/*     OBJV[3]:  Step Size                             (dL)                 */
/*     OBJV[4]:  Minimum L-Shell along LOS             (mnL)                */

#include <tcl.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "ByteDefs.h"
#include "TeuvsimAnsi.h"
#include "TutilAnsi.h"

int LosEndCmd (ClientData Cd, Tcl_Interp *tI, int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8 mnL, mxL, dL;
   ByTe_4 gN, I, J;
   ByTe_1 OK;
   ReaL_8 sTm[3], sMag, hTm[3];
   ReaL_8 Lmax, Ls, Zmin, Zmax;
   ReaL_8 X, Y, Z, XY, tZ, D, L;
   ReaL_8 dX, dY, dZ, V;

   char *Value, Index[10];
   Tcl_Obj *vB, *vE, *iO, *vO;
   int Flg = TCL_LEAVE_ERR_MSG;

/* Make sure that all the IO parameters are present */

   if (objc < 4 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: ZeroSol nP mZ dH zImG");
      return TCL_ERROR;
   }

/* Get the non-array inputs                                                 */

   Tcl_GetIntFromObj (tI, objv[1], &gN);
   Tcl_GetDoubleFromObj (tI, objv[2], &mxL);
   Tcl_GetDoubleFromObj (tI, objv[3], &dL);
   Tcl_GetDoubleFromObj (tI, objv[4], &mnL);

/* Get the global inputs                                                    */

   Tcl_UpVar (tI, "#0", "SaTm",   "sT", 0);
   Tcl_UpVar (tI, "#0", "SaTmM",  "sM", 0);
   Tcl_UpVar (tI, "#0", "HaTm",   "hT", 0);
   Tcl_UpVar (tI, "#0", "LoSBeG", "lB", 0);
   Tcl_UpVar (tI, "#0", "LoSEnD", "lE", 0);

   vB = Tcl_NewStringObj("lB", -1);
   vE = Tcl_NewStringObj("lE", -1);
   iO = Tcl_NewObj();
   vO = Tcl_NewObj();

/* GET the satellite position and distance */

   for (I = 0; I < 3; ++I) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "sT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &sTm[I]);
      }
   }

   if ((Value = Tcl_GetVar(tI, "sM", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &sMag);
   }

/* GET the line of sight vector */

   for (I = 0, J = 3*gN; I < 3; ++I, ++J) {
      sprintf (Index, "%d", J);
      if ((Value = Tcl_GetVar2(tI, "hT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &hTm[I]);
      }
   }

/* COMPUTE L max in L passband */

   Lmax = mxL + dL;

/* COMPUTE L at the satellite */

   XY = sTm[0] * sTm[0] + sTm[1] * sTm[1] + 1.0e-9;  
   Ls = sMag * sMag * sMag / XY;

/* STAGE 1: Trace L back from the satellite until we get to the point where */
/*   its inside the maximum L being considered in the solution.             */

   sprintf(Index, "%d", gN);
   Tcl_SetStringObj (iO, Index, -1);
   if (Ls > Lmax) {
      OK = 1;
      Zmax = sTm[2];
      Zmin = mnL;
      while ( OK ) {
         Z = (Zmax + Zmin) / 2.0;
         tZ = (Z - sTm[2]) / hTm[2];
         X  = tZ * hTm[0] + sTm[0];
         Y  = tZ * hTm[1] + sTm[1];
         XY = X * X + Y * Y + 1.0e-9;   
         D  = sqrt(XY + Z * Z);
         L  = D * D * D / XY;

         if ( L < mxL ) {
            Zmin = Z;
         } else if ( L > Lmax ) {
            Zmax = Z;
         } else { OK = 0; }
      }

      dX = sTm[0] - X;
      dY = sTm[1] - Y;
      dZ = sTm[2] - Z;
      V = sqrt(dX * dX + dY * dY + dZ * dZ);

   } else { V = 0; }  

   Tcl_SetDoubleObj (vO, V);
   Tcl_ObjSetVar2 (tI, vB, iO, vO, Flg);

   OK = 1;
   Z = -sTm[2];
   while ( OK ) {
      tZ = (Z - sTm[2]) / hTm[2];
      X  = tZ * hTm[0] + sTm[0];
      Y  = tZ * hTm[1] + sTm[1];
      XY = X * X + Y * Y + 1.0e-9;   
      D  = sqrt(XY + Z * Z);
      L  = D * D * D / XY;
      if ( L > Lmax ) { 
         OK = 0;
      } else { Z *= 1.5; } 
   }

   OK= 1;
   Zmax = Z;
   Zmin = mnL;
   while ( OK ) {
      Z = (Zmax + Zmin) / 2.0;
      tZ = (Z - sTm[2]) / hTm[2];
      X  = tZ * hTm[0] + sTm[0];
      Y  = tZ * hTm[1] + sTm[1];
      XY = X * X + Y * Y + 1.0e-9;   
      D  = sqrt(XY + Z * Z);
      L  = D * D * D / XY;

      if ( L < mxL ) {
         Zmin = Z;
      } else if ( L > Lmax ) {
         Zmax = Z;
      } else { OK = 0; }
   }

   dX = sTm[0] - X;
   dY = sTm[1] - Y;
   dZ = sTm[2] - Z;
   V = sqrt(dX * dX + dY * dY + dZ * dZ);

   vO = Tcl_DuplicateObj(vO);
   Tcl_SetDoubleObj (vO, V);
   Tcl_ObjSetVar2 (tI, vE, iO, vO, Flg);

   Tcl_DecrRefCount(vB);
   Tcl_DecrRefCount(vE);
   return TCL_OK;
}
