/*  The C equivalent of LoS.                                            */
/*                                                                      */
/*  There are  2 OBJV elements.  These are:                             */
/*     OBJV[0]:  Routine name                                           */
/*     OBJV[1]:  Number of line of sights              (nG)             */
/*     OBJV[2]:  Nadir Angle                           (Nadir)          */
/*     OBJV[3]:  Julian Time Info                      (xT)             */
/*     OBJV[4]:  Rotation Matrix                       (r1T)            */

#include <tcl.h>
#include <stdlib.h>
#include <math.h>
#include "ByteDefs.h"
#include "TeuvsimAnsi.h"
#include "TutilAnsi.h"

int LoSCmd (ClientData Cd, Tcl_Interp *tI, 
                                int objc, Tcl_Obj *CONST *objv) 
{
   ReaL_8  sTm[3], sMag;
   ReaL_8  bX, bY, eX, eY, IncX, IncY;
   ReaL_8  Nadir, r1T[9], xT[46];
   ReaL_8  S, C, xM, yM;
   ReaL_8  TwoPI, RtoD;
   ReaL_8  Ang, cTh, pHat[3], TmP1[3], Hat[3], MaT1[9], MaT2[9];
   ReaL_8  AdotS, minR, B, a, b, c, d, rV[5];
   ReaL_8  minLs, minLsR, T1, T2, tLs, X, Y, V;
   int     nG, nGX, nGY;
   int     mAi[2], mBi[2];
   ByTe_4  rN, cN, nS, I;
   ByTe_4  gN, hC = 0, EnD;

   Tcl_Obj *htO, *liO, *lzO, *gmO, *xsO, *ysO, *iO, *vO;
   char *Value, Index[10];
   int Flg = TCL_LEAVE_ERR_MSG;
 
/* Make sure that all the IO parameters are present */

   if (objc < 5 ) {
      Tcl_WrongNumArgs(tI, 1, objv, "Usage: LoS nG Nadir xInfo r1T");
      return TCL_ERROR;
   }

/* Get the parameters to C format */
  
   Tcl_GetIntFromObj (tI, objv[1], &nG);
   Tcl_GetDoubleFromObj (tI, objv[2], &Nadir);

   if (TclArrayToC (tI, objv[3], (void *)xT, 46, 0, 'D') == 0) {
      return TCL_OK;
   }

   if (TclArrayToC (tI, objv[4], (void *)r1T, 9, 0, 'D') == 0) {
      return TCL_OK;
   }

/* Set up the globals */

   Tcl_UpVar (tI, "#0", "SaTm",  "sT", 0);
   Tcl_UpVar (tI, "#0", "SaTmM", "sM", 0);
   Tcl_UpVar (tI, "#0", "HaTm",  "hT", 0);
   Tcl_UpVar (tI, "#0", "gIMG",  "gI", 0);
   Tcl_UpVar (tI, "#0", "lsImG", "lI", 0);
   Tcl_UpVar (tI, "#0", "lsMnZ", "lZ", 0);
   Tcl_UpVar (tI, "#0", "gMl",   "gM", 0);
   Tcl_UpVar (tI, "#0", "xSM",   "xS", 0);
   Tcl_UpVar (tI, "#0", "ySM",   "yS", 0);

   htO = Tcl_NewStringObj("hT", -1);
   liO = Tcl_NewStringObj("lI", -1);
   lzO = Tcl_NewStringObj("lZ", -1);
   gmO = Tcl_NewStringObj("gM", -1);
   xsO = Tcl_NewStringObj("xS", -1);
   ysO = Tcl_NewStringObj("yS", -1);
   iO  = Tcl_NewObj();
   vO  = Tcl_NewObj();

/* GET the satellite position and distance */

   for (I = 0; I < 3; ++I) {
      sprintf (Index, "%d", I);
      if ((Value = Tcl_GetVar2(tI, "sT", Index, Flg)) != NULL) {
         Tcl_GetDouble (tI, Value, &sTm[I]);
      }
   }

   if ((Value = Tcl_GetVar(tI, "sM", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &sMag);
   }

   if ((Value = Tcl_GetVar2(tI, "gI", "0", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bX);
   } 
   if ((Value = Tcl_GetVar2(tI, "gI", "1", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &eX);
   }
   if ((Value = Tcl_GetVar2(tI, "gI", "2", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &bY);
   } 
   if ((Value = Tcl_GetVar2(tI, "gI", "3", Flg)) != NULL) {
      Tcl_GetDouble (tI, Value, &eY);
   }
   if ((Value = Tcl_GetVar2(tI, "gI", "4", Flg)) != NULL) {
      Tcl_GetInt (tI, Value, &nGX);
   } 
   if ((Value = Tcl_GetVar2(tI, "gI", "5", Flg)) != NULL) {
      Tcl_GetInt (tI, Value, &nGY);
   }

   IncX = (eX - bX) / (ReaL_8)nGX;
   IncY = (eY - bY) / (ReaL_8)nGY;

   C = sTm[0] * sTm[0] + sTm[1] * sTm[1];
   S = sMag * sMag;
   TwoPI = 2.0 * 3.14159265358979323846;
   RtoD  = 180.0 / 3.14159265358979323846;

   for (gN = 0 ; gN < nG ; ++gN) {

/* GET the EUV pixel elevation and satellite phase angle assocaiated  */
/*    with this pixel                                                 */

       cN = gN / nGY;
       rN = gN % nGY;
       xM = (cN + 0.5) * IncX + bX;
       yM = (rN + 0.5) * IncY + bY;

/* COMPUTE a the look direction.  This is a unit vector along the line of */
/*   sight                                                                */

       Ang = yM / RtoD + Nadir; 
       Ang = fmod(Ang, TwoPI);
       cTh = cos(xM / RtoD);

       pHat[0] = cos(Ang) * cTh;
       pHat[1] = sin(Ang) * cTh;
       pHat[2] = sin(xM / RtoD);

/* PRODUCE look directions in the SM reference frame  The look direction */
/*   is saved for each pixel as it is used in all later iterations.      */

       mAi[0] = 3 ; mAi[1] = 3; mBi[0] = 3 ; mBi[1] = 1;
       MatrixMath_C (r1T, '*', pHat, Hat, mAi, mBi);
  
       MatrixMath_C (&xT[19], '*', &xT[10], MaT1, mAi, mAi);
       MatrixMath_C (&xT[28], '*', MaT1, MaT2, mAi, mAi);
       MatrixMath_C (MaT2, '*', Hat, TmP1, mAi, mBi);

       for (I = 0; I < 3; ++I) {
          sprintf (Index, "%d", hC++);
	  Tcl_SetStringObj (iO, Index, -1);
          Tcl_SetDoubleObj (vO, TmP1[I]);
          Tcl_ObjSetVar2 (tI, htO, iO, vO, Flg);
          vO = Tcl_DuplicateObj(vO);
       }

/* FIND the location of the look direction with the SM equatorial plane.    */
/*  This is done by finding the SM location of the smallest L-Shell passed  */
/*  through by the LOS.  This method allows for correct solution even when  */
/*  the orbit is highly canted with respect to the SM equator.              */

       AdotS = 0.0;
       for (I = 0; I < 3; ++I ) { AdotS += TmP1[I] * sTm[I]; }
       minR = sqrt(S - AdotS * AdotS);

/* FIND the minimum L-shell along the line of sight. */

       B = TmP1[0] * sTm[0] + TmP1[1] * sTm[1];
       a = TmP1[0] * TmP1[0] + TmP1[1] * TmP1[1];
       b = 4.0 * B - a * AdotS;
       c = 3.0 * C + 2.0 * B * AdotS - 2.0 * a * S;
       d = 3.0 * AdotS * C - 2.0 * B * S;
       nS = SolveCubic_C (a, b, c, d, rV);
   
       EnD = ( nS == 3 ) ? 3 : 1;
       minLs = 1.0e20;
       for (I = 0; I < EnD; ++I) {
         if ( rV[I] >= 0.0 ) {
            T1 = rV[I] * rV[I]  + 2.0 * rV[I] * AdotS + S;
            T2 = a * rV[I] * rV[I] + 2.0 * rV[I] * B + C;
            tLs = T1 * sqrt(T1) / T2;
            if ( tLs < minLs ) { 
               minLs = tLs; 
               minLsR = rV[I];
            }
         }
      }

      sprintf (Index, "%d", gN);
      Tcl_SetStringObj (iO, Index, -1);
      if ( minLs < 100.0 ) {
         Tcl_SetDoubleObj (vO, minLs);
         Tcl_ObjSetVar2 (tI, liO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         V = TmP1[2] * minLsR + sTm[2];
         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, lzO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         X = TmP1[0] * minLsR + sTm[0];
         Y = TmP1[1] * minLsR + sTm[1];
         V = atan2(Y, X);
         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, gmO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         X = minLs * cos(V);
         Y = minLs * sin(V);

         Tcl_SetDoubleObj (vO, X);
         Tcl_ObjSetVar2 (tI, xsO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         Tcl_SetDoubleObj (vO, Y);
         Tcl_ObjSetVar2 (tI, ysO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);
      } else {
         V = 1000.0;
         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, liO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, lzO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

	 V = 400.0;
         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, gmO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, xsO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);

         Tcl_SetDoubleObj (vO, V);
         Tcl_ObjSetVar2 (tI, ysO, iO, vO, Flg);
         vO = Tcl_DuplicateObj(vO);
      }
   }

   Tcl_DecrRefCount(htO);
   Tcl_DecrRefCount(liO);
   Tcl_DecrRefCount(lzO);
   Tcl_DecrRefCount(gmO);
   Tcl_DecrRefCount(xsO);
   Tcl_DecrRefCount(ysO);
   return TCL_OK;
}
