#  THIS procedure reads in all the data necessary to do a single inversion.
#    The ancillary data is located according to the first time in the 
#    current EUV image.

proc GetUDFdata { SetUpInfo } {
   global euvANS Pidf0 ExPhi0 ExDa SuN SaT SpiN Yr Dy Msec miImG WinInfo gIMG

   upvar $SetUpInfo sI

   set Ver 0
   set N 0
   UDFInits

# INITIALIZE the grid now then set the action to ADD

   TUdataGrid 0 1 Dummy Dummy 1 Dummy Dummy Dummy miImG NrM gIMG
   set gIMG(10) ADD

# ACCUMULATE one image worth of data.

# START by trying to figure out how much of the EUV image we need to pick
# up.  Slow enough as it is - no need to get all of it if we don't have to

   set Beg [expr int(346 - $gIMG(2) / .6)]
   set End [expr int(346 - $gIMG(3) / .6)]
   if { $Beg > $End } {
      set Tmp $Beg
      set Beg $End
      set End $Tmp
   } 

   set Beg [expr int($Beg - 5 - abs($euvANS(phShift) / .6))]
   set End [expr int($End + 5 + abs($euvANS(phShift) / .6))]

# GET the spin vector orientation - this is the XYZ components in GCI

   ReadUDF $sI(36) $Ver $N $sI(37) 0 0 0
   set SpiN(0) [ConvertToUnits $sI(36) $Ver 0 $sI(38) Data ] 
   ReadUDF $sI(40) $Ver $N $sI(41) 0 0 0
   set SpiN(1) [ConvertToUnits $sI(40) $Ver 0 $sI(42) Data ] 
   ReadUDF $sI(44) $Ver $N $sI(45) 0 0 0
   set SpiN(2) [ConvertToUnits $sI(44) $Ver 0 $sI(46) Data ] 

# GET the Image. Data is in three separate UDF's - one per head.  To
#   keep the C TUdataGrid from beating itself to death transfering 
#   the data mesh back and forth between C and Tcl accumulate one
#   full set of of scan lines from all three heads before gridding.

   set FwD 0
   for { set I $Beg } { $I <= $End } { incr I } {
      ReadUDF $sI(0) $Ver $N $sI(1) $I $FwD 0
      set nSmp $ExDa($N,NSMP)

      if {$I == $Beg } {
         set Yr(0) $ExDa($N,BYR) 
         set Dy(0) $ExDa($N,BDY) 
         set Msec(0) $ExDa($N,BMSEC)
         set pEnD [expr $nSmp - 1]
         ConvertToUnits $sI(0) $Ver 0 $sI(3) rVs SCAN 
         for { set M 0 } { $M < $nSmp } { incr M } { 
            set ScanD($M) [expr $rVs($M) + $euvANS(thShift)]
         }
      }

      ConvertToUnits $sI(0) $Ver 0 $sI(2) rVs
      for { set M 0 } { $M < $nSmp } { incr M } {
         set SenD($M) $rVs($M)
         set Phi($M) [ expr 360.0 - $ExPhi0($M) - $euvANS(phShift)] 
         if {$Phi($M) > 180.0 } { 
             set Phi($M) [ expr $Phi($M) - 360.0] 
         }
      }
 
      ReadUDF $sI(4) $Ver $N $sI(5) $I $FwD 0
      ConvertToUnits $sI(4) $Ver 0 $sI(6) rVs
      set J $nSmp
      for { set M 0 } { $M < $nSmp } { incr M ; incr J } { 
         set SenD($J) $rVs($M)
         set Phi($J) [ expr 360.0 - $ExPhi0($M) - $euvANS(phShift)] 
         if {$Phi($J) > 180.0 } { 
            set Phi($J) [ expr $Phi($J) - 360.0] 
         }
      }

      if { $I == $Beg } { 
         ConvertToUnits $sI(4) $Ver 0 $sI(7) rVs SCAN 
         set J $nSmp
         for { set M 0 } { $M < $nSmp } { incr M ; incr J } { 
            set ScanD($J) [expr $rVs($M) + $euvANS(thShift)]
         }
      }

      ReadUDF $sI(8) $Ver $N $sI(9) $I $FwD 0
      ConvertToUnits $sI(8) $Ver 0 $sI(10) rVs 
      set J [expr 2 * $nSmp]
      for { set M 0 } { $M < $nSmp } { incr M ; incr J } { 
         set SenD($J) $rVs($M)
         set Phi($J) [ expr 360.0 - $ExPhi0($M) - $euvANS(phShift)] 
         if {$Phi($J) > 180.0 } { 
            set Phi($J) [ expr $Phi($J) - 360.0] 
         }
      }

      if { $I == $Beg } { 
         ConvertToUnits $sI(8) $Ver 0 $sI(11) rVs SCAN 
         set J [expr 2 * $nSmp]
         for { set M 0 } { $M < $nSmp } { incr M ; incr J } { 
            set ScanD($J) [expr $rVs($M) + $euvANS(thShift)]
         }
      }

      set nP [expr 3 * $nSmp]
      TUdataGrid $nP 1 ScanD ScanD 1 Phi Phi SenD miImG NrM gIMG
   }

# TERMINATE the image plot

   set gIMG(10) END
   TUdataGrid $nP 1 Dummy Dummy 1 Dummy Dummy Dummy miImG NrM gIMG

# GET the ending time for the image

   set Yr(1) $ExDa($N,EYR) 
   set Dy(1) $ExDa($N,EDY) 
   set Msec(1) $ExDa($N,EMSEC)

   set Tm0 [format "%04d%03d%08d" $Yr(0) $Dy(0) $Msec(0)]
   set Tm1 [format "%04d%03d%08d" $Yr(1) $Dy(1) $Msec(1)]

   if { $euvANS(doPrnt) == 1 } {
      set TiMe [TUtimeFmt 2 $Yr(0) $Dy(0) $Msec(0)]
      set fName "${TiMe}.sim"
      set euvANS(prFile) [open $fName w]
      puts $euvANS(prFile) $TiMe
   }

#  GET the needed OA data over the image time frame.  There may be multiple
#   measurements of each.  Get them all then average

   set OK 1
   set nD 0.0;
   for { set I 0 } { $I < 3 } { incr I } {
     set SuN($I) 0.0 
     set SaT($I) 0.0 
   }
   while { $OK } {
      ReadUDF $sI(12) $Ver $N $sI(13) 0 0 0
      set SuN(0) [expr $SuN(0) + [ConvertToUnits $sI(12) $Ver 0 $sI(14) Data]] 
      ReadUDF $sI(16) $Ver $N $sI(17) 0 0 0
      set SuN(1) [expr $SuN(1) + [ConvertToUnits $sI(16) $Ver 0 $sI(18) Data]] 
      ReadUDF $sI(20) $Ver $N $sI(21) 0 0 0
      set SuN(2) [expr $SuN(2) + [ConvertToUnits $sI(20) $Ver 0 $sI(22) Data]] 
      ReadUDF $sI(24) $Ver $N $sI(25) 0 0 0
      set SaT(0) [expr $SaT(0) + [ConvertToUnits $sI(24) $Ver 0 $sI(26) Data]] 
      ReadUDF $sI(28) $Ver $N $sI(29) 0 0 0
      set SaT(1) [expr $SaT(1) + [ConvertToUnits $sI(28) $Ver 0 $sI(30) Data]] 
      ReadUDF $sI(32) $Ver $N $sI(33) 0 1 0
      set SaT(2) [expr $SaT(2) + [ConvertToUnits $sI(32) $Ver 0 $sI(34) Data]] 
      set Tm [format "%04d%03d%08d" $ExDa($N,EYR) $ExDa($N,EDY) $ExDa($N,EMSEC)]
      set tList [lsort -ascii -increasing [list $Tm0 $Tm1 $Tm]]
      set Pos [lsearch -exact $tList $Tm]
      if {$Pos == 2 } { set OK 0 }
      set nD [expr $nD + 1.0]
   }

   for { set I 0 } { $I < 3 } { incr I } {
      set SuN($I) [expr $SuN($I) / $nD] 
      set SaT($I) [expr $SaT($I) / $nD] 
   }

#  GET the Kp, F10.7 and F30.4 data if it exists

   if { $sI(51) == 0 } {
      ReadUDF $sI(48) $Ver $N $sI(49) 0 0 0
      set euvANS(kP) [ConvertToUnits $sI(48) $Ver 0 $sI(50) Data ] 
   }

   if { $sI(55) == 0 } {
      ReadUDF $sI(52) $Ver $N $sI(53) 0 0 0
      set euvANS(F10.7) [ConvertToUnits $sI(52) $Ver 0 $sI(54) Data ] 
   }

   if { $sI(58) == 0 } {
      ReadUDF $sI(55) $Ver $N $sI(56) 0 0 0
      set euvANS(F30.4) [ConvertToUnits $sI(55) $Ver 0 $sI(57) Data ] 
   }
   
   if {$euvANS(bkPix) > 0 } { RmBkgnd  }
   if { $euvANS(deSpeck) == 1 } {
      TUgridNoise DESPECKLE miImG gIMG $euvANS(speckN) $euvANS(spMin) 0.0
   }
}
