proc TclToolInits { args } {
   global env auto_path PI RtoD TwoPI SySCmDs tcl_platform

# SET up a few constants which can be shared amoung various routines.
# Pi, 2PI, Radians to Degrees

   set PI [expr acos(-1.0)]
   set TwoPI [expr 2.0 * $PI]
   set RtoD [expr 180.0 / $PI]

# GET a listing of all the availabe packages, their requires, and any
#    special packages they may require

   set PkgFile [file join $env(UDFTOOL_HOME) ConFigs PKGrc]
   if ![catch { open $PkgFile } fo]  {
      set Section 0
      while { [gets $fo LiNe] >= 0 } {
         set LiNe [string trim $LiNe]
         set P [string first "#" $LiNe]
	 if { $P == 0 } {
            set Pa [string first "_SECTION1_" $LiNe]
	    if { $Pa > 0 } { set Section 1 }
            set Pa [string first "_SECTION2_" $LiNe]
	    if { $Pa > 0 } { set Section 2 }
	 }
	 set Len [string length $LiNe]
         if { ($P != 0) && ($Len > 0) } {
	    if { $Section == 1 } {
               scan $LiNe "%s %s %s %s" PiD InFo(0) InFo(1) InFo(2)
	       for { set I 0 } { $I < 3 } { incr I } {
	          if [string match "---" $InFo($I)] {
	             lappend PkgInfo($PiD) ""
                  } else { lappend PkgInfo($PiD) $InFo($I) }
               }
            } elseif { $Section == 2 } {
               scan $LiNe "%s %s %s" PiD aL PreQ
	       if ![string match "---" $aL] {
	          set TmP [split $aL ":"]
		  set lLen [llength $TmP]
		  set Fld [lindex $TmP 0]
		  if { [string first "@" $Fld] == 0} {
		     set eV [string range $Fld 1 end]
		     set aP [file join $env($eV)]
                  } else { set aP [file join $Fld] }
                  
		  for { set I 1 } { $I < $lLen } { incr I } {
		     set aP [file join $aP [lindex $TmP $I]]
                  }
		  lappend AP($PiD) $aP
               }
	       if ![string match "---" $PreQ] { lappend AR($PiD) $PreQ } 
	    }
         }
      }
   } else { puts stderr "CAN'T OPEN $PkgFile" ; exit }
   close $fo

# SET up a command list.  This is basically set up to allow Linux general
#   commands to be executed from Tcl/Tk running directly under Windows. This
#   requires: 1 An installation of Cygwin or the like and 2: UNIXCMDS_HOME.

   if [info exists env(UNIXCMDS_HOME)] {
      set UC [file nativename $env(UNIXCMDS_HOME)]
      set SySCmDs(ls)   [file join $UC ls.exe]
      set SySCmDs(gzip) [file join $UC gzip.exe]
      set SySCmDs(tar)  [file join $UC tar.exe]
   } 
   if ![info exists SySCmDs(ls)]   { set SySCmDs(ls) ls     }
   if ![info exists SySCmDs(gzip)] { set SySCmDs(gzip) gzip }
   if ![info exists SySCmDs(tar)]  { set SySCmDs(tar) tar   }
   if [string match window* $tcl_platform(platform)] { 
       set SySCmDs(ext) .exe 
   } else { set SySCmDs(ext) "" }

# FOR some reason on OSX UTILS must be the first sourced package if its
#   in the list otherwise there are complaints of missing routines in any
#   packages which have C-Code which calls it.  So reorder here.

   set pListA UTILS
   set pListB ""
   set usesUtils 0
   set Nargs [llength $args ]
   for { set I 0 } { $I < $Nargs } { incr I } {
      set P [lindex $args $I] 
      if [string match UTILS $P] { 
          set usesUtils 1 
      } else { lappend pListA $P ; lappend pListB $P }
   }

   if $usesUtils { set pList $pListA } else { set pList $pListB }

# NOW loop over input packages and source them

   set TH [file nativename $env(TCLTOOLS_HOME)]
   set Nargs [llength $pList ]
   for { set I 0 } { $I < $Nargs } { incr I } {
      set Error 0
      set P [lindex $pList $I] 

# SPECIAL check for the UDF package which needs to have the Client anad
#   http packages added.

      if [info exists AP($P)] {
         set lLen [llength $AP($P)]
         for { set J 0 } { $J < $lLen } { incr J } {
            lappend auto_path [lindex $AP($P) $J]
         }
      }
      if [info exists AR($P)] {
         set lLen [llength $AR($P)]
         for { set J 0 } { $J < $lLen } { incr J } {
            package require [lindex $AR($P) $J]
         }
      }

      if [info exist PkgInfo($P)] {
         set pD [file join $TH [lindex $PkgInfo($P) 0]]
         if [file exists $pD] {
            lappend auto_path $pD
            for { set J 1 } { $J < 3 } { incr J } {
	       set rP [lindex $PkgInfo($P) $J]
               if { [string length $rP] > 0 } { package require $rP } 
            }
         } else { set Error 1 }
      } else {
          puts stderr "UNKNOWN PACKAGE $P" 
          return -1
      }
      if $Error {
         puts stderr "PACKAGE [lindex $args $I] NOT ON SYSTEM" 
         return -1
      }
   }
}
