package provide UDFAnalysis 1.0

proc APwtGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set mN WAVE-TELESCOPE
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaBa [format $FmT Inputs Outputs Outputs K Freq Phi Theta]
      set LaBb [format $FmT Locations  K  Phi Min Min Min Min]
      set LaBc [format $FmT FFT Freq Theta Max  Max Max Max]
      set LaBd [format $FmT "" "" Power Steps Steps Steps Steps] 

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaBa  w grid|$R|0|w 0 0 #ff0000 $CFonT
      incr R 
      GUILabel $Wc.$R $LaBb  w grid|$R|0|w 0 0 "" $CFonT
      incr R 
      GUILabel $Wc.$R $LaBc  w grid|$R|0|w 0 0 "" $CFonT
      incr R 
      GUILabel $Wc.$R $LaBd  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 6  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      GUILabel $We.lt0  "Inputs" c grid|$R|3|news -1 0 #ff0000 $LFonT
      GUILabel $We.lt1  "Outputs" c grid|$R|7|news -1 0 #ff0000 $LFonT
      GUILabel $We.lt2  "K" c grid|$R|11|news -1 0 #ff0000 $LFonT
      GUILabel $We.lt3  "Freq" c grid|$R|12|news -1 0 #ff0000 $LFonT
      GUILabel $We.lt4  "Phi" c grid|$R|13|news -1 0 #ff0000 $LFonT
      GUILabel $We.lt5  "Theta" c grid|$R|14|news -1 0 #ff0000 $LFonT

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.l0a  "Loc" c grid|$R|1|e -1 0 #0000ff $LFonT
      GUIblankCol $We 2 1
      GUIboxEntry $We.loc grid|$R|3|news 11 apANS($fD,WTlocI)
      GUIblankCol $We 4 5
      GUILabel $We.l0b  "K" c grid|$R|5|w -1 0 #0000ff $LFonT
      GUIblankCol $We 6 1
      GUIboxEntry $We.ofq grid|$R|7|news 11 apANS($fD,WTfreqO)
      GUIblankCol $We 8 5
      GUILabel $We.l0c  "Minimum" c grid|$R|9|w -1 0 #0000ff $LFonT
      GUIblankCol $We 10 1
      GUIboxEntry $We.fmn grid|$R|11|news 11 apANS($fD,WTmnFq)
      GUIboxEntry $We.kmn grid|$R|12|news 11 apANS($fD,WTmnK)
      GUIboxEntry $We.pmn grid|$R|13|news 11 apANS($fD,WTmnPh)
      GUIboxEntry $We.tmn grid|$R|14|news 11 apANS($fD,WTmnTh)

      incr R 
      GUILabel $We.l1a  "FFT" c grid|$R|1|e -1 0 #0000ff $LFonT
      GUIboxEntry $We.fft grid|$R|3|news 11 apANS($fD,WTfftI)
      GUILabel $We.l1b  "Freq" c grid|$R|5|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.ok grid|$R|7|news 11 apANS($fD,WTkO)
      GUILabel $We.l1c  "Minimum" c grid|$R|9|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.fmx grid|$R|11|news 11 apANS($fD,WTmxFq)
      GUIboxEntry $We.kmx grid|$R|12|news 11 apANS($fD,WTmxK)
      GUIboxEntry $We.pmx grid|$R|13|news 11 apANS($fD,WTmxPh)
      GUIboxEntry $We.tmx grid|$R|14|news 11 apANS($fD,WTmxTh)

      incr R 
      GUILabel $We.l2b  "Phi" c grid|$R|5|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.oph grid|$R|7|news 11 apANS($fD,WTphO)
      GUILabel $We.l2c  "Steps" c grid|$R|9|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.fsk grid|$R|11|news 11 apANS($fD,WTstFq)
      GUIboxEntry $We.ksk grid|$R|12|news 11 apANS($fD,WTstK)
      GUIboxEntry $We.psk grid|$R|13|news 11 apANS($fD,WTstPh)
      GUIboxEntry $We.tsk grid|$R|14|news 11 apANS($fD,WTstTh)

      incr R 
      GUILabel $We.l3b  "Theta" c grid|$R|5|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.oth grid|$R|7|news 11 apANS($fD,WTthO)

      incr R 
      GUILabel $We.l4b  "Power" c grid|$R|5|w -1 0 #0000ff $LFonT
      GUIboxEntry $We.opwr grid|$R|7|news 11 apANS($fD,WTpwrO)

      bind $W <Down> { APtwinCmd WAVE-TELESCOPE %W MOVE DOWN }
      bind $W <Up> { APtwinCmd WAVE-TELESCOPE %W MOVE UP }

      APallInits $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI  $mN $fD

   } else { GUIwindowCtrl $W }
}
