package provide UDFAnalysisTh 1.0

proc APsolveMEM { fD } {
   global apANS env Prefs

# THIS is the code which can be evoked when running a thread.  It consists 
#    of an FFT procedure and an MEM procedure.
 
   set PgmA {
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD FFT UTILS
      lappend auto_path [file join $env(TCLTOOLS_HOME) TclAnalysisTh]
      package require UDFAnalysis
      package require UDFAnalysisTh

# ----------------------------
# THIS is the MeM procedure
# ----------------------------
 
      proc MeM { rN pNames oSkip } {

# XFer the input data from tsv space to local to this subroutine
 
         THarrayXfer FROM _In _In$rN YES

# Copy some basic variable definitions from tsv space
 
         set nE  [tsv::get MvR nE$rN]
         set _C  [tsv::get MvR _C]
         set dT  [tsv::get MvR dT]
         set _nFq  [tsv::get MvR _nFq]

# SET the return power spectral dimension.
 
	 set _pW(Dim) [list $_nFq 1]

# CHECK for bad data in the input array and fill any holes in the array
 
         APfillHoles $nE _In LI
 
# COMPUTE the MEM predictor coefficients
 
         set MsD [MaxEntCoef _In $nE $_C _CoeF]

# COMPUTE the power at the request frequencies.

         for { set K 0 } { $K < $_nFq } { incr K } {
            set FdT [expr [tsv::get _freQ $K] * $dT]
	    set _pW($K) [MaxEntPwr _CoeF $_C $FdT $MsD]
         }

# COMPUTE the total tiem covered by the power spectra
 
	 set _pW(Tt) [expr $dT * double($nE)]

# TRANSFER the output spectral power to tsv space

         THarrayXfer TO _pW [lindex $pNames $rN]
      }
   

# ----------------------------
# THIS is the FFT procedure
# ----------------------------
 
      proc FfT { rN pNames oSkip } {

# XFer the input data from tsv space to local to this subroutine

         THarrayXfer FROM _In _In$rN YES

# Copy some basic variable definitions from tsv space
#
         set nE  [tsv::get MvR nE]
         set PaD [tsv::get MvR PaD]

# FORM the array the FFT is based on
 
         for { set L 0 } { $L < $nE } { incr L } { set _pD($L) $_In($L) }
         for { set L $nE } { $L < $PaD } { incr L } { set _pD($L) 0.0 }

# SET the spectral array dimension, the frequency step size, and the total
#    time covered by the spectra
 
         set _pW(Dim) [list [tsv::get MvR nF] 1]
         set _pW(dF)  [tsv::get MvR dF]
         set _pW(Tt)  [tsv::get MvR Tt]

# FILL any holes in the input array
 
         APfillHoles $PaD _pD LI

# SOLVE for the FFT
 
         RealFfT _pD $PaD 1

# EITHER compute the total power at each frequency step or split the spectra
#   into ite real and complex components.
 
         if [string match POWER [tsv::get MvR _Rt]] {
            set NrM [expr 1.0 / double($nE)]
	    set N 0
            for { set M 0 } { $M < [tsv::get MvR nF] } { incr M ; incr N } { 
               set T1 [expr $_pD($N) * $_pD($N)] ; incr N
               set T2 [expr $_pD($N) * $_pD($N)]
               set _pW($M) [expr ($T1 + $T2) * $NrM]
            }
         } else {
            set _pWa(Dim) [list [tsv::get MvR nF] 1]
	    set N 0
            for { set M 0 } { $M < [tsv::get MvR nF] } { incr M ; incr N } { 
               set _pW($M) $_pD($N) ; incr N
               set _pWa($M) $_pD($N)
            }
         }

# TRANSFER the one or two computed power spectra to tsv space
 
         set OfF [expr $rN * $oSkip]
         THarrayXfer TO _pW [lindex $pNames $OfF]
         if [string match RAW [tsv::get MvR _Rt]] {
            incr OfF
            THarrayXfer TO _pWa [lindex $pNames $OfF]
         }
      }
   }

#XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
# THE function begins here
#XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nFc [$W index end]

# NO instances then return

   if { $nFc == 0 } { return }

# OPEN up the thread pool
 
   set tPoolID [THpoolOpen $PgmA]

# LOOP over the instances

   for { set I 0 } { $I < $nFc } { incr I } {

      APkeepTabs "STEP $fD : MEM($I)"

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s %s %s" \
                                    _vI _pW _fQ _C _bF _eF _nFq _fSp _Pd _Rt

      tsv::set MvR _Rt $_Rt

# CHECK for empty _C field. If its empty or is 0 then the spectra a formed
#    using an FFT algorithm, otherwise, an MEM algorithm is used.
 
      if [string match $apANS(EmptyVar) $_C] { set _C 0 }

# GET the input variable list

      set iNames [lindex [APgetVNames $_vI] 0 ]
      set nI [llength $iNames]

# GET the power variable list

      set pNames [lindex [APgetVNames $_pW] 0]
      set nP [llength $pNames]

# CHECK to see there are enough defined output variables.
 
     if { ($_C  <= 0) && [string match RAW $_Rt] } {
        set oSkip 2
        if { [expr 2 * $nI] < $nP } { 
	   puts stderr "Too few output variables for return Raw FFT"
	   exit
        }
     } else {
        set oSkip 1
        if { $nI < $nP } { 
	   puts stderr "Too few output variables for return Power"
	   exit
        }
     }

# GET the Frequency variable list - should only be one variable so take what
#   you get

      set rV [APgetVNames $_fQ]
      set vR [lindex [lindex $rV 0] 0]
      global [set vR ] ; upvar 0 [set vR] _freQ

# INITIALIZE the list of thread jobs defined.
 
      set JoBs []

# IF _C is <= 0 then use FFT rather than an MEM.

     if { $_C > 0 } {

        set _freQ(Dim) [list $_nFq 1]

# FORM the frequency array.  How this is formed depends on the point spacing
#   chosen

         set nFb [expr double($_nFq) - 1.0] 
         if [string match LINEAR $_fSp] {
            set dF [expr ($_eF - $_bF) / $nFb]

            for { set J 0 } { $J < $_nFq } { incr J } {
               set _freQ($J) [expr $_bF + $J * $dF]
            }
         } else {
	    set _lbF [expr log10($_bF)]
            set dF [expr (log10($_eF) - $_lbF) / $nFb]

            for { set J 0 } { $J < $_nFq } { incr J } {
               set _freQ($J) [expr pow(10.0, $_lbF + $J * $dF)]
            }
         }

# TRANSFER the frequency array to tsv space.  This only needs to be done
#   when using the MEM algorithm to construct the power spectra.
 
         THarrayXfer TO _freQ _freQ

# Since all the input arrays have the same length (or should) open the
#    the first to get some basic information and transfer that and some
#    other information from the function definition to tsv space.
 
         set vR [lindex $iNames 0]
         global [set vR] ; upvar 0 [set vR] _In
         set nE [lindex $_In(Dim) 0]
	 set dT $_In(gIcZ)

	 tsv::set MvR nE $nE
	 tsv::set MvR dT $dT
	 tsv::set MvR _C $_C
	 tsv::set MvR _nFq $_nFq

# ASSUMPTION is that there is one power variable per input variable.  All
#    have the same frequency steps.  Run each MEM instance as a thread.

         for { set J 0 } { $J <  $nI } { incr J } {
            set vR [lindex $iNames $J]
            global [set vR] ; upvar 0 [set vR] _In

# GET rid of any bad data which are on the leading or trailing edges of the
#    the array.  This probably has its origin in a previously called filter
#    function.
 
            set Ne [APsolveTrim $nE _In _nIn < $apANS(BaDL)]

# XFET the data to tsv space
 
            THarrayXfer TO _nIn _In$J
	    unset _nIn
	    tsv::set MvR nE$J $Ne

            lappend JoBs [THschdTask $tPoolID [list MeM $J $pNames 0]]
         }
         THjobsDone $tPoolID $JoBs

# TRANSFER the poser spectra from tsv space to the output variable.
 
         for { set J 0 } { $J <  $nI } { incr J } {
	    set vR [lindex $pNames $J]
	    global [set vR] ; upvar 0 [set vR] _PwR
            THarrayXfer FROM _PwR [lindex $pNames $J] YES
         }

# RELEASE any tsv memeory in use
 
         tsv::unset MvR
         tsv::unset _freQ
      } else {

#                                       FFT
#
# GET the number of elements in the input variables.

         set vR [lindex $iNames 0]
         global [set vR] ; upvar 0 [set vR] _In
         set nE [lindex $_In(Dim) 0]
	 set dT $_In(gIcZ)

	 tsv::set MvR nE $nE

# Get a PAD value so data has 2^N elements
 
         set PaD 1
	 while { $PaD <= $nE } { set PaD [expr $PaD << 1] }

	 if [string match NO $_Pd] {
	    if { $PaD > $nE } { set PaD [expr $PaD >> 1] }
	    set Tt [expr $dT * double($PaD)]
	 } else { set Tt [expr $dT * double($nE)] }

	 tsv::set MvR Tt $Tt
	 tsv::set MvR PaD $PaD

# FORM the frequency array.
 
	 set dF [expr 1.0 / $dT / double($PaD)]
         set nF [expr $PaD / 2]
	 tsv::set MvR dF $dF
	 tsv::set MvR nF $nF
         for { set J 0 } { $J < $nF } { incr J } { 
	    set _freQ($J) [expr $J * $dF]
         }
         set _freQ(Dim) [list $nF 1]

# ADD PaD and _freQ to the thread MEMsp variable
 
	 tsv::set MEMsp PaD $PaD

# ASSUMPTION is that there is one power variable per input variable.  All
#    have the same frequency steps

         for { set J 0 } { $J <  $nI } { incr J } {
            set vR [lindex $iNames $J]
            global [set vR] ; upvar 0 [set vR] _In

# XFER the data array to thread space

            THarrayXfer TO _In _In$J
	    lappend JoBs [THschdTask $tPoolID [list FfT $J $pNames $oSkip]]
         }
         THjobsDone $tPoolID $JoBs

         for { set J 0 } { $J <  $nI } { incr J } {
            set OfF [expr $J * $oSkip]
	    set vR [lindex $pNames $OfF]
	    global [set vR] ; upvar 0 [set vR] _PwR
            THarrayXfer FROM _PwR [lindex $pNames $OfF] YES
            if [string match RAW $_Rt] {
               incr OfF
	       set vR [lindex $pNames $OfF]
	       global [set vR] ; upvar 0 [set vR] _PwR
               THarrayXfer FROM _PwR [lindex $pNames $OfF] YES
            }
         }
	 tsv::unset MvR
      }
   }
   THpoolClose $tPoolID
}
