package provide UDFAnalysis 1.0

# Produces a Probability Distribution Function.  If the data is time based
#   and gridded it will be run over the grids which contain the plot time.

proc APsolveHLine { gD } {
   global apANS env Prefs WinInfo PltInfo GphInfo

   APkeepTabs "OBJECT $gD : H-LINE"

# THIS is the text window for this function definition

   set W .apGOBJ$gD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($gD,gObj)) 0]
      eval $GuI $gD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s" pID X1 X2 Y1 lC lW lS

# FROM the plot iD get the plot number, window number and the index into 
#   the plot definitions where the plot information is contained.

      set pS [lindex $apANS($pID) 0]
      set pN $apANS($pS,Col).$apANS($pS,Row)
      set wN $PltInfo($pN,wN)

# IF this is a time based plot we need to convert the X input which should
#   be in the format YYYY DOY HH MM SS.FSEC to a proper X value

      if [string match SPAN $X1] {
         set X1 $WinInfo($wN,p0)
         set X2 $WinInfo($wN,p3)
      } elseif [string match YES $apANS($pS,tBased)] {
         set T [split $X1 ":"]
	 set xS [expr 3600 * [lindex $T 2] + 60 * [lindex $T 3] + [lindex $T 4]]
	 set xMs [expr int(1000 * $xS)]
	 set pB [list $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs) 0]
	 set xB [list [lindex $T 0] [lindex $T 1] $xMs]
	 set X1 [TUtimeConv $pB $xB 0 apANS(tBase)]

         set T [split $X2 ":"]
	 set xS [expr 3600 * [lindex $T 2] + 60 * [lindex $T 3] + [lindex $T 4]]
	 set xMs [expr int(1000 * $xS)]
	 set xB [list [lindex $T 0] [lindex $T 1] $xMs]
	 set X2 [TUtimeConv $pB $xB 0 apANS(tBase)]
      }

      set tColor $GphInfo(lColor)
      set tStyle $GphInfo(lStyle)
      set tWidth $GphInfo(lWidth)

      LineStyle $lW $lS
      PlotColor HOLD $lC OFF
      Line $wN $X1 $Y1 0.0 $X2 $Y1 0.0
      LineStyle $tWidth $tStyle
      PlotColor HOLD $tColor OFF
   }
}
