package provide UDFAnalysisTh 1.0

proc APsolveFilter { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : FILTER"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

   set PgmA {
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD UTILS FFT
      lappend auto_path [file join $env(TCLTOOLS_HOME) TclAnalysisTh]
      package require UDFAnalysis
      package require UDFAnalysisTh

      proc FilTer { rN iNames oNames } {

# SETUP some of the common varaibles used in the processing

         set _sO [tsv::set FltR _sO]
         set _dO [tsv::set FltR _dO]
         set uH [tsv::set FltR uH]
         set lH [tsv::set FltR lH]
         set mR [tsv::set FltR mR]
         set nR [tsv::set FltR nR]

	 set rVar [expr $nR * $rN]

	 set iN [expr $rN / $nR]

# THIS is the input variable name

         set vR [lindex $iNames $rN]

# COPY the input data array local space and delete the input data array
#  from tsv space

         THarrayXfer FROM _TmP $vR YES

# GET the X and Y dimensions of the variable and set nE to the
#   largest dimension

	 set nX [lindex $_TmP(Dim) 0]
	 set nY [lindex $_TmP(Dim) 1]
	 if {$nY > 1 } { set nE $nY } else { set nE $nX }

# GET rid of bad data - set it to 0

         APbadGrid FANDC $nE _TmP NoData 0

# THIS is the binary length we need

         set bL 1
         while { $bL < $nE } { set bL [expr $bL * 2] }

# AND pad the data to the binary length

         for { set K $nE } { $K < $bL } { incr K } { set _TmP($K) 0.0 }

# Different approachs are used if the band edges match or are different.

         if { $mR == 2 } {

# IN this case work only with the upper edge so this band includes everything 
#   below uEdge and is the lower band.   

# FILTER the data to the upper cutoff

            set tC [ expr 2 * $uH + 1]
            TUsavgolCoef _C $tC $uH $uH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Hi

# Form the returns and mask off corrupt data if requested

            for { set K 0 } { $K < $nR } { incr K ; incr rVar } {
               set _fR(Dim) [list $nE 1]
	       APxferGInfo _TmP _fR 

	       if [string match L [tsv::get B $K]] {
                  for { set L 0 } { $L < $nE } { incr L } { 
	             set _fR($L) $_Hi($L) 
	          }
               } else {
                  for { set L 0 } { $L < $nE } { incr L } {
                     set _fR($L) [expr $_TmP($L) - $_Hi($L)]
                   }
               }

               APbadGrid RESET $nE _fR NoData 0 [tsv::get apANS BaD] 

               if [string match YES [tsv::get FltR _fMsK]] {
                  set M  [expr $nE -1]  
                  for { set L 0 } { $L < $uH } { incr L ; incr M -1 } {
	             set _fR($L) [tsv::get apANS BaD]  
		     set _fR($M) [tsv::get apANS BaD]
	          }
               }

               set _vO [lindex $oNames $rVar]
	       THarrayXfer TO _fR $_vO
            }
         } else {

# FILTER the data to the lower cutoff

            set tC [ expr 2 * $lH + 1]
            TUsavgolCoef _C $tC $lH $lH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Lw

# FILTER the data to the upper cutoff

            set tC [ expr 2 * $uH + 1]
            TUsavgolCoef _C $tC $uH $uH $_dO $_sO
            FfTConvolve _TmP $bL _C $tC CONVOLVE _Hi

# Form the returns and mask off corrupt data if requested

            for { set K 0 } { $K < $nR } { incr K ; incr rVar } {
               set _fR(Dim) [list $nE 1]
	       APxferGInfo _TmP _fR 

	       switch -exact -- [tsv::get B $K] {
	          H {
                     for { set L 0 } { $L < $nE } { incr L } { 
                       set _fR($L) [expr $_TmP($L) - $_Hi($L)]
                     } 
		     set EnD $uH
		  }
	          L {
                     for { set L 0 } { $L < $nE } { incr L } { 
		        set _fR($L) $_Lw($L) 
		     }
		     set EnD $lH
                  } 
	          B {
                     for { set L 0 } { $L < $nE } { incr L } {
                        set _fR($L) [expr $_Hi($L) - $_Lw($L)]
                     } 
                     if { $uH > $lH } { set EnD $uH } else { set EnD $lH }
                  }
	          N {
                     for { set L 0 } { $L < $nE } { incr L } {
                        set _fR($L) [expr $_TmP($L) - $_Hi($L) + $_Lw($L)]
                     } 
                     if { $uH > $lH } { set EnD $uH } else { set EnD $lH }
                  }
               }

               APbadGrid RESET $nE _fR NoData 0 [tsv::get apANS BaD]

               if [string match YES [tsv::set FltR _fMsK]] {
                  set M  [expr $nE -1]  
                  for { set L 0 } { $L < $EnD } { incr L ; incr M -1 } {
	             set _fR($L) [tsv::get apANS BaD]
		     set _fR($M) [tsv::get apANS BaD]
	          }
               }
               set _vO [lindex $oNames $rVar]
	       THarrayXfer TO _fR $_vO
            }
         }
      }
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# OPEN up the thread pool

   set tPoolID [THpoolOpen $PgmA]

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s" _vI _vO _f(0) _f(1) _sO _dO _fMsK _R

# GET what's to be returned

      set nR [string length $_R]
      if { $nR == 0 } { continue }
      for { set J 0 } { $J < $nR } { incr J } {
         set B($J) [string index $_R $J]
      }
      THarrayXfer TO B B
      
# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

      set vR [lindex $iNames 0]
      global [set vR] ; upvar 0 [set vR] _tV_

      set _tX_ [expr (double($_tV_(gI1)) - double($_tV_(gI0))) / double($_tV_(gI4))]

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]

# Frequency bounds need to be gotten depending on if they are entered in
#    constant or variable format
 
   for { set J 0 } { $J < 2 } { incr J } {
      set rV [APgetVNames $_f($J)]
      set vNames [lindex $rV 0]
      set bType  [lindex $rV 1]
      set vType  [lindex $bType 0]
      if { [lindex $bType 0] != 1 } {
         set _oP [string first "(" $_f($J)]
	 set _cP [string first ")" $_f($J)]
	 set _fn [string range $_f($J) 0 [expr $_oP - 1]]
	 set _fi [string range $_f($J) $_oP end]
	 set sNames [lindex [APgetVNames $_fn] 0]
	 set vR [lindex $sNames 0]
	 global  [set vR] ; upvar 0 [set vR] _TAr

         set _T \$$vR$_fi
         set _fQ($J) [expr $_T]
      } else { set _fQ($J) $_f($J) }
   }

# THIS is the number of samples per second

      set sPs [expr 1.0 / $_tX_]

# THIS is the SAVITSKY-GOLAY inputs for this band.  The filter length is the 
#   number of points which makes up 1/2 cycle of the lower defined band 
#   frequency.  I have no idea if this is right or not but it sounds good
#   and seems to bear out in tests.

      set lCycLen [expr 1.0 / $_fQ(0)]
      set lH [expr int($sPs * $lCycLen / 2.0)]
      if { $lH < 2 } { 
	 puts stderr "Too Few Points in Lower Filter ($lH) - set to 2" 
         set lH 2 
      }

      set uCycLen [expr 1.0 / $_fQ(1)]
      set uH [expr int($sPs * $uCycLen / 2.0)]
      if { $uH < 2 } { 
	 puts stderr "Too Few Points in Upper Filter ($uH) - set to 2" 
         set uH 2 
      }

      if { $_fQ(0) == $_fQ(1) } { set mR 2 } else { set mR 4 }
      if { $nR > $mR } { set nR $mR }

      tsv::set FltR _sO $_sO
      tsv::set FltR _dO $_dO
      tsv::set FltR _fMsK $_fMsK
      tsv::set FltR uH $uH
      tsv::set FltR lH $lH
      tsv::set FltR mR $mR
      tsv::set FltR nR $nR

# LOOP over the input variables

      for { set J 0 } { $J < $nI } { incr J } {

         set vR [lindex $iNames $J]
         global [set vR] ; upvar 0 [set vR] _In

# GET rid of any bad data which are on the leading or trailing edges of the
#    the array.  This probably has its origin in a previously called filter
#    function.
#
         set nE [lindex $_In(Dim) 0] 
	 set Ne [APsolveTrim $nE _In _nIn < $apANS(BaDL)]
	 
	 set _nIn(Dim) [list $Ne 1]
	 THarrayXfer TO _nIn $vR
	 unset _nIn

	 lappend JoBs [THschdTask $tPoolID [list FilTer $J $iNames $oNames]]
      }
      THjobsDone $tPoolID $JoBs

      set rVar 0
      for { set J 0 } { $J < $nI } { incr J } {
         for { set K 0 } { $K < $nR } { incr K ; incr rVar } {
            set vR [lindex $oNames $rVar]
            global [set vR] ; upvar 0 [set vR] _fR
	    THarrayXfer FROM _fR $vR YES
	    APxferGInfo _In _fR 
         }
      }
   }

   tsv::unset FltR
   tsv::unset B
   THpoolClose $tPoolID
}
