package provide UDFAnalysis 1.0

# Build a grid definition array

proc APsolveDGrid { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : DEFINE GRID"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function. Remember each
#   entry occupes two lines

   set nF [expr [$W index end] / 2]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   set Ln 0
   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line in the entry and break it appart
   
      set LiNe [$W get $Ln]
      incr Ln
      scan $LiNe "%s %s %s %s %s %s %s %s %s" \
                             _giV _xMn _xMx _xCells _xF _xSca _xCyc _iMn _gIX

# DO the same for the next line

      set LiNe [$W get $Ln]
      incr Ln
      scan $LiNe "%s %s %s %s %s %s %s %s" \
                             _yMn _yMx _yCells _yF _ySca _yCyc _iMx _gIY

# GET the grid information variable - should only be one variable so take what
#   you get.  A grid definition is an array of size 19.  Assign it an aType
#   of GINFO.

      set gName [lindex [lindex [APgetVNames $_giV] 0] 0]
      global [set gName ]
      upvar 0 [set gName] _gV
      set _gV(Dim) [list $apANS(numGI) 1]

      set _gV(aType) GINFO

# CREATE the grid information array.  If the X Min and Max variables are
#   left blank then the min and max values are set according to the start
#   and stop plot times and the number cells is assumed to be the dT for
#   each cell.  If this is left blank then it is set according to what 
#   is used for the system wide time grid.

      set sMn [string match $apANS(EmptyVar) $_xMn] 
      set sMx [string match $apANS(EmptyVar) $_xMx] 
      set sNc [string match $apANS(EmptyVar) $_xCells] 

      if { $sMn || $sMx } {
         set bT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
         set eT [list $apANS(endYr) $apANS(endDy) $apANS(endMs) 0]

	 set _gV(0)  [TUtimeConv $bT $bT 0 apANS(tBase)]
         set _gV(1) [TUtimeConv $bT $eT 0 apANS(tBase)]

         if $sNc { set cT $apANS(CellSz) } else { set cT $_xCells } 
	 set dT [expr $_gV(1) - $_gV(0)]
	 if { [expr fmod($dT, $cT)] != 0.0 } {
	      set _gV(4) [expr int($dT / $cT) + 1]
	 } else { set _gV(4) [expr int($dT / $cT)] }
	 set _gV(gItB) YES
      } else {
         set _gV(0) $_xMn
         set _gV(1) $_xMx
         set _gV(4) $_xCells
	 set _gV(gItB) NO
	 set cT 1.0
      }

      set _gV(2) $_yMn
      set _gV(3) $_yMx

      set _gV(5) [expr int($_yCells)]
      set _gV(6) $_xF
      set _gV(7) $_yF
      set _gV(8) COLUMN
      set _gV(9) KEEP
      set _gV(10) NEW:ADD:END
      set _gV(11) $apANS(BaD)
      set _gV(12) $apANS(BaD)
      set _gV(13) $_iMn
      set _gV(14) $_iMx
      set _gV(15) $_xCyc
      set _gV(16) $_yCyc
      set _gV(17) $_xSca
      set _gV(18) $_ySca

      set _gV(gInE) $apANS(numGI)
      set _gV(gIcZ) $cT

# CHECK to see if we need to return the x grid cell centers.

      if ![string match $apANS(EmptyVar) $_gIX] {
         set _gX [lindex [lindex [APgetVNames $_gIX] 0] 0]
         global [set _gX ];  upvar 0 [set _gX] _cX
	 set _cX(Dim) [list [TUgridInfo 32 _gV _cX] 1]
      }

# CHECK to see if we need to return the y grid cell centers.

      if ![string match $apANS(EmptyVar) $_gIY] {
         set _gY [lindex [lindex [APgetVNames $_gIY] 0] 0]
         global [set _gY ];  upvar 0 [set _gY] _cY
	 set _cY(Dim) [list [TUgridInfo 33 _gV _cY] 1]
      }
   }
}
