# CUT operations
#
# THIS procedure collapses a 2D or 1D raw data set into either a 1D grid 
#   or to a single value.  This will work on gridded data but pretends 
#   its raw.  Mn and Mx are indices into the data.

package provide UDFAnalysis 1.0

proc APsolveCut { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : CUT"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s" _vIN _vOUT _cDir _Mn _Mx

# GET the input variable list

      set iNames [lindex [APgetVNames $_vIN] 0]
      set nI [llength $iNames]

# GET the output variable list

      set oNames [lindex [APgetVNames $_vOUT] 0]
      set nO [llength $oNames]

      if { $nI > $nO } {
         puts stderr "CUT Line $I:"
         puts stderr "     Mismatch in number of In and Out varaibles"
	 continue
      }

# LOOP over the input variables on this line. 

      for { set K 0 } { $K <  $nI } { incr K } {

# INPUT and OUTPUT variables

         set vR [lindex $iNames $K] ; global [set vR] ; upvar 0 [set vR] _vI
         set vR [lindex $oNames $K] ; global [set vR] ; upvar 0 [set vR] _vO

         if [info exists _vI(gInE)] { 
            APxferGInfo _vI _gI DATA REVERSE
	    set xL _$gI(4)
	    set yL _$gI(5)
         } else {
	    set xL [lindex $_vI(Dim) 0]
	    set yL [lindex $_vI(Dim) 1]
         }

# GET the number of elements being collapsed over and set up the start
#   and stop indices.  _Mx can be set to MAX to indicate summing over
#   all elements.  Need to check that neither _Mn nor Mx is set larger
#   than the actual maxumim index.

	 if [string match X $_cDir] {
	    set mI [expr $xL - 1] 
         } else { set mI [expr $yL - 1] }

	 if ![string match MAX $_Mx] { 
            if { $_Mx > $mI } { set eI $mI } else { set eI $_Mx }
         } else { set eI $mI } 
         if { $_Mn > $mI } { set bI $mI } else { set bI $_Mn }

	 if [string match X $_cDir] {
	    set dX [expr $eI - $bI + 1] ; set dY $yL
         } else { set dX $xL ; set dY [expr $eI - $bI + 1] }

         set nC 0
	 if [string match X $_cDir] {
	    for { set N $bI } { $N <= $eI } { incr N } {
	       set cN [expr $N * $yL]
	       for { set M 0 } { $M < $yL } { incr M ; incr cN ; incr nC } {
	          set _vO($nC) $_vI($cN)
               }
            }
	 } else {
	    for { set N 0 } { $N < $xL } { incr N } {
	       set cN [expr $N * $yL + $bI]
	       for { set M $bI } { $M <= $eI } { incr M ; incr cN ; incr nC } {
	          set _vO($nC) $_vI($cN)
               }
            }
	 }

	 if { $dX == 1 } { 
	    set _vO(Dim) [list $dY $dX] 
	 } else { set _vO(Dim) [list $dX $dY] }
      }
   }
}
