# COLLAPSE operations
#
# THIS procedure collapses a 2D grid into either a 1D grid or to a single
#   value.  It can collapse over gridded or raw data.  Then collapsing
#   over raw data the min and max are indices and not actual values.
#
# YOU are allowed to mix raw and gridded data in the same setup menu.

package provide UDFAnalysis 1.0

proc APsolveCollapse { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : COLLAPSE"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# INITIALIZE element counter
  
      set _N 0

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s" _vIN _vOUT _cDir _Mn _Mx _cFmt

# GET the input variable list

      set iNames [lindex [APgetVNames $_vIN] 0]
      set nI [llength $iNames]

# GET the output variable list

      set oNames [lindex [APgetVNames $_vOUT] 0]
      set nO [llength $oNames]

# IF there is only one output variable but multiple input variables then
#   stuff all the output into that one variable otherwise there must be 
#   one output variable per input variable.

      if { ($nO == 1) && ($nI > 1) } {
         set OneV 1
         set vR [lindex $oNames 0] ; global [set vR] ; upvar 0 [set vR] _vO
      } else {
         if { $nI != $nO } {
            puts stderr "COLLAPSE Line $I:"
            puts stderr "     Mismatch in number of In and Out varaibles"
            continue
         } else { set OneV 0 }
      }

# LOOP over the input variables on this line. 

      for { set K 0 } { $K <  $nI } { incr K } {

# INPUT and OUTPUT variables

         set vR [lindex $iNames $K] ; global [set vR] ; upvar 0 [set vR] _vI
	 if !$OneV {
            set vR [lindex $oNames $K] ; global [set vR] ; upvar 0 [set vR] _vO
	    set _N 0
         }

# CHECK to see if this is a gridded or raw variable and collapse accordingly.
#  The check is for gridded data.

         if [info exists _vI(gInE)] { 
            APxferGInfo _vI _gI DATA REVERSE
            TUgridCollapse _vI _gI $_Mn $_Mx $_cDir $_cFmt _vT _gO
            for { set L 0 } { $L <  $_gO(4) } { incr L ; incr _N} {
	       set _vO($_N) $_vT($L) 
            }
            set _vO(Dim) [list $_N 1] 
	    set _gO(gInE) $apANS(numGI)
            APxferGInfo _gO _vO GI
         } else {
	    set xL [lindex $_vI(Dim) 0]
	    set yL [lindex $_vI(Dim) 1]

# GET the number of elements being collapsed over and set up the start
#   and stop indices.  _Mx can be set to MAX to indicate summing over
#   all elements.  Need to check that neither _Mn nor Mx is set larger
#   than the actual maxumim index.

	    if [string match X $_cDir] {
	       set mI [expr $xL - 1] ; set cV $yL
            } else { set mI [expr $yL - 1] ; set cV $xL }

	    if ![string match MAX $_Mx] { 
               if { $_Mx > $mI } { set eI $mI } else { set eI $_Mx }
            } else { set eI $mI } 
            if { $_Mn > $mI } { set bI $mI } else { set bI $_Mn }

	    set nV [expr double($eI - $bI + 1.0)]
	    for { set M 0 } { $M < $mI } { incr M } { set _vO($M) 0.0 }

	    if [string match X $_cDir] {
	       for { set L $bI } { $L <= $eI } { incr L } {
	          set cN [expr $L * $yL]
	          for { set M 0 } { $M < $yL } { incr M ; incr cN ; incr _N } {
	             set _vO($M) [expr $_vO($M) + $_vI($cN) ]  
                  }
               }
	    } else {
	       for { set L 0 } { $L < $xL } { incr L } {
	          set SuM 0.0
	          set cN [expr $L * $yL + $bI]
	          for { set M $bI } { $M <= $eI } { incr M ; incr cN } {
	             set SuM [expr $SuM + $_vI($cN) ]  
                  }
		  set _vI($L) $SuM
               }
	    }

	    if [string match AVG $_cFmt] {
	       for { set M 0 } { $M < $yL } { incr M } { 
	          set _vO($M) [expr $_vO($M) / $nV ]
               }
            }

            set _vO(Dim) [list $cV 1] 
         }
      }
   }
}
