# LOGNORMAL: FIT as set of data to the curve: 
#
#    Y = (A/X) * exp(-(ln(X) - B)/C)^2)
#
# THE function returns Y, dY/dA, dY/dB and dY/dC for any X.

package provide UDFAnalysis 1.0

proc APlognormFunc { nA dYdA Ops } {
    global _X_

    upvar $dYdA dA
    upvar $Ops  oP

    set xV $_X_($oP(4))

# THE coefficients
    set A $oP(5)
    set B $oP(6)
    set C $oP(7)

    if { $xV == 0.0 } { set xV 1.0e-5 }

    set xS [expr (log($xV) - $B) / $C]
    set ExP [expr exp(-$xS * $xS) / $xV]
    set T [expr $A * $ExP  * 2.0 * $xS]

# THE value of the function

    set yV [expr $A * $ExP]

# Derivitive with respect to A is exp(-(X - B)/C)^2)

    set dA(0) $ExP

# Derivitive with respect to B is (2.0 * A * xS * ExP)/C

    set dA(1) [expr $T / $C]

# Derivitive with respect to C is (2.0 * A * xS * xS * ExP)/C 

    set dA(2) [expr $T * $xS / $C]

    return $yV
}
