# THIS routine returns an indicator as to which varaibles are used in the
#   plot.  This is not as easy as it seems since often times varaibles used
#   in the plot are left blank because they are filled in by "prior" 
#   knowledge.

package provide UDFAnalysis 1.0

proc APgetDim { vName } {
   global apANS 

   upvar $vName vN

   set aOK 1

# GET a value which shows what variables are present

   for { set _I 0 } { $_I < 4 } { incr _I } {
      if { [llength $vN($_I)] > 0 } { set vP($_I) 1 } else { set vP($_I) 0 }
      set vA($_I) 0
   }


# WORK this backwards - starting with I.  See if there is an I variable
#   present and if so see if it has an associated gI variable.  If there
#   is we can always get the needed X and Y variables from it.

   if  $vP(3) { 
      set vR [lindex $vN(3)] ; global [set vR] ; upvar 0 [set vR] _V
      if [info exists _V(gInE)] { 
         set vA(0) 1
         set vA(1) 1
      }
      set vA(3) 1
   }

# DO the same for Y.  If it has an associated gI that will give us X

   if  $vP(1) { 
      set vR [lindex $vN(1) 0] ; global [set vR] ; upvar 0 [set vR] _Y
      if [info exists _Y(gInE)] { set vA(0) 1 }
      set vA(1) 1
   }

# IF there is an X variable see if its a non-plottable variable which can
#   be expanded to produce other varaibles.

   if  $vP(0) { 
      set vA(0) 1
      set vR [lindex $vN(0) 0] ; global [set vR] ; upvar 0 [set vR] _X

      if [info exists _X(aType)] {
         switch -exact -- $_X(aType) {
            FIT { 
	       if { $_X(fDim) > 0 } { set vA(1) 1 } 
	       if { $_X(fDim) > 1 } { set vA(3) 1 } 
	       if { $_X(fDim) > 2 } { set vA(2) 1 } 
	    }
            default { set aOK 0  } 
         }
      } 
   } 

# IF there is a Z variable mark it available.

   if  $vP(2) { set vA(2) 1 }

# FORM the output

   if $aOK {
      set pV  ""
      for { set _I 0 } { $_I < 4 } { incr _I } { append pV $vA($_I) }
   } else { pV 0000 }

   return $pV
}
