#package provide UDFAnalysis 1.0

proc APgenLab { I { MkV 0 } } {
   global apANS 

# UNICODE check (\u == unicode)

   set iLaB $apANS($I,Lab)
   set oLaB [APucodeParse $iLaB]

# BREAK apart the label and check to see if there are any embedded 
#   variables in it.  Assume that any word in a label which begins 
#   with $ is a variable.  If it had __ appended to it what follows
#   that is a format statement.  If there is no format then the
#   variable is output as %s.  If the varaible name is apANS then
#   assume its an internal variable otherwise its one of the global
#   variables defined within the program to hold data or data products.
#   Need to reassemble the label when done

   set iLaB $oLaB
   set oLaB ""
   set sL [split $iLaB]
   set nW [llength $sL]
   set cL ""
   set FmT %s

   for { set I 0 } { $I < $nW } { incr I } {
      set lW [lindex $sL $I]
      if [string match $ [string index $lW 0]] {
         set A [split $lW "_"]
         set B [lindex $A 0]
         if { [llength $A] == 3 } {
            if { [string length [lindex $A 1]] == 0 } { set FmT [lindex $A 2] }
         }
         set Op [string first "(" $B]
	 if { $Op >= 0 } {
	    set IsArray 1
            set Cp [string first ")" $B]
            set V  [string range $B 1 [expr $Op - 1]]
            set Ix [string range $B [expr $Op + 1] [expr $Cp -1]]
         } else {
	    set IsArray 0
            set V [string range $B 1 end]
	 }

puts stderr $V
         if [string match apANS $V] {
            set X \$$V\($Ix\) 
         } else {
	    set Var $V ; global [set Var] ; upvar 0 [set Var] gV
	    if $IsArray {
               set X \$gV\($Ix\) 
            } else { set X $gV }
         }

         set Y [eval format $FmT $X]
         if { $I == 0 } { append cL $Y } else { append cL " $Y" }
      } else { 
         if { $I == 0 } { append cL $lW } else { append cL " $lW" }
      }
   }

   switch -exact -- $cL {
      _S_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs)]
      }
      _E_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PendYr) $apANS(PendDy) $apANS(PendMs)]
      }
      _SE_TiMe_ {
         set oLaB [TUtimeFmt 0 $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs)]
	 append oLaB " TO "
         append oLaB [TUtimeFmt 0 $apANS(PendYr) $apANS(PendDy) $apANS(PendMs)]
      }
      default { set oLaB $cL }
   }

# IF we need to make the label vertical do it here

   if $MkV {
      set cL $oLaB
      set oLaB ""
      set I 0
      set sL [expr [string length $cL] - 1]
      while { $I <= $sL } {
         set Add [string index $cL $I]
	 if { $Add == "\\" } {
	    incr I
	    if { $I <= $sL } {
	       set cH [string index $cL $I]
	       if [string match $cH "u"] {
	          set BeG [expr $I + 1]
	          set EnD [expr $I + 4]
	          if { $EnD <= $sL } {
	             incr I 4
                     set Add [string range $cL $BeG $EnD]
                     scan $Add %x Add
	             set Add [format %c $Add]
	          } else { set Add [string range $cL $BeG $I] }
               } else { set Add [string range $cL $BeG $I }
            }
         }
         if { $I != $sL } { append oLaB "${Add}\n" } else { append oLaB $Add }
         incr I
      }
   }

   return $oLaB
}
