# DEFINE grid GUI

package provide UDFAnalysis 1.0

proc APdefgridGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set YN [list NO YES]
   set PB [list POINT BAND]
   set LL [list LINEAR LOG]

   set mN DEFGRID
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmTa  [lindex [lindex $apANS($mN) 3] 0]
      set FmTb  [lindex [lindex $apANS($mN) 3] 1]
      set LaBa [format $FmTb X/Y X/Y X/Y X/Y X/Y X/Y Mn/Mx X/Y]
      set LaBb [format $FmTa Grid Min Max Cells Fmt Sca Cyc Intensity Centers]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaBa  w grid|$R|0|w 0 0 "" $CFonT
      incr R 
      GUILabel $Wc.$R $LaBb  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 1.5

      incr R 
      GUILabel $We.l$R  "Grid" c grid|$R|1|ew -1 0 "" $LFonT
      GUILabel $We.la$R  "X Cell Ctrs" c grid|$R|3|ew||2 -1 0 "" $LFonT
      GUILabel $We.lb$R  "Y Cell Ctrs" c grid|$R|5|ew||2 -1 0 "" $LFonT

      incr R 
      GUILabel $We.l$R  "Variables" c grid|$R|0|ew -1 0 "" $LFonT
      GUIboxEntry $We.gnm grid|$R|1|news 11 apANS($fD,gName)
      GUIboxEntry $We.gcx grid|$R|3|news||2 11 apANS($fD,gIX)
      GUIboxEntry $We.gcy grid|$R|5|news||2 11 apANS($fD,gIY)

      incr R 
      GUIblankRow $We $R 1.5

      incr R 
      GUILabel $We.la$R  "Minumum" c grid|$R|1|ew -1 0 "" $LFonT
      GUILabel $We.lb$R  "Maximum" c grid|$R|2|ew -1 0 "" $LFonT
      GUILabel $We.lc$R  "Cells" c grid|$R|3|ew -1 0 "" $LFonT
      GUILabel $We.ld$R  "Storage" c grid|$R|4|ew  9 0 "" $LFonT
      GUILabel $We.le$R  "Scaling" c grid|$R|5|ew  9 0 "" $LFonT
      GUILabel $We.lf$R  "Cyclic" c grid|$R|6|ew -1 0 "" $LFonT

      incr R 
      GUILabel $We.l$R  "X Parameters" c grid|$R|0|e -1 0 "" $LFonT
      GUIboxEntry $We.xmin grid|$R|1|news 11 apANS($fD,XMin)
      GUIboxEntry $We.xmax grid|$R|2|news 11 apANS($fD,XMax)
      GUIboxEntry $We.xcel grid|$R|3|news 6 apANS($fD,XCells)
      GUIbuttonToggle $We.xfmt $apANS($fD,XFmt) grid|$R|4|news $PB  \
	                  "GUIoptsToggle $We.xfmt apANS($fD,XFmt) PRI" 0,0.5
      GUIbuttonToggle $We.xsca $apANS($fD,XSca) grid|$R|5|news $LL  \
	                  "GUIoptsToggle $We.xsca apANS($fD,XSca) PRI" 0,0.5
      GUIbuttonToggle $We.xcyc $apANS($fD,XCyc) grid|$R|6|news $YN  \
	                    "GUIoptsToggle $We.xcyc apANS($fD,XCyc) PRI" 0,0.5

      incr R 
      GUILabel $We.l$R  "Y Parameters" c grid|$R|0|e -1 0 "" $LFonT
      GUIboxEntry $We.ymin grid|$R|1|news 11 apANS($fD,YMin)
      GUIboxEntry $We.ymax grid|$R|2|news 11 apANS($fD,YMax)
      GUIboxEntry $We.ycel grid|$R|3|news 6 apANS($fD,YCells)
      GUIbuttonToggle $We.yfmt $apANS($fD,YFmt) grid|$R|4|news $PB  \
	                  "GUIoptsToggle $We.yfmt apANS($fD,YFmt) PRI" 0,0.5
      GUIbuttonToggle $We.ysca $apANS($fD,YSca) grid|$R|5|news $LL  \
	                  "GUIoptsToggle $We.ysca apANS($fD,YSca) PRI" 0,0.5
      GUIbuttonToggle $We.ycyc $apANS($fD,YCyc) grid|$R|6|news $YN  \
	                    "GUIoptsToggle $We.ycyc apANS($fD,YCyc) PRI" 0,0.5
      incr R 
      GUILabel $We.l$R  "Intensity" c grid|$R|0|e -1 0 "" $LFonT
      GUIboxEntry $We.imin grid|$R|1|news 11 apANS($fD,IMin)
      GUIboxEntry $We.imax grid|$R|2|news 11 apANS($fD,IMax)

      bind $W <Down> { APtwinCmd DEFGRID %W MOVE DOWN }
      bind $W <Up> { APtwinCmd DEFGRID %W MOVE UP }

      APallInits $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI $mN $fD

   } else { GUIwindowCtrl $W }
}
