# THIS procedure checks to see if the X variable is both non-plottable and of
#   a type which can be expanded into a set of plottable informaton.  If it
#   can it returns the plottable varaibles in X, Y, Z, and V.  X and V
#   are always returned and Y and Z only if 3 or 4 D data sets are being
#   built.  The procedure returns the number of  X, Y, Z, and V variables.
#   If it returns nX as 0 then there was no action taken.  If it returns
#   nX as -1 then the varaible is non-plottable and non-expandable

package provide UDFAnalysis 1.0

proc APbuildVar { pD xVar X Y Z V } {
   global apANS

# INITIALIZE the return array sizes

   set nX 0 ; set nY 0 ; set nZ 0 ; set nI 0

# First check to see if there is even an X variable defined!

   if { [llength $xVar] == 0 } { return [list $nX $nY $nZ $nI] }

# NOW check to see if its a non-plottable variable. 

   set vR [lindex $xVar 0] ; global [set vR] ; upvar 0 [set vR] _T
   if ![info exists _T(aType)] { return [list $nX $nY $nZ $nI] }

# OK - initial checks indicate that we should proceed. Import the output
#    Array variables

   upvar $X _X
   upvar $Y _Y
   upvar $Z _Z
   upvar $V _I

#  SET the plot number and the index into the plot definitions where the 
#     plot information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set aX $apANS($pD,xActive) 
   set aY $apANS($pD,yActive)

# SEE what type of non-plottable variable this is and if we can expand it

   switch -exact -- $_T(aType) {
      FIT {
         if [string match Xt $aX] {
            GPHwinScale $pN Xs Ys Zs 0
          } else { GPHwinScale $pN Xp Yp Zp 0 }

	  if { $_T(fDim) == 1 } {
             set nX [APexpandFit $pN _T _X _D _D _I]  
	     set nY $nX
          } elseif { $_T(fDim) == 2 } {
              set nX [APexpandFit $pN _T _X _Y _D _I]  
              set nY $nX ; set nI $nX
          } else { 
	      set nX [APexpandFit $pN _T _X _Y _Z _I]
              set nY $nX ; set nY $nX ; set nI $nX
          }
      }
      default { set nX -1} 
   }

   return [list $nX $nY $nZ $nI]
}
