# THIS routine sorts out the input ascii file formats and the variables
#   being read and then sets up the read command(s)
#
# FOR time based data procedure assumes that each line contains a time 
#   taq which provides the year, dayofyear (or month day), hour, minute, 
#   second, and possibly  millisecond.  There can be a beginning and 
#   ending time tag.  The beginning times should have been labeled bY, bD, 
#   (bMo bD), bH, bM, bS, bMs and if there is an ending time eY, eD, 
#   (eMo, eD), eH, eM, eS, and eMs.  As stated above neither eMs nor bMs 
#   need be used.  Also milliseconds may be included as fractional seconds.
#
#   Variables are assumed to start with _

package provide UDFAnalysis 1.0

proc APasciiFVR { vD rCmd rRep vInc vLine } {
   global apANS 

# rCmd is the read command for each defined line of variables
# vInc is the counter advance to use at each for each new line of
#   variables
 
 
   upvar $rCmd  rC
   upvar $rRep  vRep
   upvar $vInc  vAdv
   upvar $vLine vL
   
# Stick the format and variable definitions into a common array
#   variable
 
   set Def(0) [string trim $apANS($vD,lFmT)]
   set Def(1) [string trim $apANS($vD,fileVar)]

# SPLIt apart the format and variable definitions so that there is one
#   set of definitions per line.  In a multiline definition the format
#   and variable definitions of the read lines are delimited by (( and )) 
#   and may have a preceeding value which is used as a repeat value.
#   
# FOR each line lN, the format definitions are stored in lInfo(0,lN) and 
#   the variable definitions in lInfo(1,lN).  The number of defined format
#   and variable lines are in nL(0) and nL(1) respectively.
 
   for { set I 0 } { $I < 2 } { incr I } {
      set Done 0
      set lN 0
      set tS [string trim $Def($I)]

      while { !$Done } {
         set LocA [string first "((" $tS]

         if { $LocA >= 0 } {
            set LocB [string first "))" $tS]
            set sLen [string length $tS]

            set Beg [expr $LocA + 2]
            set End [expr $LocB - 1]
            set lInfo($I,$lN) [string trim [string range $tS $Beg $End]]

            if { $LocA > 0 } {
               set End [expr $LocA - 1]
               set Rep($I,$lN) [string trim [string range $tS 0 $End]]
            } else { set Rep($I,$lN) 1 }
 
            set Beg [expr $LocB + 2]
            if { $Beg < $sLen } {
               set tS [string trim [string range $tS $Beg end]]
            } else { set Done 1 }
         } else { 
	    set lInfo($I,$lN) [string trim $tS ] 
            set Rep($I,$lN) 1
	    set Done 1 
         }

         incr lN
      }

      set nL($I) $lN
   }


# CONSTRUCT the format lines.  Basically this means accounting for repeated
#   formats and format blocks.  Repeated format have the form RepV@Fmt and
#   repeated format have the form RepV@/FmtA FmtB FmtC/.
#   Examples
#
#            4@%.3f == "%.3f %.3f %.3f %.3f"
#            2@/%.3f %d/ == "%.3f %d %.3f %d"
 
   for { set I 0 } { $I < $nL(0) } { incr I } {
      set cL $lInfo(0,$I)
      set nE  [llength $cL] 
      set LnE [expr $nE -1]
      set lF ""

      for { set J 0 } { $J < $nE } { incr J } {
         set tF [lindex $cL $J]
         set lP [string first "@" $tF]
         set rP 1

         if { $lP >= 0 } {
           set Beg [expr $lP + 1]
           set End [expr $lP - 1]
           set rP [string trim [string range $tF 0 $End]]

           set lP [string first "/" $tF]
           if { $lP >= 0 } {
	      set Beg [expr $lP + 1]
	      set Finish 0
	   } else { set Finish 1 }

	   set cF "[string trim [string range $tF $Beg end]] "
	   while { !$Finish && ($J <= $LnE) } {
	      incr J
	      set tF [lindex $cL $J]
	      set lP [string first "/" $tF]
	      if { $lP >= 0 } {
	         set Finish 1
		 set lC [expr [string length $tF] - 2]
		 append cF "[string range $tF 0 $lC] "
	      } else { append cF "$tF " }
            }
         } else { set cF $tF }
         for { set K 0 } { $K < $rP } { incr K } { append lF "$cF " }
      }

      set lFmt($I) [string trim $lF]
      set fRep($I) $Rep(0,$I)
   }

# CONSTRUCT the variable lines much the same way that format lines were
#   constructed.  
 
   for { set I 0 } { $I < $nL(1) } { incr I } {
      set cL $lInfo(1,$I)

# SPLIT apart the variable names

      set vI [lindex [APgetVNames $cL] 0]
      set nE [llength $vI]

      set LnE [expr $nE -1]
      set lV ""
      set cV ""

      set vRepMx 1
      for { set J 0 } { $J < $nE } { incr J } {
         set cF [lindex $vI $J]
         set lP [string first "@" $cF]

         if { $lP >= 0 } {
           set Beg [expr $lP + 1]
           set End [expr $lP - 1]
           set rP [string trim [string range $cF 0 $End]]
           set cF [string trim [string range $cF $Beg end]]
	   if { $rP > $vRepMx } { set vRepMx $rP }

           set TmP ""
           set lP [string first "/" $cF]
           if { $lP >= 0 } {
	      set Beg [expr $lP + 1]
	      set Finish 0
	   } else { set Finish 1 ; set Beg 0 }

	   lappend TmP [string trim [string range $cF $Beg end]]
	   while { !$Finish && ($J <= $LnE) } {
	      incr J
              set cF [lindex $cL $J]
              set lP [string first "/" $cF]
              if { $lP >= 0 } {
	         set Finish 1
	         set lC [expr [string length $cF] - 2]
                 lappend TmP [string range $cF 0 $lC]
	      } else { lappend TmP $cF }
           }
	   set tNum [llength $TmP]

           for { set K 0 } { $K < $rP } { incr K } {
              for { set L 0 } { $L < $tNum } { incr L } {
                 lappend lV [lindex $TmP $L]
	         lappend cV $K
              }
	   }
         } else { 
            lappend lV $cF
            lappend cV 0
         }
      }


      set Len [llength $cV]
      set TmP ""
      set TmPa ""
      for { set K 0 } { $K < $Len } { incr K } {
         set iV [lindex $lV $K]
         set iC [lindex $cV $K]
         if [string match "_" [string index $iV 0]] {
            if { $iC > 0 } {
	       append TmP " $iV\(\[expr \$_N + $iC\]\)"
            } else { append TmP " $iV\(\$_N\)"}
	    append TmPa " $iV"
         } else { append TmP " $iV" }
      }

      set TmP  [string trim $TmP]
      set TmPa [string trim $TmPa]

      set lVar($I) $TmP
      set vL($I) $TmPa
      set vRep($I) $Rep(1,$I)
      set vAdv($I) $vRepMx
      set vAdv($I) $vRepMx
   }

# BUILD read commands for each line of variables

   set Cnt 0
   set fI 0
   set fMx $fRep($fI)
   for { set I 0 } { $I < $nL(1) } { incr I } {
      if { $Cnt >= $fMx } { 
         incr fI  
         set fMx [expr $fMx + $fRep($fI)]
      }
      set rC($I) {scan $LiNe} 
      append rC($I) " \"$lFmt($fI)\" $lVar($I)"
      set Cnt [expr $Cnt + $vRep($I)]
   }

   return $nL(1)
}
