#  THIS procedure reads in a single spin of data.

# package provide UDFAnalysis 1.0

proc APacqSpin { } {
   global SInfo mANS phImG dfImG ExDa ExPhi0 RtoD TwoP inImG

   set sN Src[lindex $mANS(MOMENTS) 0]

   set Gap    0
   set RoLL   0
   set DoRoLL 1
   set NoSpin 1
   set dfC 0
   set phC 0
   set mANS(Sector) 0

   set nSen [llength $mANS($sN,sNum)]
   set TheEnd [expr $nSen - 1 ]

# BEGIN to acquire one spin spin 

   while { $NoSpin } {

# ACQUIRE the sensor data - one at a time.  Once a complete spin sector
#   has been obtained then advance the record pointer.

      set FwD 0
      for { set I 0 } { $I <= $TheEnd } { incr I } {
         set vN [lindex $mANS($sN,sNum) $I]

# READ the data advancing on the last sensor, set the sweep length

         if { $I == $TheEnd } { set FwD 1 }
         set S [split [ReadUDF $mANS($sN,KeY) 0 0 $vN 0 $FwD 0] "|"]
         if { [lindex $S 0] == -1 } { return -1 }
         if { [lindex $S 0] != 1 } { continue }

         set nE $ExDa(0,NSMP)

# THERE are several things which need to be done either once per spin or
#   once per sector.  At I = 0 be are beginning a new sector and if dfC
#   is 0 we are starting a new spin.

         if { $I == 0 } {

# Once per spin items include the location of the last sample in the sweep,
#    the starting phase angle of the spin and the last phase angle in the
#    the spin, and the velocity components of the sweep steps.  Also need
#    to get the start time of the spin and the time it takes to complete 
#    one sweep.  If we advance in time going from one sector to anther by 
#    more than some number of these sweep times then we can assume there 
#    is a gap in the data.

            if { $dfC == 0 } {
               set mANS(nE) $ExDa(0,NSMP)
               set LasT [expr $mANS(nE) - 1]
               set EnD [expr $ExPhi0(0)  + 360.0]
               set BeG $ExPhi0(0)

               set mANS(bY) $ExDa(0,BYR)
               set mANS(bD) $ExDa(0,BDY)
               set mANS(bM) $ExDa(0,BMSEC)
               set LastBMs  $ExDa(0,EMSEC)
               set LastEMs  $ExDa(0,BMSEC)
               set Spin     $ExDa(0,SPIN)
               set LastPhi  $mANS(Bad)

	       set fsT      -1

               set sdT [expr $ExDa(0,EMSEC) - $ExDa(0,BMSEC)]
               if { $sdT < 0 } { set sdT [expr $sdT + 86400000] }
               MOvelComps $sN 1
            }

# SET the end of sweep time which is the same as the sector time.  Keep an
#   array of these values so that we will be able to determine the end of
#   spin time.

            set yR($mANS(Sector)) $ExDa(0,EYR)
            set dY($mANS(Sector)) $ExDa(0,EDY)
            set mS($mANS(Sector)) $ExDa(0,EMSEC)
            set CurBMs $ExDa(0,BMSEC)
            set CurEMs $ExDa(0,EMSEC)
	    set CurPhi $ExPhi0(0)
             
# IF the last phase value is less than the beginning then we have rolled
#   over 360 degrees.

            if { (($ExPhi0($LasT) < $BeG) || ($CurPhi < $LastPhi)) \
	                                                     && $DoRoLL } {
              incr RoLL
              set DoRoLL 0
            } elseif { $ExPhi0($LasT) > $BeG } { set DoRoLL 1 }
                                                                                
            set T [expr $ExPhi0($LasT) + $RoLL * 360.0]

# SEE if we have complted a full spin or if there has been a gap in the 
#   data.  If either one then we are finished with this spin.
                                                                                
            if { $T > $EnD } { set NoSpin 0 ; break }
	    if { $CurBMs == $LastBMs } { set Gap 1 ; set NoSpin 0 ; break }

            if { ($fsT < 0) && ($mANS(Sector) > 1) } {
	       set dT [expr $CurEMs - $LastEMs]
               if { $dT < 0 } { set dT [expr $dT + 86400000] }
	       if { $dT < [expr 2.0 * $sdT] } { set fsT $dT } 
	    }

            set LastBMs $CurBMs
            set LastEMs $CurEMs
            set LastPhi $CurPhi

# SAVE the phase data.  Since all the elevation sensors are acquired in
#   parallel we only need to save this for one sensor in each sector. Need
#   to add 180 to the phase to take it from instrument look direction to
#   flow direction.

            for { set J 0 } { $J < $nE } { incr J ; incr phC } {
               set phImG($phC) [expr $ExPhi0($J) + 180.0]
            }
         }

# CONVERT the data to distribution function units.  This should be s^3/m^6

         set uI [lindex $mANS($sN,sUnit) $I]
         ConvertToUnits $mANS($sN,KeY) 0 0 $uI rV

# PUT distribution function values into their appropriate spin data array.

         for { set J 0 } { $J < $nE } { incr J ; incr dfC } {
#           set dfImG($dfC)  1.0
            set dfImG($dfC)  $rV($J)
#           set dfImG($dfC)  [Sim $J $I $ExPhi0($J)]
         } 
      }

# INCREMENT the sector counter

      incr mANS(Sector)
   }

   incr mANS(Sector) -1
   set EnD [expr $mANS(Sector) - 1]
   set mANS(eY) $yR($EnD)
   set mANS(eD) $dY($EnD)
   set mANS(eM) $mS($EnD)

# WE need to make sure that we got at least most of the expected sectors.
#   If we are missing more than FrGap sectors then don't compute the moments
#   for this spin.

   set tSec [expr int($Spin / double($fsT) + .5)]
   if { $mANS(FrGap) <= [expr $tSec - $mANS(Sector)] } { set Gap 1 }
   if { $fsT <= 0 } { set Gap 1 }
  
   if !$Gap {
      set mANS(SpiN) $ExDa(0,SPIN)

# CLIP out bad regions in the distribution

      set nV [expr $mANS(Sector) * $mANS(nE)]
      for { set J 0 } { $J < $nV } { incr J } {
         set phImG($J) [expr fmod($phImG($J), 360.0)]
      }

      set retStat 1

   } else { set retStat 0 }

   return $retStat
}
