package provide UDFAnalysis 1.0

proc APxcalGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set dFOps [list Vector Scalar]
   set mEOps [list Mean Avg]
   set vMOps [list Comp Mag]
   set sHOps [list Add Mult]

   set mN CROSS-CAL
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT Input OutPut Format Method Align Base vMode ]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUILabel $We.l0  "Input" c grid|$R|0|e -1 0 "" $LFonT
      GUIblankCol $We 1 1
      GUIboxEntry $We.pos grid|$R|2|news 11 apANS($fD,dIn)
      GUIblankCol $We 3 6
      GUIbuttonToggle $We.df $apANS($fD,dFmt) grid|$R|4|w $dFOps  \
	                 "GUIoptsToggle $We.df apANS($fD,dFmt) PRI" 0,0.5
      GUIblankCol $We 5 1
      GUILabel $We.l1  "Format" c grid|$R|6|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l2  "Output" c grid|$R|0|e -1 0 "" $LFonT
      GUIboxEntry $We.do grid|$R|2|news 11 apANS($fD,dOut)

      incr R 
      GUILabel $We.l3  "Method" c grid|$R|0|e -1 0 "" $LFonT
      GUIbuttonToggle $We.me $apANS($fD,xcMet) grid|$R|2|ew $mEOps  \
	                 "GUIoptsToggle $We.me apANS($fD,xcMet) PRI"
      GUIbuttonToggle $We.sh $apANS($fD,xcShift) grid|$R|4|ew $sHOps  \
	                 "GUIoptsToggle $We.sh apANS($fD,xcShift) PRI" 0,0.5
      GUILabel $We.l3a  "Align By" c grid|$R|6|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l4  "Base" c grid|$R|0|e -1 0 "" $LFonT
      GUIboxEntry $We.base grid|$R|2|news 11 apANS($fD,xcBase)
      GUIbuttonToggle $We.vm $apANS($fD,vMet) grid|$R|4|ew $vMOps  \
	                 "GUIoptsToggle $We.vm apANS($fD,vMet) PRI" 
      GUILabel $We.l4a  "vMode" c grid|$R|6|e -1 0 "" $LFonT

      bind $W <Down> { APtwinCmd CROSS-CAL %W MOVE DOWN }
      bind $W <Up> { APtwinCmd CROSS-CAL %W MOVE UP }

      APallInits $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI  $mN $fD

   } else { GUIwindowCtrl $W }
}
