package provide UDFAnalysis 1.0

# This routine converts a time span in seconds to the number of data points
#   contained within that time period when Fmt is FORWARD.  Otherwise
#   it does the opposite, converts the number of point to a time span.
#
#  IMPUT 
#     V : The variable being measured
#     T : The time span in seconds OR the number of points.  The time
#         string should be terminated by an S or s and the points by
#         a P or p.
#
#  RETURNES:
#     The number of data points within the time period or the time span in 
#     seconds.

proc APtimeToPts { Data Range  { Fmt FORWARD } } {
   global apANS 

   upvar $Data V  

# TIME span covered by a single measurement  
 
   set dT $V(gIcZ)

   if [string match FORWARD $Fmt] {

# The range being time should have an s or S as the last character in the 
#    string (signifying seconds).  If its has a P or p or nothing assume
#    its points and just return that value.
  
      set lC [string index $Range end]
      if { [string match "P" $lC] || [string match "p" $lC] } {
         set EnD [expr [string length $Range] -2]
         set Range [string range $Range 0 $EnD]
         set rV $Range
      } elseif { [string match "S" $lC] || [string match "s" $lC] } {
         set EnD [expr [string length $Range] -2]
         set Range [string range $Range 0 $EnD]
         set rV [expr int(($Range / double($dT)) + 0.5)] 
      } else { set rV $Range }
   } else {
      if { [string match "S" $lC] || [string match "s" $lC] } {
         set EnD [expr [string length $Range] -2]
         set Range [string range $Range 0 $EnD]
         set rV $Range
      } else { 
         if { [string match "P" $lC] || [string match "p" $lC] } {
            set EnD [expr [string length $Range] -2]
            set Range [string range $Range 0 $EnD]
         }
         set rV [expr $Range * double($dT)] 
      }
   }

   return $rV
}
