package provide UDFAnalysis 1.0

# CREATE a set of random numbers.  These can either have a flat or gaussian
#    distribution.  For the latter the number of points must should be even,
#    however if not we will drop the last point in the last pair.

proc APsolveRandom { fD } {
   global apANS env Prefs Rnd1Seed TwoPI

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %f %s %s %f %f" _vB _vO _rG _Mx _sD _Dist _Mean _Var

      if ![string match "---" $_sD] { set Rnd1Seed $_sD }

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

# GET the input variable list.  This is just used to see how large the output
#   array should be.  You can just set this to a numerical value if you
#   want to specify the array length.

      set rV [APgetVNames $_vB]
      if { [lindex $rV 1] == 1 } {
         set nI $nO
         set nP [lindex $rV 0]
	 set OK 0
      } else {
         set iNames [lindex $rV 0]
         set nI [llength $iNames]
	 set OK 1
      }

# Create the arrays
 
      for { set J 0 } { $J <  $nI } { incr J } {
         if $OK {  
            set vR [lindex $iNames $J]
            global [set vR]
            upvar 0 [set vR] _In
            set nP [lindex $_In(Dim) 0]
         }

         set vR [lindex $oNames $J]
         global [set vR]
         upvar 0 [set vR] _Out
         set _Out(Dim) [list $nP 1]

         switch -exact -- $_Dist {
	    Flat {
               TUdataRnd1 _Out $nP $_rG $_Mx
            }
            Gaussian {
               TUdataRnd1 _TmP [expr $nP + 1] P 1.0
	       for { set K 0 } { $K <  $nP } { incr K 2 } {
	          set M $K
	          set N [expr $K + 1]
		  set _T1 [expr $_Var  * sqrt(-2.0 * log($_TmP($N)))]
		  set _A1 [expr $TwoPI * $_TmP($M)]
		  set _Out($M) [expr $_Mean + $_T1 * cos($_A1)] 
		  if { $N < $nP } {
		     set _Out($N) [expr $_Mean + $_T1 * sin($_A1)] 
                  }
               }
            }
	 }
      }
   }
}
