package provide UDFAnalysis 1.0

proc APsaveGObj { fd } {
   global apANS

# CREATE and fill function window if it does not exist.  If we don't do
#   this the text window with the current entries not exist

   if ![winfo exists .apGOBJ] { APgobjGUI 1 }

# CURRENT function definitions are in this window 

   set W .apGOBJ.body.list

# THIS is the number of function definitions

   set nF [$W index end]

# NO definitions then return

   if { $nF == 0 } { return }

# LOOP over the function definitions, saving each one

   puts $fd "BEGIN GRAPHICS OBJECTS"
   for { set I 0 } { $I < $nF } { incr I } {

# READ in the function definition and get the slot number

      set fDef [$W get $I]
      scan $fDef "%d" oN

# SAVE the general function variables (name and comments)

      puts $fd "BEGIN GOSLOT $I"

      APallInits GOBJ $oN
      set nV [APvarList GOBJ vL]
      for { set J 0 } { $J < $nV } { incr J } {
         set vI [lindex $vL $J]
         set vN [lindex $vI 0]
         puts $fd "$I,$vN|$apANS($oN,$vN)"
      }

# SAVE the variables specific to the function. Get the function specific text
#   window and how many elements are in it

      set fW .apGOBJ$oN.body.list
      if ![winfo exists .apGOBJ$oN] { 
         set GuI [lindex $apANS($apANS($oN,gObj)) 0]
	 eval $GuI $oN 1
      }

      set nE [$fW index end]

# ONLY continue if there was an attempt at a definition

      if { $nE > 0 } {
         puts $fd "BEGIN $apANS($oN,gObj) $I"
         set nV [APvarList $apANS($oN,gObj) vL]

# CHECK the number of lines in the text window used by an entry

         set nL [llength [lindex $apANS($apANS($oN,gObj)) 3]]

# BLANK out the options to be saved

         for { set J 0 } { $J < $nV } { incr J } { set B($J) "" }

# SET up the format to read the options and the array in which they
#    will be read into

         set FmT "%s"
         set VaR "A(0)"
         for { set J 1 } { $J < $nV } { incr J } {
	     append FmT " %s"
	     append VaR " A($J)"
         }
	 
# Set up the save command

	 set rCmd {scan "$LiNe" "$FmT" }
	 append rCmd $VaR

# NOW get the options for this entry

         for { set J 0 } { $J < $nE } {  } {
	    set LiNe [$fW get $J]
	    incr J
            for { set L 1 } { $L < $nL } { incr L  } {
	       set NexT [$fW get $J]
	       incr J
	       append LiNe " [string trim $NexT]"
            }

	    eval $rCmd
            for { set K 0 } { $K < $nV } { incr K } {
	       if [string match $apANS(EmptyVar) $A($K)] {
	          lappend B($K) ""
	       } else { lappend B($K) $A($K) }

            }
         }

         for { set J 0 } { $J < $nV } { incr J } {
            set vI [lindex $vL $J]
            set vN [lindex $vI 0]
            puts $fd "$I,$vN|$B($J)"
         }
         puts $fd "END $apANS($oN,gObj)"
      }
      puts $fd "END GOSLOT"
   }
   puts $fd "END GRAPHICS OBJECTS"
}
