package provide UDFAnalysis 1.0

# THIS routine sets up a number of parameters which are used when 
#   setting up where plots are placed in the plot grid. A lot of this 
#   could probably be done in a single loop but since its only run once 
#   we will foresake efficiency for readibility and give each task a 
#   separate loop

proc APprePlot { } {
   global apANS GphInfo 

# CHECK the graphics driver.  If its TK then force the 3D Format to
#   be flat.

   if [string match TK $apANS(gdev)] { set apANS(tDFmt) FLAT }

# SET the vtk 3D scaling. Doesn't hurt if this is not a vtk based plat

   if { $apANS(tDSca) <= 0.0 } { set apANS(tDSca) 0.5 }
   if { $apANS(tDDec) <= 0.0 } { set apANS(tDSca) 1 }
   set GphInfo(vtkSFac) $apANS(tDSca)

# THIS is the number of plot layouts defined. 

   if ![winfo exists .apLAYOUT] { APlayoutGUI 1 }
   set Wlay .apLAYOUT.body.list
   set nP [$Wlay index end]

# AND the number of plots defined within those layouts. Remember a given 
#    plot layout can have multiple plots stuffed into it.

   if ![winfo exists .apPLOT] { APplotGUI 1 }
   set WPlot .apPLOT.body.list
   set nV [$WPlot index end]

# FIND the grid size. This is the maximum row and column number defined
#   in the plot layout definition.  Need to take into account spanning.
#   
   set apANS(maxRow) -1
   set apANS(maxCol) -1

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wlay get $I] "%d" sN
      set V1 [expr $apANS($sN,Col) + $apANS($sN,cSpan) - 1]
      set V2 [expr $apANS($sN,Row) + $apANS($sN,rSpan) - 1]
      if { $V1 > $apANS(maxCol) } { set apANS(maxCol) $V1 }
      if { $V2 > $apANS(maxRow) } { set apANS(maxRow) $V2 }
   }

# Last Row and Col in plot grid

   set LastR $apANS(maxRow)
   set LastC $apANS(maxCol)

# SINCE we count rows and columns beginning at 0 increment the maximum
#   size of both

   incr apANS(maxRow) 1
   incr apANS(maxCol) 1

# INITIALIZE a number of information elements associated with both the
#   defined layout plot definitions and the various cells in the plot grid.
#   Both apANS($sN.piD) and apANS($C.$R) provide links between the plot
#   ID and the grid cells back to the plot slot number.  Knowing that
#   allows access to the options selected in defining the plot.
#   apANS($C.$R) provides most of the information on how cells are
#   grouped into layout blocks
#
# ELEMENTS of the apANS($sN.piD) list are:
#    Index 0: Plot layout slot Number
#    Index 1: 1 if Bottom X axis is active, 0 otherwise 
#    Index 2: 1 if Top X axis is active, 0 otherwise
#    Index 3: 1 if Left Y axis is active, 0 otherwise
#    Index 4: 1 if Right Y axis is active, 0 otherwise
#
#  apANS($C.$R.3D) : 1 if VTK driver needed for plot
#  apANS($C.$R.sN) : The layout slot corresponding to the cell
#  apANS($C.$R.cBPos) : The colorbar existence/position. This is a list
#                       where empty is none 1 = left, 2 = right, 3 - bot, 
#                       4 = top)
#
# ELEMENTS of the apANS($C.$R.aLab) list are:
#    Index  0: Numerical annotation along bottom of grid cell (1)  
#    Index  1: Numerical annotation along top of grid cell (1)
#    Index  2: Numerical annotation along left side of grid cell (1)
#    Index  3: Numerical annotation along right side of grid cell (1)
#
# ELEMENTS of the apANS($C.$R.rBlk) list are:
#    Index  0: Start row of this layout block
#    Index  1: Total number of labeled Y axes in this layout block
#    Index  2: Number of anotated Y axes to left of this cell in layout block
#    Index  3: The total number of row cells spanned by this layout block
#    Index  4: Total number of colorbars in this layout block
#    Index  5: Number of colorbars to left of this cell in layout block
#
# ELEMENTS of the apANS($C.$R.cBlk) list are:
#    Index  0: Start column of this layout block
#    Index  1: Total number of labeled X axes in this layout block
#    Index  2: Number of anotated X axes above this cell in layout block
#    Index  3: The total number of column cells spanned by this layout block
#    Index  4: Total number of colorbars in this layout block
#    Index  5: Number of colorbars above this cell in layout block
#    
#  apANS($C.$R.Xb) List of variables plotted against the bottom X axis
#  apANS($C.$R.Xt) List of variables plotted against the top X axis
#  apANS($C.$R.Yl) List of variables plotted against the left Y axis
#  apANS($C.$R.Xr) List of variables plotted against the right Y axis
#  apANS($C.$R.X)  List of variables plotted against the Z axis
#  apANS($C.$R.I)  List if intensity variables

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wlay get $I] "%d" sN
      set P $apANS($sN,piD)
      set C $apANS($sN,Col)
      set R $apANS($sN,Row)
      set pN $C.$R
      set apANS($P) [list $sN 0 0 0 0]
      set apANS($pN.3D) 0
      set apANS($pN.sN) $sN
      set apANS($pN.cBPos) ""
      set apANS($pN.aLab) [list 0 0 0 0]
      set apANS($pN.cBlk) [list 0 0 0 0 0 0]
      set apANS($pN.rBlk) [list 0 0 0 0 0 0]
      set apANS($pN.cB) [list $apANS($sN,cbMin) $apANS($sN,cbMax) 0]
      set apANS($P.Xb) "" ; set apANS($P.Xt) ""
      set apANS($P.Yl) "" ; set apANS($P.Yr) ""
      set apANS($P.Z) ""
      set apANS($P.I) ""
   }

# LOOP over all of the grid cells and initialize the information list
#    for any which weren't initialized in the loop above.  These will
#    be cells which have no plot associated with them and those which
#    are part of a larger plot block formed by spanning row and columns.

   for { set C 0 } { $C < $apANS(maxCol) } { incr C } {
      for { set R 0 } { $R < $apANS(maxRow) } { incr R } {
         set pN $C.$R
         if ![info exists apANS($pN,sN)] {
            set apANS($pN.3D) 0
            set apANS($pN.sN) -1
            set apANS($pN.cBPos) ""
            set apANS($pN.aLab) [list 0 0 0 0]
            set apANS($pN.cBlk) [list 0 0 0 0 0 0]
            set apANS($pN.rBlk) [list 0 0 0 0 0 0]
	 }
      }
   }

# FOR each defined layout note which axes are being numerically labeled and
#    add this information to the grid cell info lists. 

   for { set I 0 } { $I < $nP } { incr I } {

# THE slot number of the plot layout

      scan [$Wlay get $I] "%d" sN

# THE annotation flags for each axis in the layout definition

      set Xb [string match YES $apANS($sN,xbAno)]
      set Xt [string match YES $apANS($sN,xtAno)]
      set Yl [string match YES $apANS($sN,ylAno)]
      set Yr [string match YES $apANS($sN,yrAno)]

# THE number of rows and columns spanned by the layout

      set nC [expr $apANS($sN,cSpan) - 1]
      set nR [expr $apANS($sN,rSpan) - 1]

# LOOP over the plot cells which contain this layout and update the
#   the annotation status fields

      set bC $apANS($sN,Col)
      for { set C 0 } { $C <= $nC } { incr C ; incr bC } {
         set bR $apANS($sN,Row)
         for { set R 0 } { $R <= $nR } { incr R ; incr bR } {
            set P $bC.$bR.aLab
            if {$C == 0}   {set apANS($P) [lreplace $apANS($P) 2 2 $Yl]} 
            if {$C == $nC} {set apANS($P) [lreplace $apANS($P) 3 3 $Yr]}
            if {$R == 0}   {set apANS($P) [lreplace $apANS($P) 1 1 $Xt]} 
            if {$R == $nR} {set apANS($P) [lreplace $apANS($P) 0 0 $Xb]}
         }
      }
   }

# DO the same for the addition of a colorbar

   for { set I 0 } { $I < $nP } { incr I } {

# THE slot number of the plot layout

      scan [$Wlay get $I] "%d" sN

# IS there a colorbar included with this plot and where is it being output.
#   Also determines number of rows or columns spanned by the colorbar. This 
#   depends on which direction the colorbar is being output
#
# REMEMBER: The spanning field has the format S,DS where S is the span
#   length and DS is an additional dummy span to allow for axis adjustment.

      if [string match YES $apANS($sN,cBShow)] {
         switch -exact -- $apANS($sN,cBLoc) {
	    LEFT   { set cB 1 }
	    RIGHT  { set cB 2 }
	    BOTTOM { set cB 3 }
	    TOP    { set cB 4 }
         } 
	 set sC [split $apANS($sN,cBSpan) ","] 
	 if { [llength $sC] > 1 } {
	    set SpaN [expr [lindex $sC 0] + [lindex $sC 1] - 1]
         } else { set SpaN [expr [lindex $sC 0] - 1] }
         switch -exact -- $apANS($sN,cBDir) {
	    VERTICAL    { set nC 0 ; set nR $SpaN }
	    RHORIZONTAL - 
	    LHORIZONTAL { set nR 0 ; set nC $SpaN }
         } 
      } else { set cB 0 ; set nC 0 ; set nR 0 }

# LOOP over the plot cells which contain this colorbar and update the
#   the colorbar field

      set bC $apANS($sN,Col)
      for { set C 0 } { $C <= $nC } { incr C ; incr bC } {
         set bR $apANS($sN,Row)
         for { set R 0 } { $R <= $nR } { incr R ; incr bR } {
            set P $bC.$bR.cBPos
	    lappend apANS($P) $cB
         }
      }
   }

# MARK all the plots which make use of the Z axis. Won't get them all
#   but will get most.  These plots require the VTK graphics driver.
#   For now if there is a Z variable defined for a plot then it needs
#   a Z axis.  Loop is over the measurements to be plotted.

   for { set I 0 } { $I < $nV } { incr I } {
      scan [$WPlot get $I] "%d" sN
      set J [lindex $apANS($apANS($sN,pID)) 0]
      set pN $apANS($J,Col).$apANS($J,Row).3D
      if { [string length $apANS($sN,VarZ)] > 0 } { set apANS($pN) 1 }
   }

#  DETERMINE which axis are active within a plot by looking through 
#    the variables being plotted to see what axis they use.  Also get 
#    a list of any variables used to autoscale each axis (if any).

   for { set I 0 } { $I < $nV } { incr I } {
      scan [$WPlot get $I] "%d" sN
      set piD $apANS($sN,pID)

      if [string match Xb $apANS($sN,xActive)] {
         set apANS($piD) [lreplace $apANS($piD) 1 1 1] 
      } else { set apANS($piD) [lreplace $apANS($piD) 2 2 1] }
      if [string match Yl $apANS($sN,yActive)] {
           set apANS($piD) [lreplace $apANS($piD) 3 3 1] 
      } else { set apANS($piD) [lreplace $apANS($piD) 4 4 1] }

      if [string match YES $apANS($sN,aScaX)] {
         if { [string length $apANS($sN,VarX)] > 0 } {
            lappend apANS($piD.$apANS($sN,xActive)) $apANS($sN,VarX)
         }
      }
      if [string match YES $apANS($sN,aScaY)] {
         if { [string length $apANS($sN,VarY)] > 0 } {
            lappend apANS($piD.$apANS($sN,yActive)) $apANS($sN,VarY)
         }
      }
      if [string match YES $apANS($sN,aScaZ)] {
         if { [string length $apANS($sN,VarZ)] > 0 } {
            lappend apANS($piD.Z) $apANS($sN,VarZ)
         }
      }
      if [string match YES $apANS($sN,aScaI)] {
         if { [string length $apANS($sN,VarI)] > 0 } {
            lappend apANS($piD.I) $apANS($sN,VarI)
         }
      }
   }

# DETERMINE layout blocks.  A block of layouts is any set of layouts which
#   has annotation or colorbars only on the outer edges of the block. 
#   Each block can be optimized for size of the plots as well as keeping
#   all plots in the block at a common size.
#
# BLOCKS as determined by looking down the plot grid columns

   for { set C 0 } { $C < $apANS(maxCol) } { incr C } {

# SET end of plot block flag and new block flag.

      set EnD 0
      set NeW 1

# LOOP down the column 

      for { set R 0 } { $R < $apANS(maxRow) } { incr R } {

# SET current cell ID 

         set P $C.$R

# THIS is the state of the axis labeling on the lower and upper X axis for
#   this cell and whether there is a colorbar.

	 set BoT [lindex $apANS($P.aLab) 0]
	 set ToP [lindex $apANS($P.aLab) 1] 
	 set nCB [llength $apANS($P.cBPos)]
	 set cB 0
	 if { $nCB != 0 } {
	    for { set J 0 } { $J < $nCB } { incr J } {
	       if { [lindex $apANS($P.cBPos) $J] == 3 } { incr cB 3 }
	       if { [lindex $apANS($P.cBPos) $J] == 4 } { incr cB 4 }
	    }
         }

# CHECK for start of a layout block definition

         if $NeW {

# INITIALIZE the following variables
#
#  tlG    : Total number of labeled X axes in the layout block 
#  tcG    : Total number of colorbars in the layout block 
#  bR     : First row in layout block
#  tN     : Total number of cells occupied by the block down the column
#  pL     : A list of all of the cells in the current layout block
#  Offset : List of x axis labels above the current cell 
#  Coff   : List of x axis colorbars above the current cell 
#  sBot   : Bottom annotation flag of first cell in layout block
#  sTop   : Top annotation flag of first cell in layout block

            set tlG 0
            set tcG 0
	    set bR $R
            set tN 0
            set pL ""
            set Offset ""
            set Coff ""
	    set NeW  0
	    set EnD  0
         }

# NEED to check and see how this cell fits into the layout block.  If the
#    cell has a bottom label or bottom colorbar then it is the last cell
#    in the current block.  If it it has a top label or colorbar then it
#    is the first cell in the next block UNLESS this is the first cell in
#    the layout block in which case this is OK.

         set Current 1
         if { $BoT || ($cB == 3) || ($cB == 7) } {
	    set EnD 1
         } elseif { $ToP || ($cB == 4) || ($cB == 7) } {
            if { $tN > 0 } {
	       set EnD 1
	       incr R -1
	       set Current 0
	    } 
         }

         if $Current {
	    lappend Offset $tlG
	    lappend Coff   $tcG
	    lappend pL $P
            set tlG [expr $tlG + $ToP + $BoT ]
	    if { ($cB == 3) || ($cB == 4) } { incr tcG }
	    if { $cB == 7 } { incr tcG }
	    incr tN
         }

# ADD all of the pertinent information to the cell information list if we
#   have ended a layout block

         if { $EnD || ( $R == $LastR ) } {
            set NeW 1
            set LeN [llength $pL]
            for { set I 0 } { $I < $LeN } { incr I } {
               set P [lindex $pL $I].cBlk 
               set tO [lindex $Offset $I]
               set tC [lindex $Coff $I]
               set apANS($P) [lreplace $apANS($P) 0 5 $bR $tlG $tO $tN $tcG $tC]
            }
         }
      }
   }

# BLOCKS as detrmined by looking across the plot grid row

   for { set R 0 } { $R < $apANS(maxRow) } { incr R } {

# SET end of plot block flag and new block flag.

      set EnD 0
      set NeW 1

# LOOP across the row 

      for { set C 0 } { $C < $apANS(maxCol) } { incr C } {

# SET current cell ID 

         set P $C.$R

# THIS is the state of the axis labeling on the left and right Y axis for
#   this cell and whether there is a colorbar.

	 set LefT  [lindex $apANS($P.aLab) 2]
	 set RighT [lindex $apANS($P.aLab) 3] 
	 set nCB [llength $apANS($P.cBPos)]
	 set cB 0
	 if { $nCB != 0 } {
	    for { set J 0 } { $J < $nCB } { incr J } {
	       if { [lindex $apANS($P.cBPos) $J] == 1 } { incr cB 1 }
	       if { [lindex $apANS($P.cBPos) $J] == 2 } { incr cB 2 }
	    }
         }

# CHECK for start of a layout block definition

         if $NeW {

# INITIALIZE the following variables
#
#  tlG    : Total number of labeled X axes in the layout block 
#  tcG    : Total number of colorbars in the layout block 
#  bR     : First row in layout block
#  tN     : Total number of cells occupied by the block down the column
#  pL     : A list of all of the cells in the current layout block
#  Offset : List of x axis labels above the current cell 
#  Coff   : List of x axis colorbars above the current cell 
#  sBot   : Bottom annotation flag of first cell in layout block
#  sTop   : Top annotation flag of first cell in layout block

            set tlG 0
            set tcG 0
	    set bC $C
            set tN 0
            set pL ""
            set Offset ""
            set Coff ""
	    set NeW  0
	    set EnD  0
         }

# NEED to check and see how this cell fits into the layout block.  If the
#    cell has a right label or right colorbar then it is the last cell
#    in the current block.  If it it has a left label or colorbar then it
#    is the first cell in the next block UNLESS this is the first cell in
#    the layout block in which case this is OK.

         set Current 1
         if { $RighT || ($cB == 2) || ($cB == 3) } {
	    set EnD 1
         } elseif { $LefT || ($cB == 1) || ($cB == 3) } {
            if { $tN > 0 } {
	       set EnD 1
	       incr C -1
	       set Current 0
	    } 
         }

         if $Current {
	    lappend Offset $tlG
	    lappend Coff   $tcG
	    lappend pL $P
            set tlG [expr $tlG + $RighT + $LefT ]
	    if { ($cB == 1) || ($cB == 2) } { incr tcG }
	    if { $cB == 3 } { incr tcG }
	    incr tN
         }

# ADD all of the pertinent information to the cell information list if we
#   have ended a layout block

         if { $EnD || ( $C == $LastC ) } {
            set NeW 1
            set LeN [llength $pL]
            for { set I 0 } { $I < $LeN } { incr I } {
               set P [lindex $pL $I].rBlk 
               set tO [lindex $Offset $I]
               set tC [lindex $Coff $I]
               set apANS($P) [lreplace $apANS($P) 0 5 $bC $tlG $tO $tN $tcG $tC]
            }
         }
      }
   }
}
