package provide UDFAnalysis 1.0

proc APpolyDeriv { Cfx Cfy Cfz fO Deriv Type X Y Z ReT } {
   global apANS env Prefs

   set nD [llength $Deriv]
   if { $nD == 0 } { return }

   upvar $Cfx cX
   upvar $Cfy cY
   upvar $Cfz cZ
   upvar $ReT rV

# COMPUTE the derivatives we will need.  GRAD and LAPLACIAN operate
#    on scalar functions and DIV and CURL on vector functions

   if [string match SCALAR $Type] {
      switch -exact -- $fO {
         1 { 
            set dXdX $cX(1) ; set dXdY $cX(2) ; set dXdZ $cX(3)
            set dX2 0.0   ; set dY2 0.0   ; set dY2 0.0
         }
         2 { 
            set dXdX [expr $cX(1) + 2.0*$cX(4)*$X + $cX(5)*$Y + $cX(6)*$Z]
            set dXdY [expr $cX(2) + $cX(5)*$X + 2.0*$cX(7)*$Y + $cX(8)*$Z]
            set dXdZ [expr $cX(3) + $cX(6)*$X + $cX(8)*$Y + 2.0*$cX(9)*$Z]
            set dX2 [expr 2.0 * $cX(4)]
            set dY2 [expr 2.0 * $cY(7)]
            set dZ2 [expr 2.0 * $cZ(9)]
         }
      } 
   } else {
      switch -exact -- $fO {
         1 { 
            set dXdX $cX(1) ; set dXdY $cX(2) ; set dXdZ $cX(3)
            set dYdX $cY(1) ; set dYdY $cY(2) ; set dYdZ $cY(3)
            set dZdX $cZ(1) ; set dZdY $cZ(2) ; set dZdZ $cZ(3)
         }
         2 { 
            set dXdX [expr $cX(1) + 2.0*$cX(4)*$X + $cX(5)*$Y + $cX(6)*$Z]
            set dXdY [expr $cX(2) + $cX(5)*$X + 2.0*$cX(7)*$Y + $cX(8)*$Z]
            set dXdZ [expr $cX(3) + $cX(6)*$X + $cX(8)*$Y + 2.0*$cX(9)*$Z]
            set dYdX [expr $cY(1) + 2.0*$cY(4)*$X + $cY(5)*$Y + $cY(6)*$Z]
            set dYdY [expr $cY(2) + $cY(5)*$X + 2.0*$cY(7)*$Y + $cY(8)*$Z]
            set dYdZ [expr $cY(3) + $cY(6)*$X + $cY(8)*$Y + 2.0*$cY(9)*$Z]
            set dZdX [expr $cZ(1) + 2.0*$cZ(4)*$X + $cZ(5)*$Y + $cZ(6)*$Z]
            set dZdY [expr $cZ(2) + $cZ(5)*$X + 2.0*$cZ(7)*$Y + $cZ(8)*$Z]
            set dZdZ [expr $cZ(3) + $cZ(6)*$X + $cZ(8)*$Y + 2.0*$cZ(9)*$Z]
         }
      }
   }

   for { set I 0 } { $I < $nD } { incr I } {
      switch -exact -- [lindex $Deriv $I] {
         DOT {  set rV(0) [expr $dXdX + $dYdY + $dZdZ] }
	 CROSS {
            set rV(1) [expr $dZdY - $dYdZ]
            set rV(2) [expr $dXdZ - $dZdX]
            set rV(3) [expr $dYdX - $dXdY]
         }
         LAPLACIAN { set rV(0) [expr $dX2 + $dY2 + $dZ2] }
	 GRADIENT  { set rV(1) $dXdX ; set rV(2) $dXdY ; set rV(3) $dXdZ }
      }
   }
}
