package provide UDFAnalysis 1.0

proc APmemGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set SP [list LINEAR LOG]
   set RT [list POWER RAW]
   set PD [list YES NO]

   set mN MEM
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) $mN"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT Input Power Freq Coef "Beg Hz" "End Hz" Steps \
                  Spacing Pad Ret]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUIblankCol $We 0 1
      GUILabel $We.l0  "Input" c grid|$R|1|e -1 0 "" $LFonT
      GUIblankCol $We 2 1
      GUIboxEntry $We.mi grid|$R|3|news 11 apANS($fD,MEMvar)
      GUIblankCol $We 4 6
      GUIboxEntry $We.mc grid|$R|5|news 11 apANS($fD,MEMcoef)
      GUIblankCol $We 6 1
      GUILabel $We.l1  "Coefficients" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l2  "Output Power" c grid|$R|1|e -1 0 "" $LFonT
      GUIboxEntry $We.mp grid|$R|3|news 11 apANS($fD,MEMpwr)
      GUIboxEntry $We.mbf grid|$R|5|news 11 apANS($fD,MEMbfq)
      GUILabel $We.l3  "Begin Frequency (Hz)" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l4  "Output Frequency" c grid|$R|1|e -1 0 "" $LFonT
      GUIboxEntry $We.mf grid|$R|3|news 11 apANS($fD,MEMfq)
      GUIboxEntry $We.mef grid|$R|5|news 11 apANS($fD,MEMefq)
      GUILabel $We.l5  "End Frequency (Hz)" c grid|$R|7|w -1 0 "" $LFonT

      incr R 
      GUILabel $We.l6  "Number of Steps"  w grid|$R|1|w  -1 0 "" $LFonT
      GUIboxEntry $We.mfs grid|$R|3|news 11 apANS($fD,MEMnfq)
      GUIbuttonToggle $We.sp $apANS($fD,MEMsp) grid|$R|5|w $SP  \
                       "GUIoptsToggle $We.sp apANS($fD,MEMsp) PRI" 9,0.5
      GUILabel $We.l7  "Spacing"  w grid|$R|7|w  -1 0 "" $LFonT

      incr R 
      GUILabel $We.l8  "Return"  w grid|$R|1|w  -1 0 "" $LFonT
      GUIbuttonToggle $We.ret $apANS($fD,MEMret) grid|$R|3|w $RT  \
                       "GUIoptsToggle $We.ret apANS($fD,MEMret) PRI" 9,0.5
      GUIbuttonToggle $We.pd $apANS($fD,MEMsp) grid|$R|5|w $PD  \
                       "GUIoptsToggle $We.pd apANS($fD,MEMpad) PRI" 9,0.5
      GUILabel $We.l9  "Pad"  w grid|$R|7|w  -1 0 "" $LFonT


      bind $W <Down> { APtwinCmd MEM %W MOVE DOWN }
      bind $W <Up> { APtwinCmd MEM %W MOVE UP }

      APallInits  $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI   $mN $fD

   } else { GUIwindowCtrl $W }
}
