# GENERIC procedure to return the Legengre Polynominal basis functions
#   This is taylored for use in TUdataLSq1D

package provide UDFAnalysis 1.0

proc APlpolyFunc { X cM nC } {

   upvar $cM A

   set A(0) 1.0
   set A(1) $X

   if { $nC > 1 } {
      set tX [expr 2.0 * $X]
      set J 0
      set K 1
      for { set I 2 } { $I < $nC } { incr I ; incr J ; incr K } { 
	 set X [expr $X + $tX]
         set A($I) [expr ($X * $A($K) - $K * $A($J))/ ($K + 1.0)]
      }
   }
}
