package provide UDFAnalysis 1.0

# EXPANDS a fit.  A fit can be expanded provide input to a plot or to
#    provide an array of the same size as the data set being fitted
#    which can be use in other function calls.  It can be plotted too.
#
#    When exL < 0 then we are fitting to a plot
#
# NOTE!!!!
#
#   The current version of this routine only works with 1D data!

proc APexpandFit { pN fInfo iX iY iZ iV { exL -1 } } {
   global env Prefs PltInfo WinInfo _X_ apANS

   upvar $fInfo fI 
   upvar $iX _tX
   upvar $iV _tV

# GET the function being fit if one exists.  This just strips off any
#   leading directory info

   if ![string match "---" $fI(fFunc)] {
      set fFunC [file tail $fI(fFunc)]
   } else { set fFunC "" }

# IF this is a plot based expand then we need to create and X and maybe a 
#   Y array based on the number of pixels along the plot axis. If not then 
#   use the data which was passed in in the iX and iY arrays

   if { $exL <= 0 } {

# Expand according to plot pixels.  There is always an X array

      set wN $PltInfo($pN,wN)

      if { $WinInfo($wN,a0) == 0 } {
         set BeGx $WinInfo($wN,p0)
         set EnDx $WinInfo($wN,p3)
      } else {
         set BeGx [expr log10($WinInfo($wN,p0))]
         set EnDx [expr log10($WinInfo($wN,p3))]
      }

      set nP [expr int([lindex $PltInfo($pN,Pix) 0])]
      set InCx [expr ($EnDx - $BeGx) / double ($nP - 1)]
      for { set I 0 } { $I < $nP } { incr I } {
	 set _tX($I) [expr $BeGx + $I * $InCx] 
      }

      if { $WinInfo($wN,a0) == 1 } {
         for { set I 0 } { $I < $nP } { incr I } {
            set _tX($I) [expr pow(10.0, $_tX($I))]
         }
      }

   } else { 
      set n0 [lindex $_tX(Dim) 0]
      set n1 [lindex $_tX(Dim) 1]
      if { $n1 > 1 } { set nP $n1 } else { set nP $n0 }
   }

# WE need a nodata array for all of the involved input or computed arrays
#   and copy the data to temporary arrays taking LOG were necessary

   if [string match Log $fI(xSca)] {
      set BaD 0.0 ; set sFlag(X) LOG10
   } else { set BaD $apANS(BaDL) ; set sFlag(X) COPY }
   APbadGrid FLAG $nP _tX _OK 0 $BaD
   set nP [APcopyGrid $sFlag(X) 0 $nP _tX _X_ _OK]

   if [string match YES $fI(LSq)] {
      if { $fI(fDim) == 1 } {
	 for { set I 0 } { $I < $nP } { incr I } {
	    set _tV($I) 0.0
	    if $_OK($I) {
	       eval $fFunC $_X_($I) xA $fI(nC)
	       for { set J 0 } { $J < $fI(nC) } { incr J } {
	          set _tV($I) [expr $_tV($I) + $xA($J) * $fI($J)]
               }
            }
	 }
      } else {
      }
   } else {

# FIT coefficients need to go into an array beginning at location 5.
#    Location 4 in the same array as the offset into the X array

      set J 5
      for { set I 0 } { $I < $fI(nC) } { incr I ; incr J } {
         set tA($J) $fI($I)
      }

      for { set I 0 } { $I < $nP } { incr I } {
	 set tA(4) $I
	 if $_OK($I) {
            eval set _tV($I) [$fFunC $fI(nC) DummY tA]
         } else { set _tV($I) 0.0 }
      }
   }

   unset _X_

   if [string match Log $fI(vSca)] {
      for { set I 0 } { $I < $nP } { incr I } {
         set _tV($I) [expr pow(10.0, $_tV($I))] 
      }
   }

   APbadGrid RESET $nP _tX _OK 0 $apANS(BaD)
   APbadGrid RESET $nP _tV _OK 0 $apANS(BaD)

   return $nP
}
