package provide UDFAnalysis 1.0

proc APdpsGUI { fD { ImC 0 } } {
  global apANS env Prefs

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   set YN [list NO YES]

   set mN DYNAMIC-PS
   APallInits FUNCTION $fD
   APallInits $mN $fD

   set opMet [list MEM FFT]
   set opLL  [list LOG LINEAR]

   set W  .apFDEF$fD
   set LaB "$apANS($fD,Func) SETUP"
   if [GUIWindow $W $LaB] {
      if $ImC { GUIwindowCtrl .apFDEF$fD }
      set Wa $W.top
      set Wb $W.com
      set Wc $W.body
      set Wd $W.act
      set We $W.work

      GUIFrame $Wa -1 grid|0|0|e
      GUIFrame $Wb  2 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news
      GUIFrame $Wd -1 grid|3|0|news
      GUIFrame $We -1 grid|4|0|w
      
      GUIbuttonPush $Wa.close CLOSE grid|0|0|e "GUIwindowCtrl $W"  6
      GUIblankRow $Wa 1 0.5

      APtopplugGUI $fD $Wb FUNCTION

      set FmT [lindex [lindex $apANS($mN) 3] 0]
      set LaB [format $FmT Input Output Meth Len Adv Coef Steps \
                           "Beg Hz" "End Hz" Scale ]

      set R 0
      GUIblankRow $Wc $R 0.5
      incr R 
      GUILabel $Wc.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wc.list 55 7  grid|$R|0|ew "" single 0 1 $CFonT
      $Wc.list configure -exportselection false

      GUIbuttonPush $Wd.add  ADD grid|0|0 "APaddPItem $mN $fD FDEF" 6
      GUIblankCol $Wd 1 4
      GUIbuttonPush $Wd.edit EDIT grid|0|2 "APeditPItem $mN $fD FDEF" 6
      GUIbuttonPush $Wd.rep ACCEPT grid|0|3 "APaddPItem $mN $fD FDEF REPLACE" 6
      GUIblankCol $Wd 4 4
      GUIbuttonPush $Wd.unset  UNSET grid|0|5 "APtwinCmd $mN $W UNSET" 6
      GUIbuttonPush $Wd.reset  RESET grid|0|6 "APvarReset $mN $fD" 6
      GUIblankCol $Wd 7 4
      GUIbuttonPush $Wd.delete DELETE grid|0|8 "APtwinCmd $mN $W DELETE" 6

      set R 0
      GUIblankRow $We $R 2.5

      incr R 
      GUILabel $We.la$R  "Input" c grid|$R|1|ew -1 0 "" $LFonT
      GUILabel $We.lb$R  "Output" c grid|$R|2|ew -1 0 "" $LFonT

      incr R 
      GUILabel $We.l$R  "Variables" c grid|$R|0|ew -1 0 "" $LFonT
      GUIboxEntry $We.in grid|$R|1|ew 11 apANS($fD,iN)
      GUIboxEntry $We.out grid|$R|2|ew 11 apANS($fD,ouT)

      incr R 
      GUIblankRow $We $R 1.5

      incr R 
      GUILabel $We.la$R  "Method" c grid|$R|1|ew -1 0 "" $LFonT
      GUILabel $We.lb$R  "Length" c grid|$R|2|ew -1 0 "" $LFonT
      GUILabel $We.lc$R  "Advance" c grid|$R|3|ew -1 0 "" $LFonT

      incr R 
      GUILabel $We.l$R  "Gen Ops" c grid|$R|0|ew -1 0 "" $LFonT
      GUIbuttonToggle $We.met $apANS($fD,dpMet) grid|$R|1|ew $opMet \
              "GUIoptsToggle $We.met apANS($fD,dpMet) PRI" 
      GUIboxEntry $We.len grid|$R|2|ew 11 apANS($fD,Len)
      GUIboxEntry $We.adb grid|$R|3|ew 11 apANS($fD,Adv)

      incr R 
      GUIblankRow $We $R 1.5

      incr R 
      GUILabel $We.la$R  "Coef" c grid|$R|1|ew -1 0 "" $LFonT
      GUILabel $We.lb$R  "FSteps" c grid|$R|2|ew -1 0 "" $LFonT
      GUILabel $We.lc$R  "Beg Hz" c grid|$R|3|ew -1 0 "" $LFonT
      GUILabel $We.ld$R  "End Hz" c grid|$R|4|ew -1 0 "" $LFonT
      GUILabel $We.le$R  "Scale" c grid|$R|5|ew -1 0 "" $LFonT

      incr R 
      GUILabel $We.l$R  "MEM Ops" c grid|$R|0|ew -1 0 "" $LFonT
      GUIboxEntry $We.coef grid|$R|1|news 11 apANS($fD,nCoef)
      GUIboxEntry $We.fsteps grid|$R|2|news 11 apANS($fD,stepsF)
      GUIboxEntry $We.bhz grid|$R|3|news 11 apANS($fD,begF)
      GUIboxEntry $We.ehz grid|$R|4|news 11 apANS($fD,endF)
      GUIbuttonToggle $We.sca $apANS($fD,fSca) grid|$R|5|ew $opLL \
              "GUIoptsToggle $We.sca apANS($fD,fSca) PRI" 

      bind $W <Down> { APtwinCmd DYNAMIC-PS %W MOVE DOWN }
      bind $W <Up> { APtwinCmd DYNAMIC-PS %W MOVE UP }

      APallInits  $mN $fD
      if [info exists apANS($mN$fD,rd)] { APfillPLBox $mN $fD FDEF }
      APfillGUI   $mN $fD

   } else { GUIwindowCtrl $W }
}
