# package provide UDFAnalysis 1.0

proc APcolorPick { pW vN } {
   global Prefs cRGB cHEX CDone apANS

   if { [string length $apANS($vN)] == 0 } {
      set cHEX #000000000000
   } else { set cHEX $apANS($vN) } 

# BLACK        RED        ORANGE        ORANGERED   YELLOW       YELLOWGREEN 
# GREENYELLOW  GREEN      CYAN          BLUE        PURPLE       MAGNETA
# WHITE        GRAY       CHOCOLATE     FIREBRICK   INDIGO       PLUM
# FORESTGREEN  SIENNA     MIDNIGHTBLUE  ORCHID      SILVER       BLUEVIOLOT
# DARKSALMON   GOLDENROD  CRIMSON       NAVY        NAVAJOWHITE  HOTPINK
# SLATEBLUE    ROYALBLUE  TEAL          MAROON      DODGERBLUE   BURLEYWOOD 


   set PreSelect [list \
       #000000 #FF0000 #FFA500 #FF4500 #FFFF00 #9ACD32 \
       #ADFF2F #00FF00 #00FFFF #0000FF #800080 #FF00FF \
       #FFFFFF #808080 #D2691E #B22222 #4B0082 #DDA0DD \
       #228B22 #A0522D #191970 #DA70D6 #C0C0C0 #8A2BE2 \
       #E9967A #DAA520 #DC143C #000080 #FFDEAD #FF6984 \
       #6A5ACD #4169E1 #008080 #080000 #1E90FF #DEB887 ]

   set W  .fC
   set Wa .fC.top
   set Wb .fC.colors
   set Wc .fC.chooser

   if { [info exists CDone] } { unset CDone }

   TUconvColor HEX cRGB cHEX 

   set LaB "Color Picker"
   if [GUIWindow $W $LaB] {

      GUIFrame $Wa -1 grid|0|0|news
      GUIFrame $Wb -1 grid|1|0|w
      GUIFrame $Wc -1 grid|2|0|news

      GUILabel $Wb.ml "PreDefined" c grid|0|0|news||6 0 0 "" [list "" "" bold]
      set Len [llength $PreSelect]
      for { set I 0 } { $I < $Len } { incr I } {
         set R [expr $I / 6 + 1]
         set C [expr $I % 6]
         set cH [lindex $PreSelect $I]
         GUIbuttonPush $Wb.b$I "" grid|$R|$C "APshowColor $cH" 8 2 ""
         $Wb.b$I configure -bg $cH
      }

      GUILabel $Wc.ml "User Defined" c grid|0|0|news||2 0 0 "" [list "" "" bold]
      GUILabel $Wc.rl "R" c grid|1|0|w 6 0 #FF0000
      GUILabel $Wc.gl "G" c grid|2|0|w 6 0 #00FF00
      GUILabel $Wc.bl "B" c grid|3|0|w 6 0 #0000FF
      GUISlider $Wc.red "" grid|1|1|e 0 255 0 200 x ""
      GUISlider $Wc.green "" grid|2|1|e 0 255 0 200 y ""
      GUISlider $Wc.blue "" grid|3|1|e 0 255 0 200 z ""

      GUIbuttonPush $Wa.can "CANCEL" grid|0|0|w "APdoneColor $pW $W NoPiCk" 4,0
      GUIbuttonPush $Wa.ok "SELECT" grid|0|1|e "APdoneColor $pW $W $vN" 4,0
      GUIchgConf $Wa.ok "" "" "" "" raised
      GUIbuttonPush $Wa.sh "" grid|1|0 "" 0 12 
      GUIchgConf $Wa.sh "" "" "" "" sunken
      GUIboxEntry $Wa.hex grid|1|1 15 cHEX center [list "" "" bold]

   } else { GUIwindowCtrl $W }

   $Wc.red set $cRGB(0)
   $Wc.green set $cRGB(1)
   $Wc.blue set $cRGB(2)

   set C [format "#%04x%04x%04x" $cRGB(0) 0 0]
   $Wc.red configure -troughcolor $C
   set C [format "#%04x%04x%04x" 0 $cRGB(1) 0]
   $Wc.green configure -troughcolor $C
   set C [format "#%04x%04x%04x" 0 0 $cRGB(2)]
   $Wc.blue configure -troughcolor $C

   $Wc.red configure   -command "APreadColor $Wc.red 0 "
   $Wc.green configure -command "APreadColor $Wc.green 1 "
   $Wc.blue configure  -command "APreadColor $Wc.blue 2 "

   tkwait variable CDone
   if { [info exists CDone] } { unset CDone }
}
