# THIS gets a line of information to go into a text window

package provide UDFAnalysis 1.0

proc APtwinGet { Menu I } {
   global apANS GUIoptPri GUIoptAlts

   switch -exact -- $Menu {
      FUNCTION {
         set FmT "%2d $apANS(FuncTf)"
         set vList [list $I $apANS($I,Func) $apANS($I,Com)]
         set fList [list %2d %s %s %s]
      }
      LABEL {
         set FmT "%-4s  %-25s  %-6s  %-8s  %-5s  %-5s"
         if { [string length $apANS($I,Lab)] > 25 } {
            set vL [string range $apANS($I,Lab) 0 20]
            append vL " ..."
         } else { set vL $apANS($I,Lab) }
         set vList [list $I $vL $apANS($I,Lpid) \
	                     $apANS($I,Lcol) $apANS($I,Lsize) \
	                     $apANS($I,Lbold)]
	 set fList [list %4d %s %s %s %s %s]
      }
      PLOT {
         set FmT "%-4s  %-6s  %-9s  %-12s  %-12s  %-12s  %-12s"
         set vList [list $I $apANS($I,pID) $apANS($I,pType) \
                               $apANS($I,VarX) $apANS($I,VarY) \
                               $apANS($I,VarZ) $apANS($I,VarI)]
         set fList [list %4d %s %s %s %s %s %s]
      }
      LAYOUT {
         set FmT "%-4s  %-6s  %-6s  %-6s   %-6s  %-6s"
         set vList [list $I $apANS($I,piD) $apANS($I,Row) \
                             $apANS($I,Col) $apANS($I,rSpan) \
	                     $apANS($I,cSpan)]
         set fList [list %4d %s %3d %3d %3d %3d]
      }
      VECTOR {
         set fList [list %s %s %s %s]
      }
      VARIABLE {
         set FmT "%2d $apANS(VarTf)"
         if { [string length $apANS($I,Var)] > 29 } {
            set vL [string range $apANS($I,Var) 0 24]
            append vL " ..."
         } else { set vL $apANS($I,Var) }

         set vList [list $I $vL $apANS($I,Src) $apANS($I,gFill)]
         set fList [list %2d %s %s %s]
      }
   }

   set nO [llength $vList]
   set CmD [list format $FmT]
   for { set J 0 } { $J < $nO } { incr J } {
       set V [lindex $vList $J]
       set P $V
       if { [string length $V] == 0 } {
          set P $apANS(EmptyVar)
       } else { 
          if [regexp {^[+-]?[0-9]+$} $V)] { 
             set P [format [lindex $fList $J] $V] 
          }
       }

       lappend CmD $P
   }

   set LaB [eval $CmD]

   return $LaB
}
