package provide UDFAnalysis 1.0

proc APsolveTrim { nE iN ouT Cond Value } {
   global apANS 

   upvar $iN  _dataI
   upvar $ouT _dataO

# GET rid of any bad data which are on the leading or trailing edges of the
#    the array.  This probably has its origin in a previously called filter
#    function.

   set sCnT 0
   set eCnT [expr $nE - 1]

   switch -exact -- $Cond {
      == {
         while { $_dataI($sCnT) == $Value } { incr sCnT }
         while { $_dataI($eCnT) == $Value } { incr eCnT -1 }
      }
      != {
         while { $_dataI($sCnT) != $Value } { incr sCnT }
         while { $_dataI($eCnT) != $Value } { incr eCnT -1 }
      }
      < {
         while { $_dataI($sCnT) < $Value } { incr sCnT }
         while { $_dataI($eCnT) < $Value } { incr eCnT -1 }
      }
      <= {
         while { $_dataI($sCnT) <= $Value } { incr sCnT }
         while { $_dataI($eCnT) <= $Value } { incr eCnT -1 }
      }
      > {
         while { $_dataI($sCnT) > $Value } { incr sCnT }
         while { $_dataI($eCnT) > $Value } { incr eCnT -1 }
      }
      >= {
         while { $_dataI($sCnT) >= $Value } { incr sCnT }
         while { $_dataI($eCnT) >= $Value } { incr eCnT -1 }
      }
   }


# TRANSFER the trimmed array to the output array
 
   set CnT 0
   for { set K $sCnT } { $K <= $eCnT } { incr K } {
      set _dataO($CnT) $_dataI($CnT)
      incr CnT
   }

   return $CnT
}
