#  THIS procedure takes an array of phase angles and breaks it into single 
#  spin blocks.

package provide UDFAnalysis 1.0

proc APsolveSpin { fD } {
   global apANS env Prefs RtoD

   APkeepTabs "STEP $fD : SPIN"

# THIS is the text window for this function definition
 
   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return
 
   if { $nF == 0 } { return }

# LOOP over the instances and define spins

   for { set I 0 } { $I < $nF } { incr I } {

# GET the conversion definition

      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s" _vI _vO _vSt _vT _vS 

# GET the input and output variables. 
#
# A. There is at least one phase input
#    variable and possibly 2 (start and stop phase).  If there is only
#    one phase variable link what would be the stop phase to the start. 
#    This makes coding a bit cleaner.
#
# B. There should two output variables, one holding the locations of the
#    spin starts and one the locations of the spin endings.
#
# C. There is one optional output vatiable and two optional input variables.  
#    The output variable is a Status array, one value per spin.  This is 
#    0 if the spin has problems and 1 if OK. Of the optional input variables
#    one contains the times and one contains the spin periods.  Both of these 
#    are used as constraints in determing the spin status.
 
# CHECK what variables are present and create the links for those that are.
#  
# PHASE variables
 
      set vNames [lindex [APgetVNames $_vI] 0]
      set nI [llength $vNames]
      if { $nI == 0 } { 
         puts stderr "APsolveSpin: NO Input Variables"
	 return 
      }
      set vA [lindex $vNames 0] 
      global  [set vA] ; upvar 0 [set vA] _pH0
      set nX [lindex $_pH0(Dim) 0]
      set nY [lindex $_pH0(Dim) 1]
      if { $nI > 1 } {
         set vA [lindex $vNames 1] 
	 global  [set vA] ; upvar 0 [set vA] _pH1
      } else { global  [set vA] ; upvar 0 [set vA] _pH1 }

# OUTPUT variables
 
      set vNames [lindex [APgetVNames $_vO] 0]
      set nO [llength $vNames]
      if { $nO < 2 } { 
         puts stderr "APsolveSpin: Only $nO Ouput Variables"
	 return 
      }
      set vA [lindex $vNames 0] 
      global  [set vA] ; upvar 0 [set vA] _sS0
      set vA [lindex $vNames 1] 
      global  [set vA] ; upvar 0 [set vA] _sS1

# TIME Variables
 
      set vNames [lindex [APgetVNames $_vT] 0]
      set nT [llength $vNames]
      if { $nT > 0 } {
         set vA [lindex $vNames 0] 
	 global  [set vA] ; upvar 0 [set vA] _tM0
         if { $nT > 1 } {
            set vA [lindex $vNames 1] 
	    global  [set vA] ; upvar 0 [set vA] _tM1
         } else { global  [set vA] ; upvar 0 [set vA] _tM1 }
      }

# SPIN PERIOD Variable
 
      set vNames [lindex [APgetVNames $_vS] 0]
      set nS [llength $vNames]
      if { $nS > 0 } {
         set vA [lindex $vNames 0]
         global  [set vA] ; upvar 0 [set vA] _sP
      }

# STATUS Variable
 
      set vNames [lindex [APgetVNames $_vSt] 0]
      if { [llength $vNames] > 0 } {
         set vA [lindex $vNames 0]
         global  [set vA] ; upvar 0 [set vA] _sT
      }

# DETERMINE the spin direction. Counter-Clockwise (diR > 0) or clockwise 
#   (diR < 0). Look at the first 50 values or however many there are.
 
      if { $nX < 50 } { set EnD $nX } else { set EnD 50 } 

      set diR 0
      for { set J 0 ; set K 1 } { $K < $EnD } { incr J ; incr K } {
         if { $_pH0($J) < $_pH0($K) } { incr diR } else { incr diR -1 }
      }

# CHECKS on spin locations depend on the spin direction.  The assumption is
#    that all phase angles lie between 0 and 360 degrees WITH the possible
#    exception of the ending phase angle at the transition. An as example, with 
#    a counter-clockwise spin the beg and ending phases at the transition might
#    be either 355, 365 degrees or 355, 5 degrees.

# IF there is no ending phase (ie the start and ending phase are the same) 
#    then adjust the location of the ending phase to be the next (and not
#    current) ending phase.
 
      set CnTr 0
      set BaseLine 0
      if { $_pH0(0) == $_pH1(0) } { set K 1 } else { set K 0 }

# COUNTER-CLOCKWISE
 
      if { $diR > 0 } { 

# Establish the beginning and ending angle of the spin. DoRoll is
#    initially 0 but changes to 1 when we cross the transition angle.

         set BegP $pH0(0)
         set EndP [expr $BegP + 360.0]
         set DoRoll 0

# _sS0 is the offset into the phase array to start of the current spin 
 
         set _sS0($CnTr) 0

# LOOP over the phases
 
         set nP [expr $nX * $nY]
         for { set J 0 } { $K < $nP } { incr J ; incr K } {

# GET all angles between 0 and 360 degees.
 
            set bP [expr fmod($pH0($J),360.0)]
            set eP [expr fmod($pH1($K),360.0)]

# IF we haven't previously crossed the transition point check if we have
#    with this pair of data points. Once we cross the transition point we
#    need to add 360 degrees to all phases. This is because the final
#    phase in the spin was set to be the start phase of the spin plus 360.
 
            if !$DoRoll {
               if { $bP > $eP } { 
                  set DoRoll 1 
                  set eP [expr $eP + 360.0]
               }
            } else {
               set bP [expr $bP + $DoRoll * 360.0]
               set eP [expr $eP + $DoRoll * 360.0]
            }

# SEE if we've reached the ending phase of the spin. If we have reset DoRoll
#    and set the offset into the phase array to stop of the current spin 
#    (_sS1)
 
            if {$eP >= $EndP} { 
               set DoRoll 0
               set _sS1($CnTr) [expr $J - 1]

# IF this is the first determined spin location check to see how accurate
#   it is and from that set up some parameters that can be used to check
#   future spins.  Note that this is only truely robust if both the time
#   and spin phase data was given as inputs.
 
                if !$BaseLine { 
		   if { ($nT > 0) && ($nS > 0) } {
                      set _T1 $_tM0([expr $_sS0($CnTr) / $nY])
                      set _T2 $_tM0([expr ($_sS1($CnTr) + 1) / $nY])
                      set dT [expr ($_T2 - $_T1) * 1000.0]
                      set _sPer $_sP([expr ($_sS0($CnTr)) / $nY])
		      set Frac [expr $dT / $_sPer]
		      if { ($Frac < 1.05) && ($Frac > 0.95) } {
		         set BaseLine 1
			 set psL [expr $_sS1($CnTr) - $_sS0($CnTr) + 1]
                         set _sT($CnTr) 1 
                      } else { set _sT($CnTr) 0 }
                   } else { 
		      set BaseLine 1
		      set psL [expr $_sS1($CnTr) - $_sS0($CnTr) + 1]
                      set _sT($CnTr) 1 
                   }
		} else {
		   set TpsL [expr $_sS1($CnTr) - $_sS0($CnTr) + 1.0]
		   set Frac [expr $TpsL / $psL]
		   if { ($Frac < 1.02) && ($Frac > 0.98) } {
                      set _sT($CnTr) 1 
                   } else { set _sT($CnTr) 0 }
		}
	       puts stderr "$CnTr $_sS0($CnTr) $_sS1($CnTr) $_sT($CnTr)"
 
	        incr CnTr

                set _sS0($CnTr) $J
                set BegP $pH0($J)
                set EndP [expr $BegP + 360.0]
            }
         }
      } else {
         set BegP $pH0(0)
         set EndP [expr $BegP - 360.0]
         set DoRoll 0

         set StartS 0
         for { set J 0 } { $K < $nP } { incr J ; incr K } {
            set bP $pH0($J)
            set eP $pH1($K)
	    if { $bP < 0 } { set bP [expr $bP + 360] }
	    if { $eP < 0 } { set eP [expr $eP + 360] }
            if !$DoRoll {
               if { $bP < $eP } { 
                  set DoRoll 1 
                  set eP [expr $eP - 360.0]
               }
            } else {
               set bP [expr $bP - $DoRoll * 360.0]
               set eP [expr $eP - $DoRoll * 360.0]
            }
            if {$eP <= $EndP} { 
               set DoRoll 0
               set StopS [expr $J - 1]
               set _T1 $Tm0([expr $StartS / $nY])
               set _T2 $Tm0([expr ($StopS + 1) / $nY])
               set dT [expr ($_T2 - $_T1) * 1000]
               set _spPer $sP([expr ($StartS) / $nY])
               set dSp [expr $dT / $_spPer]
               set Sec [expr ($StopS - $StartS + 11) / $nY]
	       set _sS0(CnTr) $StartS
	       set _sS1(CnTr) $StopS
	       incr CnTr
               set StartS $J
               set BegP $pH0($J)
               set EndP [expr $BegP - 360.0]
            }
         }
      }
   }
}
