package provide UDFAnalysis 1.0

# Runs and Minimum Variance Analysis over the indicated time and returns
#   a rotation matrix to take data into the MVA frame
# 
# 1. Input data set must be a vector (variable of order 3) with the varaibles
#    being input as X, Y, and Z.
#
# 2. You can return a maximum of two items.  The first is always the 
#    rotaton matrix.  If there is a second output variable present then
#    that would be the computed eigenvales

proc APsolveMVA { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the definitions
 
   for { set I 0 } { $I < $nF } { incr I } {

      APkeepTabs "STEP $fD : MVA ($I)"

# GET the definition line
   
      set LiNe [$W get $I]

# BREAK it apart
 
      scan $LiNe "%s %s %s %s %s" _tO _tA _tB _vI _vO

# GET the input variable list and set up the variables

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]
      if { $nI >= 3 } {
         set vR [lindex $iNames 0]
         global [set vR] ; upvar 0 [set vR] _d0
         set vR [lindex $iNames 1]
         global [set vR] ; upvar 0 [set vR] _d1
         set vR [lindex $iNames 2]
         global [set vR] ; upvar 0 [set vR] _d2
      } else { puts stderr "MVA - input not a vector" ; exit }

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

# GET the elements in the input data grid which cover the time span
 
      switch -exact -- $_tO {
         FULL {
	    set _tA $apANS(begYr):$apANS(begDy)
	    append _tA :$apANS(begHr):$apANS(begMn):$apANS(begSc)
	    set _tA $apANS(endYr):$apANS(endDy)
	    append _tA :$apANS(endHr):$apANS(endMn):$apANS(endSc)
	 }
         PLOT {
	    set _tA $apANS(PbegYr):$apANS(PbegDy)
	    append _tA :$apANS(PbegHr):$apANS(PbegMn):$apANS(PbegSc)
	    set _tA $apANS(PendYr):$apANS(PendDy)
	    append _tA :$apANS(PendHr):$apANS(PendMn):$apANS(PendSc)
	 }
      }
 
      APtimeSpan _d0 bT eT DATA $_tA $_tB

# Compute the variances

      for { set J 0 } { $J <  9 } { incr J } { set Sum($J) 0.0 }

      set CnT 0
      for { set J $bT } { $J <  $eT } { incr J } {
         set Sum(0) [expr $Sum(0) + $_d0($J)] 
         set Sum(1) [expr $Sum(1) + $_d1($J)] 
         set Sum(2) [expr $Sum(2) + $_d2($J)] 
         set Sum(3) [expr $Sum(3) + $_d0($J) * $_d0($J)] 
         set Sum(4) [expr $Sum(4) + $_d0($J) * $_d1($J)] 
         set Sum(5) [expr $Sum(5) + $_d0($J) * $_d2($J)] 
         set Sum(6) [expr $Sum(6) + $_d1($J) * $_d1($J)] 
         set Sum(7) [expr $Sum(7) + $_d1($J) * $_d2($J)] 
         set Sum(8) [expr $Sum(8) + $_d2($J) * $_d2($J)] 
         incr CnT
      }

# BUILD the matrix used to compute the eighervalues and vectors
 
      set iM(0) [expr ($Sum(3) - $Sum(0) * $Sum(0)) / double($CnT)]
      set iM(1) [expr ($Sum(4) - $Sum(0) * $Sum(1)) / double($CnT)]
      set iM(2) [expr ($Sum(5) - $Sum(0) * $Sum(2)) / double($CnT)]
      set iM(3) $iM(1)
      set iM(4) [expr ($Sum(6) - $Sum(1) * $Sum(1)) / double($CnT)]
      set iM(5) [expr ($Sum(7) - $Sum(1) * $Sum(2)) / double($CnT)]
      set iM(6) $iM(2)
      set iM(7) $iM(5)
      set iM(8) [expr ($Sum(8) - $Sum(2) * $Sum(2)) / double($CnT)]

      set nR [TUmatrixEig iM 3 _eVal _eVec]

# ABS of eigenvalues
 
      set aeV ""
      for { set J 0 } { $J < 3 } { incr J } { 
         lappend aeV [expr abs($_eVal($J))]
      }

# SORT the eigenvalues
 
      set sEv [lsort -real -indices $aeV]

# DETERMINE confidence level
 
      set cL [expr [lindex $aeV [lindex $sEv 1]]/[lindex $aeV [lindex $sEv 0]]]

# FORM the rotation matrix
 
      set vR [lindex $oNames 0]
      global [set vR] ; upvar 0 [set vR] _rM

      set CnT 0
      for { set J 2 } { $J >= 0 } { incr J -1 } {
         set InDx [expr [lindex $sEv $J] * 3]
         for { set K 0 } { $K < 3 } { incr K ; incr InDx ; incr CnT } {
	    set _rM($CnT) $_eVec($InDx)
         }
      }
      set _rM(Dim) [ list 3 3]

for { set J 2 } { $J >= 0 } { incr J -1 } {
   puts stderr "$ J [lindex $sEv $J] [lindex $aeV [lindex $sEv $J]]"
}
puts stderr " ... $cL"

      set CnT 0
      if { $nO > 1 } {
         set vR [lindex $oNames 0]
         global [set vR] ; upvar 0 [set vR] _rO
         for { set J 2 } { $J >= 0 } { incr J -1 } {
            set _rO($CnT) [lindex $aeV [lindex $sEv $J]]
         }
         set _rO(CnT) $cL
         set _rO(Dim) [ list 4 1]
      }
   }
}
