# THIS routine transferrs multiple input variables and into a single output
#    variable.  The transfer is sequential by variable element. For 
#    example with the input variable Xa, Xb, and Xc, the  output varaible 
#    A would look like :
#
#      A = [Xa(0), Xb(0), Xc(0), Xa(1), Xb(1), Xc(1) ... Xa(N), Xb(N), Xc(N)]
 
package provide UDFAnalysisTh 1.0

proc APsdVar { vC vSk vNames vO {RelO NO} } {
   global apANS

   upvar $vO _Out

# PUSH the output variable and the input variable designations into tsv space
 
   tsv::set sdVar vO $vO
   tsv::set sdVar vNames $vNames
   tsv::set sdVar vSk $vSk

# CHECK what component of the variable is being processed.  S means scalar

   if ![string match S $vC] { 
      set nS 3 
      if [string match X $vC] { 
         set fV 0 
      } elseif [string match Y $vC] { set fV 1 } else { set fV 2 } 
   } else { set nS 1 ; set fV 0}

# THE total number of input variables

   set nV [llength $vNames]

# SET the number of elements in an array and determine how many blocks
#    this can be broken up into when looping to transfer the data.  Since
#    transferring is pretty fast we start with a block size of 5000.

   set bS 5000

   set vI [lindex $vNames $fV]
   global [set vI] ; upvar 0 [set vI] _TmPa
   set nE [lindex $_TmPa(Dim) 0]
   set nB [expr $nE / $bS]
   if { [expr $nE % $bS] > 0 } { incr nB }

# PUSH some ancillary data into tvs space
 
   tsv::set sdVar nE $nE
   tsv::set sdVar nB $nB
   tsv::set sdVar bS $bS
   tsv::set sdVar fV $fV
   tsv::set sdVar nS $nS

# SET up the thread variable PgmA. This contains a single procedure which
#   processes the data
 
   set PgmA { 
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD UTILS 

# DoData reads the varialbe data and packs it into the output variable
 
      proc DoData { rN } { 

# DETERMINE the souce number sN as well as the block number bN from the thread
#    run number rN
 
         set sN [expr $rN / [tsv::get sdVar nB]]
         set bN [expr $rN % [tsv::get sdVar nB]]

         set vOff [expr $sN * [tsv::get sdVar nS] + [tsv::get sdVar fV]]
	 set vI [lindex [tsv::get sdVar vNames] $vOff]
	 set vO [tsv::get sdVar vO]
	 set bS [tsv::get sdVar bS]

	 set bG [expr $bN * $bS]
         set eN [expr ($bN + 1) * $bS]
	 set nE [tsv::get sdVar nE]

	 if { $eN > $nE } { set eN $nE }
	 set K [expr $bN * $bS * [tsv::get sdVar vSk] + $sN]
         for { set J $bG } { $J < $eN } { incr J } {
            tsv::set $vO $K [tsv::get $vI $J]
            incr K [tsv::get sdVar vSk]
	 }
      }
   }

# PLACE all the input variables into the common thread pool area
 
   set nI 0
   for { set I $fV } { $I <$nV } { incr I $nS } {
      set vI [lindex $vNames $I]
      global [set vI] ; upvar 0 [set vI] _TmP
      tsv::array set $vI [array get _TmP]
      incr nI
   }

# PROCESS the variables for the specified component
 
   set tPoolID [THpoolOpen "$PgmA"]

   set jobS []

   set EnD [expr $nI * $nB]
   for { set I 0 } { $I < $EnD } { incr I } {
      lappend jobS [THschdTask $tPoolID [list DoData $I]]
   }

   THjobsDone $tPoolID $jobS
   THpoolClose $tPoolID

# ADD the ancillary data to the output variable

   tsv::set $vO Dim $_TmPa(Dim)
   if [info exists _TmPa(gInE)] { APxferGInfo _TmPa $vO DATA FORWARD $RelO } 
   THarrayXfer FROM _Out $vO

# FREE all the input tsv array varaibles used
 
   tsv::unset sdVar
   for { set I $fV } { $I <$nV } { incr I $nS } {
      set vI [lindex $vNames $I]
      tsv::unset $vI
   }

   if [string match NO $RelO] { tsv::unset $vO }
}
