#  THIS procedure opens and gets UDF data.
#
#  REMEMBER the following:
#
#  1.  Not all requested measurements may be returned.
#
#  2.  With the time_off variable each measurement, even within a sensor
#         set can have a unique start and stop time.
#
#  3.  Same goes for the phase angles.

package provide UDFAnalysis 1.0

proc APreadUDF { vD } {
   global apANS ExDa ExPhi0 SInfo

# THIS is the iD of the UDF source definition

   set iD UD$vD

# THROW up what's going on into the menu info bar

   APkeepTabs "READING UDF $apANS($iD,M) $apANS($iD,V)"

# GET the UDF Key for this data set

   set Key [GetDataKey $apANS($iD,P) $apANS($iD,M) \
                       $apANS($iD,E) $apANS($iD,I) $apANS($iD,V)]

# OPEN the data file

   FileOpen $Key 0 $apANS(begYr) $apANS(begDy) \
                   $apANS(begHr) $apANS(begMn) $apANS(begSc) \
                   $apANS(endYr) $apANS(endDy) \
		   $apANS(endHr) $apANS(endMn) $apANS(endSc)

# GET to the start time in the file

   FilePos  $Key 0 $apANS(begYr) $apANS(begDy) \
                   $apANS(begHr) $apANS(begMn) $apANS(begSc) FINE

# GET all the information needed to get the data. This includes the
#   the sensor numbers and the algorithms to convert both the sensor
#   and index data (if present) to units

   set InFo [APreadThis $vD $Key]

   set sNum  [lindex $InFo 0]
   set sAlg  [lindex $InFo 1]
   set aAlg  [lindex $InFo 2]

# THIS is the number of sensors.  Need to go forward on the last sensor
#   when reading in data.

   set nS [expr [llength $sNum] - 1]

# AT this point if we need to return any theta information we can do
#   that.  The theta comes from the VIDF and has no time dependence.
#   There are a pair of values per sensor.

   set eNames [lindex [APgetVNames $apANS($vD,thV)] 0]
   set nN [llength $eNames]
   if { $nN > 0 } {
      set GN $Key,0,GN
      set tSen $SInfo($GN,NSEN)

      set tLen [llength $SInfo($GN,THETA)]
      if { $tLen <= $tSen } { set tSen 0 }

      for { set _I 0 } { $_I < $nN } { incr _I } {
         set _J [expr $_I / 2]
         set _K [expr $_I % 2]
         set sN [lindex $sNum $_J]
         set VaR [lindex $eNames $_I]
	 if { $_K == 0 } {
            global [set VaR] ; upvar 0 [set VaR] tHb$_J
	    if { $tLen == 0 } { 
	       set V $apANS(BaD)
            } else { set V [lindex $SInfo($GN,THETA) $sN] }
	    set tHb${_J}(0) $V
	    set tHb${_J}(Dim) [list 1 1]
         } else { 
	    set esN [expr $sN + $tSen]
	    global [set VaR] ; upvar 0 [set VaR] tHe$_J 
	    if { $tLen == 0 } { 
	       set V $apANS(BaD)
            } else { set V [lindex $SInfo($GN,THETA) $esN] }
	    set tHe${_J}(0) $V
	    set tHe${_J}(Dim) [list 1 1]
	 }
      }
   }

#  SET up the sensor variable names 

   set vNames [lindex [APgetVNames $apANS($vD,Var)] 0]
   set nE [llength $vNames]
   for { set _I 0 } { $_I < $nE } { incr _I } {
      set vR($_I) [lindex $vNames $_I]
      global [set vR($_I)] ; upvar 0 [set vR($_I)] sV$_I
   }

#  SET up the index variable names.  Need to determine what sensor the
#    indices are coming from.

   set aNames [lindex [APgetVNames $apANS($vD,Ind)] 0] 
   set nI [llength $aNames]
   if { $nI > 0 } {

      set DoFill NO

      for { set _I 0 } { $_I < $nI } { incr _I } {
         set VaR [lindex $aNames $_I]
         global [set VaR] ; upvar 0 [set VaR] aV$_I
      }

      for { set _I 0; set _L 0 } { $_I < $nE } { incr _I } {
         set aU [lindex $aAlg $_I]
	 set aL [llength $aU]

	 for { set _J 0 } { $_J < $aL } { incr _J ; incr _L } {
	     set aID($_L) $_I
         }
      }
   } else { set DoFill $apANS($vD,gData) }

#  SET up the time variables 

   set tNames [lindex [APgetVNames $apANS($vD,tmV)] 0]
   set nT [llength $tNames]
   if { $nT > 0 } {
      for { set _I 0 } { $_I < $nT } { incr _I } {
         set _J [expr $_I / 2]
         set _K [expr $_I % 2]
         set VaR [lindex $tNames $_I]
	 if { $_K == 0 } {
            global [set VaR] ; upvar 0 [set VaR] tMb$_J
         } else { global [set VaR] ; upvar 0 [set VaR] tMe$_J }
      }
   } 
   set nT [expr 2 * [llength $sNum]]

#  SET up the phase variables 

   set pNames [lindex [APgetVNames $apANS($vD,phV)] 0]
   set nP [llength $pNames]
   if { $nP > 0 } {
      for { set _I 0 } { $_I < $nP } { incr _I } {
         set _J [expr $_I / 2]
         set _K [expr $_I % 2]
         set VaR [lindex $pNames $_I]
	 if { $_K == 0 } {
            global [set VaR] ; upvar 0 [set VaR] pHb$_J
         } else { global [set VaR] ; upvar 0 [set VaR] pHe$_J }
      }
   }

#  SET up the spin period variable.  There can only be one variable. 

   set sNames [lindex [APgetVNames $apANS($vD,spV)] 0]
   set nsP [llength $sNames]
   if { $nsP > 0 } {
      set VaR [lindex $sNames 0]
      global [set VaR] ; upvar 0 [set VaR] spVar
   }

# THS is the start time and the end time.  Data accumulation stops once we
#    hit the end time.

   set ubT [list $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   set Tdone [format "%4d%03d%08d" $apANS(endYr) $apANS(endDy) $apANS(endMs)]

# The data processing flag and the data counters.  There is one counter
#    for array data, one for sensor data, and one for phase data and one
#    for spin period data.
#
# Ns counts the number of sweeps in the array

   set GoOn 2

   for { set _I 0 } { $_I <= $nS } { incr _I } {
      set Na($_I) 0
      set Ns($_I) 0
      set Np($_I) 0
   }
   set spC 0

# READ in the data

   while { $GoOn > 0 } {

# ALWAYS start getting the sensors with forward off.

      set FwD 0

# LOOP over the sensors we are picking up

      for { set _I 0 ; set _L 0 ; set _N 0 } { $_I <= $nS } { incr _I } {

         if { $_I == $nS } { set FwD 1 }

         set rC [split [ReadUDF $Key 0 0 [lindex $sNum $_I] 0 $FwD 0] "|"]

# PROCESS the return code:
#    1 means everything fine (then get data )
#   -1 means hit EOF ( done getting data )
#    0 means requested sensor not found ( keep chugging )

         if { [lindex $rC 0] == -1 } { break }
         if { [lindex $rC 0] ==  0 } { continue }

#  Spin Period you only need to get once per set of sensors
 
         if { ($nsP > 0) && ($_I == 0) } {
	    set spVar($spC) $ExDa(0,SPIN)
	    incr spC
	 }

#  Measurement is available

	 set tS $ExDa(0,NSMP)
         ConvertToUnits $Key 0 0 [lindex $sAlg $_I] dV
	 set _M $Na($_I)
	 for { set _J 0 } { $_J < $tS } { incr _J ; incr _M } {
            set sV${_I}($_M) $dV($_J)
         }

         set aU [lindex $aAlg $_I]
	 set aL [llength $aU]
	 for { set _K 0 } { $_K < $aL } { incr _K ; incr _L } {
	    if { $nI > $_L } {
               ConvertToUnits $Key 0 0 [lindex $aU $_K] dV
	       set _M $Na($_I)
	       for { set _J 0 } { $_J < $tS } { incr _J ; incr _M } {
                  set aV${_L}($_M) $dV($_J)
               }
            }
         }

         incr Na($_I) $tS

	 set _M [expr $_I * 2]
	 if { $nT > $_M } {
            set Tb [list $ExDa(0,BYR) $ExDa(0,BDY) $ExDa(0,BMSEC) 0]
            set Te [list $ExDa(0,EYR) $ExDa(0,EDY) $ExDa(0,EMSEC) 0]
            set tMb${_I}($Ns($_I)) [TUtimeConv $ubT $Tb 0 apANS(tBase)]
            set tMe${_I}($Ns($_I)) [TUtimeConv $ubT $Te 0 apANS(tBase)]
	    incr Ns($_I)
         }

         if { $nP > $_N } {
	    set _J 0
	    set EnD $tS
            for { set _P 0 } { $_P < 2 } { incr _P ; incr _N ; incr EnD $tS } { 
               if { $nP > $_N } {
	          set _M $Np($_I)
	          if { [expr $_P % 2] == 0 } {
                     for {  } { $_J < $EnD } { incr _J ; incr _M } {
                        set pHb${_I}($_M) $ExPhi0($_J)
                     }
                  } else {
                     for {  } { $_J < $EnD } { incr _J ; incr _M } {
                        set pHe${_I}($_M) $ExPhi0($_J)
                     }
	          }
	       }
            }
	    incr Np($_I) $tS
         }
      }

      set Ts [format "%4d%03d%08d" $ExDa(0,BYR) $ExDa(0,BDY) $ExDa(0,BMSEC)]
      set Te [format "%4d%03d%08d" $ExDa(0,EYR) $ExDa(0,EDY) $ExDa(0,EMSEC)]
      set tList [lsort -ascii -increasing [list $Ts $Tdone $Te]]
      set GoOn [lsearch $tList $Tdone]
   }

# GET the variables and grid the data if we need to

   if [string match YES $DoFill] {
      
      set nE [llength $vNames]
      for { set _I 0 } { $_I < $nE } { incr _I } {
         APkeepTabs "CREATING $vR($_I)"

# GRID THE DATA

         APgridData $vD $Ns($_I) tMb$_I tMe$_I Y Y sV$_I gR NorM

# TRANSFER the grid to the data variable

	 set gDim $gR(gI4)
         for { set _J 0 } { $_J < $gDim } { incr _J } { 
	    set sV${_I}($_J) $gR($_J) 
	 }
         set sV${_I}(Dim) [list $gDim 1]

# UNSET any unused data variable elements

         for { set _J $gDim } { $_J < $Ns($_I) } { incr _J } { 
	    unset sV${_I}($_J) 
	 }

# TRANSFER the grid information to the data variable

         APxferGInfo gR sV$_I
      }

      if { $nsP > 0 } {
         APkeepTabs "CREATING SPIN PERIOD"

         APgridData $vD $spC tMb0 tMe0 Y Y spVar gR NorM

	 set gDim $gR(gI4)
         set spVar(Dim) [list $gDim 1]

         for { set _J 0 } { $_J < $gDim } { incr _J } { 
	    set spVar($_J) $gR($_J) 
	 }
         for { set _J $gDim } { $_J < $spC } { incr _J } { unset spVar($_J) }

         APxferGInfo gR spVar
      }
   } else {

      set nE [llength $vNames]
      for {set _I 0} {$_I < $nE} {incr _I} { 
         set sV${_I}(Dim) [list $Ns($_I) $tS] 
      }

      set nE [llength $aNames]
      for {set _I 0} {$_I < $nE} {incr _I} { 
          set aV${_I}(Dim) [list $Ns($aID($_I)) $tS] 
      }

      set nE [llength $tNames]
      for { set _I 0 } { $_I < $nE } { incr _I } { 
         set _J [expr $_I / 2]
         set _K [expr $_I % 2]
	 if { $_K == 0 } {
           set tMb${_J}(Dim) [list $Ns($_J) 1] 
         } else { set tMe${_J}(Dim) [list $Ns($_J) 1] }
      }

      set nE [llength $pNames]
      for { set _I 0 } { $_I < $nE } { incr _I } { 
         set _J [expr $_I / 2]
         set _K [expr $_I % 2]
	 if { $_K == 0 } {
           set pHb${_J}(Dim) [list $Ns($_J) $tS]
         } else { set pHe${_J}(Dim) [list $Ns($_J) $tS] }
      }

      if { [llength $sNames] > 0 } { set spVar(Dim) [list $spC 1] }
   }
}
