#  THIS procedure determines what needs to be returned from a UDF source.
#     This consists of determining:
#     1. what sensors to get, 
#     2. the algorithm used get each sensor into proper units
#     3. what if any array indices to return
#     4. what if any phase information to return
#     5. what if any elevation information to return

  package provide UDFAnalysis 1.0

proc APreadThis { vD Key } {
   global apANS ExDa

# THIS is the iD of the UDF source definition

   set iD UD$vD

# Initialize the variables that will be filled.  Text information for the
#   measurements are global since they may be used much later during
#   annotation.  Local variables will be returned as a list if lists.

   set sNum  ""
   set sAlg  ""
   set aAlg  ""
   set apANS($vD,uName)  ""
   set apANS($vD,sName)  ""
   set apANS($vD,aName)  ""

# THIS is the number of measurement requests made - of course just to
#   make it harder each measurement request can contain multiple measurements.

   set nS [llength $apANS($iD,SenL)]

# GET the number of array index variables defined. Applying the variables
#   to the sensor definitions is a bit tricky.  Each set of sensor 
#   definitions has a maximum of 2 index unit definitions.  We can have:
#
#   1.  Variables for each unit definition in each set of sensor
#       definitions
#   2.  Varaible definitions for just the unit definitions in the
#       first sensor set.

    set nIV [llength [lindex [APgetVNames $apANS($vD,Ind)] 0]]

# LOOP over the requests

   for { set I 0 } { $I < $nS } { incr I } {

# SKIP this definition if there have been no measurements defined

      if ![lindex $apANS($iD,SenL) $I] { continue }

# THIS is the measurement ID

      set sID $iD.s$I

# THE list of the sensors VIDF and PIDF numbers

      set sI [UUgetSensors $Key $apANS($sID,scr) $apANS($sID,srcA) \
                                $apANS($sID,meaA) $apANS($sID,munA) ]

# THE list of sensor numbers as given in the VIDF

      set svN [lindex $sI 0]

# THE list of their full sensor names from the PIDF

      set sN [UUgetSNames $Key [lindex $sI 1] FULL]

# THE full units name (all sensors have the same units in a given request)

      set uN [UUgetUNames $Key  $apANS($sID,munA) LONG]

# THE algorithm used to get the sensor into the correct units.  Again all 
#   sensors in a given request use the same conversion algorithms.

      set uA [UUunitAlg $Key,0 $apANS($sID,munA) $apANS($sID,meaA)]

# APPEND all of this information into a set of lists which will be used when
#    the information is being retrieved. 

      set sLen [llength $svN]
      for { set J 0 } { $J < $sLen } { incr J } {
         lappend sNum [lindex $svN $J]
	 lappend sAlg $uA
	 lappend apANS($vD,uName) $uN
	 lappend apANS($vD,sName) [lindex $sN $J]
   
# Check for array definitions

         if { ($J == 0) && ( $nIV > 0 ) } {
	    set CnT 0
            if { [string length $apANS($sID,iunA)] > 0 } {
	       set aN1 [UUgetUNames $Key $apANS($sID,iunA) LONG]
	       set aU1 [UUunitAlg $Key,0 $apANS($sID,iunA) $apANS($sID,meaA)]
	       incr nIV -1
	       incr CnT
            }
            if { ([string length $apANS($sID,iun2A)] > 0) && ($nIV > 0) } {
	       set aN2 [UUgetUNames $Key $apANS($sID,iun2A) LONG]
	       set aU2 [UUunitAlg $Key,0 $apANS($sID,iun2A) $apANS($sID,meaA)]
	       incr nIV -1
	       incr CnT
            }
	    if { $CnT == 0 } {
                lappend aAlg ""
	    } elseif { $CnT == 1 } {
               lappend apANS($vD,aName) $aN1
               lappend aAlg [list $aU1]
	    } else {
               lappend apANS($vD,aName) $aN1
               lappend apANS($vD,aName) $aN2
               lappend aAlg [list "$aU1" "$aU2"]
	    }
         } else { lappend aAlg "" }
      } 
   }

   return [list $sNum $sAlg $aAlg]
}
