package provide UDFAnalysis 1.0

proc APreadPrefs { } {
   global apANS env

   set pD [file join $env(HOME) .udf]
   if ![file exists $pD] { file mkdir $pD }

   set nV [APvarList PREFS vL]
   set pD [file join $pD udfPrefs]
   if ![file exists $pD] { 
      for { set I 0 } { $I < $nV } { incr I } {
         set vI [lindex $vL $I]
         set vN [lindex $vI 0]
         set apANS(P,$vN) [lindex $vI 1] 
      }
      return
   }

   if [catch {open $pD r} fd] {
      puts stderr "Cannot open $pD"
      return
   } 

#  READ in the saved values.  Blocks or saved replies in the menu are
#     separated by BEGIN and END.  These can be ignored.

   while { [gets $fd line] > 0 } {
      set Fields [split $line '|']
      set I [lindex $Fields 0]
      set apANS($I) [lindex $Fields 1]
   }

   close $fd

   for { set I 0 } { $I < $nV } { incr I } {
      set vI [lindex $vL $I]
      set vN [lindex $vI 0]
      if ![info exists apANS(P,$vN)] { set apANS(P,$vN) $apANS(P,$vN) }
   }
}
