package provide UDFAnalysis 1.0

proc APplots3DXY { pD Var pFmt } {
   global apANS GphInfo PltInfo

   upvar $Var vN

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set aX $apANS($pD,xActive) 
   set aY $apANS($pD,yActive)

# CHECK the X variable to see if its plottable.  If not then try and build
#   the plot variables from it. _D is a array.  Since we know the plot 
#   being produced is 3D no info will be returned in that variable.

   set vI [APbuildVar $pD $vN(0) _X _Y _Z _V]

   set nX [lindex $vI 0]
   set nY [lindex $vI 1]

# IF this is not plotting a Fit then set up all the plot variables that are
#   defined.
 
   if { $nX == 0 } {
      set Fit 0

# SEE what variables are defined for this plot.
 
      set nxV [llength $vN(0)]
      set nyV [llength $vN(1)]
      set nzV [llength $vN(2)]
      set nvV [llength $vN(3)]

# Define the Z and V variables if they exist

      if { $nzV > 0 } {
         set vZ [lindex $vN(2) 0] 
         global [set vZ] ; upvar 0 [set vZ] _Z
         set nZ [lindex $_Z(Dim) 0]
      } else { set nZ 0 }

      if { $nvV > 0 } {
         set vV [lindex $vN(3) 0] 
         global [set vV] ; upvar 0 [set vV] _V
         set nV [expr [lindex $_V(Dim) 0] * [lindex $_V(Dim) 0]]
      } else { set nV 0 }

# A pre-gridded plot will have  no X and no Y variable defined.

      if { ($nxV == 0) && ($nyV == 0) } {

# GET the intensity grid information

         APxferGInfo _V _gI DATA REVERSE
         if ![info exists _gI(4)] { puts stderr "$vV not gridded!" ; exit }
      
# SET up the X and Y edges for FLAT plots and centers for ELEVATED plots
      
         if [string match FLAT $apANS(tDFmt)] {
            TUgridInfo 30 _gI _X
            TUgridInfo 31 _gI _Y
         } else {
            TUgridInfo 32 _gI _X
            TUgridInfo 33 _gI _Y
         }
	 set nX [expr $_gI(4) + 1]
	 set nY [expr $_gI(5) + 1]
      } else {
         set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _X
         set nX [lindex $_X(Dim) 0]
         set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Y
         set nY [lindex $_Y(Dim) 0]
      }

   } else { set Fit 1 }
   
   if { $nX < 0 } { return }

# SET omission conditions.  These essentially nuke data which is <= 0
#   on log based axes and will remove any undefined data within the
#   varaible grid.

   set xC < ; set yC < ; set zC < ; set cC <
   set xV $apANS(BaDL) ; set yV $xV ; set zV $xV ; set cV $xV

   if [string match Xb $aX] {
      if [string match LOG $apANS($pS,xbSca)] { set xC <= ; set xV 0. }
   } else { if [string match LOG $apANS($pS,xtSca)] { set xC <= ; set xV 0. } }

   if [string match Yl $aY] {
      if [string match LOG $apANS($pS,ylSca)] { set yC <= ; set yV 0. }
   } else { if [string match LOG $apANS($pS,yrSca)] { set yC <= ; set yV 0. } }

   if [string match LOG $apANS($pS,zaSca)] { set zC <= ; set zV 0. }

   if [string match LOG $apANS($pS,cbSca)] { set cC <= ; set cV 0. }

# GET the plot window and make it the current window

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# SET the plot line color, width and style keeping the old ones so that we
#   can reset to those values at the end

   set oW $GphInfo(lWidth)
   set lC $GphInfo(lColor)
   set tC $GphInfo(tColor)
   set oS $GphInfo(lStyle)
   set GphInfo(lWidth) $apANS($pD,lWidth)
   set GphInfo(lStyle) $apANS($pD,lStyle)
   set GphInfo(lColor) $apANS($pD,lColor)
   set GphInfo(tColor) $apANS($pD,sColor)

#  THE locations of the first and last plotted data point in the variable

   set BeG 0
   set EnD [expr $nX - 1]

# SINCE these plots require color information get it here

   set cMin [lindex $apANS($pN.cB) 0]
   set cMax [lindex $apANS($pN.cB) 1]
   PLTcolorMap $cMin $cMax $apANS($pS,cbSca) NO cM

# NOW plot the data based on the type of plot requested

   switch -exact -- $apANS($pD,pType) {
      LINE {
         set pOp [list 3D $lC ] 
         set eOp [list $xC $xV $yC $yV $zC $zV]
         PLTlinePlot $wN $aX $aY _X _Y _Z Dum $BeG $EnD $pOp $eOp
      }
      POINT {
         set SyM [APucodeParse $apANS($pD,Sym)]
         set pOp [list $pFmt $sC $apANS($pD,sFont) $apANS($pD,sSize) $SyM] 
         switch -exact -- $pFmt {
            2DC {
               set eOp [list $xC $xV $yC $yV $cC $cV]
               PLTscatterPlot $wN $aX $aY _X _Y _Z _V $BeG $EnD $pOp cM $eOp
            }
            3D {
               set eOp [list $xC $xV $yC $yV $zC $zV]
               PLTscatterPlot $wN $aX $aY _X _Y _Z _V $BeG $EnD $pOp cM $eOp
            }
            3DC {
               set eOp [list $xC $xV $yC $yV $zC $zV $cC $cV]
               PLTscatterPlot $wN $aX $aY _X _Y _Z _V $BeG $EnD $pOp cM $eOp
            }
         }
      }
      SOLID {
         switch -exact -- $pFmt {
	    2DC {
               set _gI(PF) $apANS(tDFmt)
               if [string match FLAT $apANS(tDFmt)] {
                  PLTflatPlot $wN $aX $aY _X _Y _V MANUAL _gI cM 
               } else { PLTvtk3DGrid $pN _X _Y _V _gI cM } 

               unset _gI
               unset _X
               unset _Y
            }
         }
      }
      CONTOUR {
	 set cInfo(CFMT) $apANS($pD,cFmt)
	 set cInfo(NLEV) $apANS($pD,cNum)
	 set cInfo(CLAB) UNLABELED
	 set cInfo(CLEV) AUTO
         set cInfo(LMIN) [lindex $apANS($pN.cB) 0]
         set cInfo(LMAX) [lindex $apANS($pN.cB) 1]
	 set cInfo(LSCA) $apANS($pS,cbSca)
	 set cInfo(CCOL) $apANS($pD,lColor)
	 set cInfo(DFMT) RECTANGULAR

         PLTgridContour $wN _V _gI cM cInfo
      }
   }

# RESET possibly changed setting

   set GphInfo(lWidth) $oW
   set GphInfo(lColor) $lC
   set GphInfo(tColor) $tC
   set GphInfo(lStyle) $oS

   update
}
