package provide UDFAnalysis 1.0

proc APplots2DTime { pD Var } {
   global apANS GphInfo PltInfo

   upvar $Var vN

# SET the plot number and the index into the plot definitions where the plot
#   information is contained.

   set P $apANS($pD,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

# SET the plot axes  

   set aX $apANS($pD,xActive) 
   set aY $apANS($pD,yActive)

# Get the Y variable and its size

   set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _tV
   set nY [lindex $_tV(Dim) 0]

# CHECK that we don't have an X or time variable.  If not we will need to get
#    that info from the time grid definition that this data was stored under. 
#    Also get the size of the X variable

   set nVx [llength $vN(0)]
   if { $nVx > 0 } {
      set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _tA
      set nX [lindex $_tA(Dim) 0]
      if { $nVx > 1 } {
         set vX [lindex $vN(0) 1] ; global [set vX] ; upvar 0 [set vX] _tB
      } else {
         set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _tB
      }
   } else { 
      APxferGInfo _tV gI DATA REVERSE
      set nX $gI(4)
   }

# HERE you can fill missing slots in the time grid if requested.

   if [string match YES $apANS($pD,GFill)] { TUgridFill1D _tV gI X LI -1 1 }

# THE program wide time grid need not have the same resolution as the plot
#   itself which has a native time resolution based on the number of pixels 
#   it contains. If requested the data being plotted can be put into a time
#   grid with the same resolution as the plot.  (This averages the data in
#   time or may even expand it!) Do that now.

   if [string match YES $apANS($pD,GtoP)] {

# DEFINE a grid which just covers the plot

      set gB BAND
      set gC [list 4 $apANS($pS,dX) 6 BAND]
      APmakeGrid gIP $gB $gC SYSTEM PLOT

# Form the begin and ending time for each of the data points from the
#   system wide grid if no time variable was present

      if { $nVx <= 0 } {
         TUgridInfo 30 gI _xX

         for { set _I 0 ; set _J 1 } { $_I < $gI(4) } { incr _I ; incr _J } {
            set _tA($_I) $_xX($_I)
            set _tB($_I) $_xX($_J)
         }
      }

# NOW grid the data - we got the variable above so no need to get it here

      set xHold [expr int($nY / $nX)]
      set nY [lindex $_tV(Dim) 0]

      set _tY(0) 0.0

      TUdataGrid $nY $xHold _tA _tB $nY _tY _tY _tV _Y _NorM gIP

# COMPUTE X for the plot 

      TUgridInfo 30 gIP _X
      set EnD [expr $gIP(4) - 1]
   } else {

# NO regridding of the data.  Get the Y variable

      set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Y
      set nY [lindex $_Y(Dim) 0]

# CREATE the X variable

      if { $nVx <= 0 } {
         TUgridInfo 30 gI _X
         set EnD [expr $gI(4) - 1]
      } else {
         set EnD [expr $nY - 1]
         set xHold [expr int($nY / $nX)]
	 if { $xHold == 1 } {
            set vX [lindex $vN(0) 0] ; global [set vX] ; upvar 0 [set vX] _X
         } else {
            for { set _I 0 } { $_I < $nY } { incr _I } {
	       set J [expr int($_I / $xHold)]
	       set _X($_I) $_tA($J) 
            }
	 }

# IF X is undersampled then we need to "fill in the blanks"

      }
   }

# SET omission conditions.  These essentially nuke data which is <= 0
#   on log based axes and will remove any undefined data within the
#   varaible grid.

   set xC < ; set yC < ; set zC <
   set xV $apANS(BaDL) ; set yV $apANS(BaDL) ; set zZ $apANS(BaDL)

   if [string match Xb $aX] {
      if [string match LOG $apANS($pS,xbSca)] { set xC <= ; set xV 0. }
   } else { if [string match LOG $apANS($pS,xtSca)] { set xC <= ; set xV 0. } }

   if [string match Yl $aY] {
      if [string match LOG $apANS($pS,ylSca)] { set yC <= ; set yV 0. }
   } else { if [string match LOG $apANS($pS,yrSca)] { set yC <= ; set yV 0. } }

  if [string match LOG $apANS($pS,zaSca)] { set zC <= ; set zV 0. }

# GET the plot window and make it the current window

   set wN $PltInfo($pN,wN)
   set GphInfo(curWin) $wN

# SET the plot line color, width and style keeping the old ones so that we
#   can reset to those values at the end

   if [info exists GphInfo($apANS($pD,lColor))] {
      set lC $GphInfo($apANS($pD,lColor))
   } else { set lC $apANS($pD,lColor) }

   if [info exists GphInfo($apANS($pD,sColor))] {
      set sC $GphInfo($apANS($pD,sColor))
   } else { set sC $apANS($pD,sColor) }

   set oW $GphInfo(lWidth)
   set oS $GphInfo(lStyle)
   set GphInfo(lWidth) $apANS($pD,lWidth)
   set GphInfo(lStyle) $apANS($pD,lStyle)

#  THIS is the location of the first plotted data point in the varaible

   set BeG 0

# NOW plot the data based on the type of plot requested

   switch -exact -- $apANS($pD,pType) {
      LINE {
         set pOp [list 2D $lC ]
         set eOp [list < $apANS(BaDL) $yC $yV]
         PLTlinePlot $wN $aX $aY _X _Y Dum Dum $BeG $EnD $pOp $eOp
      }
      POINT {
         set SyM [APucodeParse $apANS($pD,Sym)]
         set pOp [list 2D $sC $apANS($pD,sFont) $apANS($pD,sSize) $SyM] 
         set eOp [list < $apANS(BaDL) $yC $yV]
         PLTscatterPlot $wN $aX $aY _X _Y Dum Dum $BeG $EnD $pOp "" $eOp
      }
      BARS {
         set pOp [list 2D $lC ]
         set eOp [list < $apANS(BaDL) $yC $yV]
         PLThistogramPlot $wN $aX $aY _X _Y Dum $BeG $EnD $pOp $eOp
      }
      CERROR {
         set pOp [list CROSS $lC ]
         set eOp [list < $apANS(BaDL) $yC $yV]

         if { [llength $vN(1)] > 1 } {
            set vY [lindex $vN(1) 1] ; global [set vY] ; upvar 0 [set vY] _Ye
	 } else {
	    set vY [lindex $vN(1) 0] ; global [set vY] ; upvar 0 [set vY] _Ye
	 }

	 PLTerrorPlot $wN $aX $aY _X _X _Y _Ye "" $BeG $EnD $pOp $eOp
      }
   }

# RESET possibly changed setting

   set GphInfo(lWidth) $oW
   set GphInfo(lStyle) $oS

   update
}
