package provide UDFAnalysis 1.0

proc APplotSetup { } {
   global apANS GphInfo PltInfo WinInfo DevInfo

# ANNOUNCE what's happening in the Main Menu Blogging area

   APkeepTabs "SETTING UP PLOTS"

# SET up what needs to be done prior to getting the plot layout
#   established here

   APprePlot

# GET the number of defined plot cells

   if ![winfo exists .apLAYOUT] { APlayoutGUI 1 }
   set Wlay .apLAYOUT.body.list
   set nP [$Wlay index end]

# THIS is the start and stop times for time based plots

   set BTd [TUtimeFmt 1 $apANS(begYr) $apANS(begDy) $apANS(begMs) 0]
   set BTp [TUtimeFmt 1 $apANS(PbegYr) $apANS(PbegDy) $apANS(PbegMs) 0]
   set ETp [TUtimeFmt 1 $apANS(PendYr) $apANS(PendDy) $apANS(PendMs) 0]

# THIS is the screen area we get to work within

   set  GphInfo(xScrL) $apANS(xPix)
   set  GphInfo(yScrL) $apANS(yPix)

# FIRE up the graphics and set the window background color

   GraphicsOn $apANS(gdev) $apANS(ctbl) SWAP
   BackGround $apANS(pBkg) 1

# SET bindings for label moving but only for TK plots
    
   if [string match TK $apANS(gdev)] {
      set sC Scr$GphInfo(CurScr)
      set sCr $DevInfo($sC).drw
      bind $sCr <Button-1> {APlabelMark %W %x %y}
      bind $sCr <Button-3> {APlabelMove %W %x %y}
   }

# SET the current line color to white

   PlotColor HOLD #ffffff OFF

# OPEN a window in the current plotting window to cover the entire area.
#   Scaling in X and Y is the number of pixels in each direction

   GenWindow A 0.0 0.0 0.0 1.0 1.0 0.0 0. 0. 0. 1. 1. 0. XY
   set X [expr $WinInfo(A,p3) + 1]
   set Y [expr $WinInfo(A,p4) + 1]

# NUMBER of rows and columns in plot grid

   set nR $apANS(maxRow)
   set nC $apANS(maxCol)

# GET some basic text lengths of 10 and 12pt characters.  The current
#   text size is left at 10 pt.

   TextProp 12
   set apANS(xC12) [GPHtextLen 2 X]
   set apANS(yC12) [GPHtextLen 2 Y]

   TextProp 8
   set lT8 [GPHtextLen -2.20e+00__ X]

   TextProp 10
   set lT10 [GPHtextLen -2.20e+00__ X]
   set apANS(xC10) [GPHtextLen 2 X]
   set apANS(yC10) [GPHtextLen 2 Y]

   set apANS(cBWidth) [expr $lT8 + 3.0 * $apANS(xC10)]
   set apANS(cBHght)  [expr 7.0 * $apANS(xC10)]

# THE size of the useable area of the plot window is determined by the number
#   of pixels it contains inside the user defined offsets from the edges. So
#   get the  X and Y offsets from the top and left sides of the window.
#   The offsets are in terms of 12pt characters

   set xBase [expr $apANS(yLGap) * $apANS(yC12)]  
   set yBase [expr $Y - $apANS(xTGap) * $apANS(yC12)]  

# THE number of pixels in each direction available for use is then given
#   given by:

   set dX [expr $X - $apANS(yRGap) * $apANS(yC12) - $xBase]
   set dY [expr $yBase - $apANS(xBGap) * $apANS(yC12)]

# CONCEPTUALLY the plot window is an nC x nR grid with all of grid cells
#   having the same pixel dimensions.  Each plot occupies one grid cell.
#   The actual area occupied by the plot may be enlarged by letting it
#   span either rows or columns in the grid. First step is to compute the
#   pixel lengths of a grid cell.

   set sX [expr $dX / $nC]
   set sY [expr $dY / $nR]

# AT this point we go through bazillions of tests to determine the
#    locations of the individual plots within the plot window.  First we
#    will loop through the plots to establish their overall position in the
#    plot window.  NOTE: Column 0, Row 0 is the upper lefthand corner in the
#    plot grid.

   for { set I 0 } { $I < $nP } { incr I } {

# THIS is the slot number of the plot definition 

      scan [$Wlay get $I] "%d" sN

# GET the cell column and row numbers in which the plot ends.  If the plot
#   doesn't span rows or columns these will be the same in which the plot
#   is placed.

      set lCol [expr $apANS($sN,Col) + $apANS($sN,cSpan) - 1]
      set lRow [expr $apANS($sN,Row) + $apANS($sN,rSpan) - 1]

# FORM the cell locations of this plot layout block which can occupy more 
#   than one cell due to column and row spanning.
#
#   Pul: The base plot cell which is the upper left corner of the plot block
#   Pur: The upper right corner of the plot block
#   Pll: The lower left corner of the plot block
#   Plr: The lower right corner of the plot block

      set Pul $apANS($sN,Col).$apANS($sN,Row)
      set Pur $lCol.$apANS($sN,Row)
      set Pll $apANS($sN,Col).$lRow
      set Plr $lCol.$lRow

# FOR the upper lefthand cell which is the base cell for this layout get:
#
#    bX : The starting row of the layout block this layout is in
#    bY : The starting column of the layout block this layout is in
#    gX : The total number of labeled Y axes in the layout block
#    gY : The total number of labeled X axes in the layout block
#    tX : The number of anotated Y axes left of this cell in the layout block 
#    tY : The number of anotated X axes above of this cell in the layout block 
#    nX : The total number of rows spanned by this layout block
#    nY : The total number of columns spanned by this layout block

      set bX  [expr double([lindex $apANS($Pul.rBlk) 0])]
      set gY  [expr double([lindex $apANS($Pul.rBlk) 1])]
      set tY  [expr double([lindex $apANS($Pul.rBlk) 2])]
      set nX  [expr double([lindex $apANS($Pul.rBlk) 3])]
      set cbY [expr double([lindex $apANS($Pul.rBlk) 4])]
      set tcY [expr double([lindex $apANS($Pul.rBlk) 5])]

      set bY  [expr double([lindex $apANS($Pul.cBlk) 0])]
      set gX  [expr double([lindex $apANS($Pul.cBlk) 1])]
      set tX  [expr double([lindex $apANS($Pul.cBlk) 2])]
      set nY  [expr double([lindex $apANS($Pul.cBlk) 3])]
      set cbX [expr double([lindex $apANS($Pul.cBlk) 4])]
      set tcX [expr double([lindex $apANS($Pul.cBlk) 5])]

# cX is the amount of space to add for a labeled X axis 

      set cX [expr 3.0 * $apANS(yC10)]

# X and Y is the pixel width and height of each plot. Each plot in a
#   a plot block shares the same size.  Space which must be reserved
#   for numerical annotation is shared by all plots in the same block.

      set X [expr ($sX * $nX - $gY * $lT10 - $cbY * $apANS(cBWidth)) / $nX]
      set Y [expr ($sY * $nY - $gX * $cX - $cbX * $apANS(cBHght)) / $nY]

# NOW compute the location of the upper left and right hand X positions
#   of the area occupied by this layout definition. 
# 
#   xBase is the offset in X to the start of the plot window.
#   bX * sX is the offset to the start of the layout block
#   dB * X is the offset from the start of the layout block to this layout
#   tY * cY is the offset due to labels to the left of this plot.
#
#   The ending position is just the starting position plus the length
#   of the layout (X * cSpan) plus space for any labels associated with the
#   Y axes of this layout.

      set spTxT [expr ([lindex $apANS($Pul.aLab) 2] + $tY) * $lT10]
      set spPlt [expr $X * ( $apANS($sN,Col) - $bX )]
      set apANS($Pul,xpL) [expr $xBase + $bX * $sX + $spTxT + $spPlt]
      set spPlt [expr $X * $apANS($sN,cSpan)] 
      set apANS($Pul,xpR) [expr $apANS($Pul,xpL) + $spPlt]

# DO the same computations but for the upper left and lower right hand Y
#   positions.

      set spTxT [expr ([lindex $apANS($Pul.aLab) 1] + $tX) * $cX]
      set spPlt [expr $Y * ( $apANS($sN,Row) - $bY )]
      set apANS($Pul,ypT) [expr $yBase - $bY * $sY - $spTxT - $spPlt]
      set spPlt [expr $Y * $apANS($sN,rSpan)] 
      set apANS($Pul,ypB) [expr $apANS($Pul,ypT) - $spPlt]

# LAYOUT block bounding box

      set apANS($Pul,xL) [expr $xBase + $bX * $sX]
      set apANS($Pul,xR) [expr $apANS($Pul,xL) + $sX * $nX] 
      set apANS($Pul,yT) [expr $yBase - $bY * $sY]
      set apANS($Pul,yB) [expr $apANS($Pul,yT) - $sY * $nY] 

# INITIALIZE all gaps for this layout to 0.0

      set pI($Pul,xgL) 0.0 ; set pI($Pul,xgR) 0.0
      set pI($Pul,ygB) 0.0 ; set pI($Pul,ygT) 0.0
   }

#  NOW get the room needed along all sides of each plot for labels. 

   for { set I 0 } { $I < $nP } { incr I } {

# THIS is the layout slot number

      scan [$Wlay get $I] "%d" sN

# AND the base cell ID of the layout definition

      set P $apANS($sN,Col).$apANS($sN,Row)

# Compute the gap needed for each annotated axis

      if [string match YES $apANS($sN,xtAno)] { set pI($P,ygT) $cX } 
      if [string match YES $apANS($sN,xbAno)] { set pI($P,ygB) $cX }
      if [string match YES $apANS($sN,ylAno)] { set pI($P,xgL) $lT10 } 
      if [string match YES $apANS($sN,yrAno)] { set pI($P,xgR) $lT10 }
   }

# Take into account any user requested spacing between the plots

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wlay get $I] "%d" sN
      set P $apANS($sN,Col).$apANS($sN,Row)
      set GaP [expr $apANS($sN,xbGap) * $apANS(yC10)]
      set apANS($P,ypB) [expr $apANS($P,ypB) + $GaP]
      set GaP [expr $apANS($sN,xtGap) * $apANS(yC10)]
      set apANS($P,ypT) [expr $apANS($P,ypT) - $GaP]
      set GaP [expr $apANS($sN,ylGap) * $apANS(yC10)]
      set apANS($P,xpL) [expr $apANS($P,xpL) + $GaP]
      set GaP [expr $apANS($sN,yrGap) * $apANS(yC10)]
      set apANS($P,xpR) [expr $apANS($P,xpR) - $GaP]
   }

# FINALLY save the number of pixels across each defined layout.

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wlay get $I] "%d" sN
      set P $apANS($sN,Col).$apANS($sN,Row)
      set apANS($sN,dX) [expr int($apANS($P,xpR) - $apANS($P,xpL) + 1)] 
   }

# DEFINE the plot windows.  Windows are defined according to the default 
#   scaling used to set up the plot axes.  That occupies most of this
#   bit of code

   for { set I 0 } { $I < $nP } { incr I } {
      scan [$Wlay get $I] "%d" sN
      set P $apANS($sN,piD)
      if [string match _DP_ $P] { continue }

      set P $apANS($sN,Col).$apANS($sN,Row)
      set WinInfo($P,corFmt) 1

      set xpA 1.0 ; set xpB 10.0 ; set xsA 1.0 ; set xsB 10.0 
      set xpS $apANS($sN,xbSca) ; set xsS $apANS($sN,xtSca)

      if { $apANS($sN,xbMin) != $apANS($sN,xbMax) } {
         set xpA $apANS($sN,xbMin) 
         set xpB $apANS($sN,xbMax)
      }
      if { $apANS($sN,xtMin) != $apANS($sN,xtMax) } {
         set xsA $apANS($sN,xtMin) 
         set xsB $apANS($sN,xtMax)
      } 
      if { $apANS($sN,xbMin) == $apANS($sN,xbMax) } {
         set xpA $xsA ; set xpB $xsB
      }
      if { $apANS($sN,xtMin) == $apANS($sN,xtMax) } {
         set xsA $xpA ; set xsB $xpB
      }

      set ypA 1.0 ; set ypB 10.0 ; set ysA 1.0 ; set ysB 10.0 
      set ypS $apANS($sN,ylSca) ; set ysS $apANS($sN,yrSca)

      if { $apANS($sN,ylMin) != $apANS($sN,ylMax) } {
         set ypA $apANS($sN,ylMin) 
         set ypB $apANS($sN,ylMax)
      }
      if { $apANS($sN,yrMin) != $apANS($sN,yrMax) } {
         set ysA $apANS($sN,yrMin) 
         set ysB $apANS($sN,yrMax)
      } 
      if { $apANS($sN,ylMin) == $apANS($sN,ylMax) } {
         set ypA $ysA ; set ypB $ysB
      }
      if { $apANS($sN,yrMin) == $apANS($sN,yrMax) } {
         set ysA $ypA ; set ysB $ypB
      }

      set zS $apANS($sN,zaSca)
      if $apANS($P.3D) { 
         if { $apANS($sN,zaMin) != $apANS($sN,zaMax) } {
            set zA $apANS($sN,zaMin) 
            set zB $apANS($sN,zaMax)
         } else { set zA 1.0 ; set zB 10.0 }
         PLTinfoChg $P ALL AXIS FORMAT BOX3D
      } else { set zA 0.0 ; set zB 0.0 }

      if [string match YES $apANS($sN,tBased)] { set PiX X } else { set PiX N }

      RelWindow $P A $apANS($P,xpL) $apANS($P,ypB) 0. \
                     $apANS($P,xpR) $apANS($P,ypT) 1. \
                     $xpA $ypA $zA $xpB $ypB $zB $PiX

      SetAxis $P PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD $xpS $ypS $zS
      SetAxis $P SECONDARY $xsA $ysA $zA $xsB $ysB $zB $xsS $ysS $zS

      if [string match YES $apANS($sN,tBased)] {
         DefinePlot $P $P X $BTp $ETp
	 set xL [TUtimeConv $BTd $BTp 0 apANS(tBase)]
	 set xU [TUtimeConv $BTd $ETp 0 apANS(tBase)]
         SetAxis $P PRIMARY $xL HOLD HOLD $xU HOLD HOLD HOLD HOLD HOLD
         SetAxis $P SECONDARY $xL HOLD HOLD $xU HOLD HOLD HOLD HOLD HOLD
      } else { DefinePlot $P $P }

# STICK up the plot grid if it is required and required before the plot is 
#   put up.

      if { [string match YES $apANS($sN,drG)] && \
           [string match BEFORE $apANS(gAdd)] } {
         APplotGrid $P $apANS($sN,tBased)
      }
   }
}
