package provide UDFAnalysis 1.0

proc APplotGUI { { ImC 0 } } {
  global apANS env Prefs GUIoptAlts GUIoptPri

   set W  .apPLOT

   set bSize [expr $Prefs(FontSize) + 2]
   set LFonT [list "" "" bold]
   set BFonT [list "" $bSize bold]
   set CFonT [list Courier 12 bold]

   if [GUIWindow $W "PLOT DEFINITION"] {
      if $ImC { GUIwindowCtrl .apPLOT }
      set Wa $W.cmd
      set Wb $W.body
      set Wc $W.pact
      set Wd $W.pmenu
      set We $W.cprop
      set Wh $W.pprop

      GUIFrame $Wa -1 grid|0|0|news||4
      GUIFrame $Wb -1 grid|1|0|news||3
      GUIFrame $Wc -1 grid|1|3|n
      GUIFrame $Wd  2 grid|2|0|w
      $Wd configure -relief raised
      GUIFrame $We  2 grid|2|1|w
      $We configure -relief raised
      GUIFrame $Wh  2 grid|2|2|e||2
      $Wh configure -relief raised

      GUIbuttonPush $Wa.close CLOSE pack|right "GUIwindowCtrl $W"  6
      set LaB "PLOT DEFINTION MENU"
      GUILabel $Wa.tL $LaB  w pack|left 10 0 "" $BFonT

      set R 0
      GUIblankRow $Wb $R 1.0

      set FmT "%-4s  %-6s  %-9s  %-12s  %-12s  %-12s  %-12s"
      set LaB [format $FmT Slot PiD Format VarX VarY VarZ VarI]

      incr R
      GUILabel $Wb.$R $LaB  w grid|$R|0|w 0 0 "" $CFonT
      incr R
      GUIboxList $Wb.list 50 10  grid|$R|0|ew "" single 0 1 $CFonT
      $Wb.list configure -exportselection false
      incr R
      GUIblankRow $Wb $R 1.0

      set Row 0
      GUIblankRow $Wc $R 2.5
      incr R
      GUIbuttonPush $Wc.add ADD grid|$R|0|w "APaddItem PLOT" 3 7
      incr R
      GUIblankRow $Wc $R 0.5
      incr R
      GUIbuttonPush $Wc.edi EDIT grid|$R|0|w "APeditItem PLOT" 3 7
      incr R
      GUIblankRow $Wc $R 0.5
      incr R
      GUIbuttonPush $Wc.del DELETE grid|$R|0|w "APdelItem PLOT" 3 7
      incr R
      GUIblankRow $Wc $R 1.5
      incr R
      GUIbuttonPush $Wc.acc ACCEPT grid|$R|0|w "APacceptEdit PLOT" 3 7
      incr R
      GUIblankRow $Wc $R 0.5
      incr R
      GUIbuttonPush $Wc.rst RESET grid|$R|0|w "APresetMenu PLOT" 3 7

      APxferItem PLOT INIT 0

      set pType [list LINE POINT BARS CERROR BERROR SOLID CONTOUR]
      set XA [list TOP|Xt BOTTOM|Xb]
      set YA [list LEFT|Yl RIGHT|Yr]
      set YN [list NO YES]
      set CFMT [list MONO COLOR]
      set STYLE [list SOLID DASH1 DASH2 DASH3 DASH4 \
                      SPDASH1 SPDASH2 SPDASH3 SPDASH4 \
                      DASHDOT1 DASHDOT2 DASHDOT3 \
                      DASH2DOT1 DASH2DOT2 DASH2DOT3 \
                      DASHSPDOT1 DASHSPDOT2 DASHSPDOT3 ]

      set R 0

      GUILabel $Wd.lpid "PID" c grid|$R|1|ew 0 0 "" $LFonT
      GUILabel $Wd.lfmt "Format" c grid|$R|2|ew 0 0 "" $LFonT
      GUILabel $Wd.lgtp "Avg" c grid|$R|3|ew 0 0 "" $LFonT
      GUILabel $Wd.lgf "Fill" c grid|$R|4|ew 0 0 "" $LFonT

      incr R
      GUILabel $Wd.l$R "Plot" c grid|$R|0|w 6 0 "" $LFonT
      GUIboxEntry $Wd.pid grid|$R|1|news 10 apANS(T,pID)
      GUIbuttonMenu $Wd.type "" grid|$R|2|ew $pType \
                       "GUIoptsProcess $Wd.type apANS(T,pType) PRI "
      GUIbuttonToggle $Wd.gtp $apANS(T,GtoP) grid|$R|3|ew $YN \
                      "GUIoptsToggle $Wd.gtp apANS(T,GtoP) PRI"
      GUIbuttonToggle $Wd.gf $apANS(T,GFill) grid|$R|4|ew $YN \
                      "GUIoptsToggle $Wd.gf apANS(T,GFill) PRI"

      incr R
      GUIblankRow $Wd $R 1.0

      incr R
      GUILabel $Wd.lxb "X" c grid|$R|1|ew 0 0 "" $LFonT
      GUILabel $Wd.lyl "Y" c grid|$R|2|ew 0 0 "" $LFonT
      GUILabel $Wd.lxt "Z" c grid|$R|3|ew 0 0 "" $LFonT
      GUILabel $Wd.lyr "I" c grid|$R|4|ew 0 0 "" $LFonT

      incr R
      GUILabel $Wd.l$R "Variables" c grid|$R|0|w 6 0 "" $LFonT
      GUIboxEntry $Wd.varx grid|$R|1|news 9 apANS(T,VarX)
      GUIboxEntry $Wd.vary grid|$R|2|news 9 apANS(T,VarY)
      GUIboxEntry $Wd.varz grid|$R|3|news 9 apANS(T,VarZ)
      GUIboxEntry $Wd.vari grid|$R|4|news 9 apANS(T,VarI)

      incr R
      GUILabel $Wd.l$R "Axis" c grid|$R|0|w 6 0 "" $LFonT
      GUIbuttonToggle $Wd.xact $apANS(T,xActive) grid|$R|1|ew $XA \
                    "GUIoptsToggle $Wd.xact apANS(T,xActive) ALT" 6
      set Index [lsearch $GUIoptAlts($Wd.xact) $apANS(T,xActive)]
      set wLab [lindex $GUIoptPri($Wd.xact) $Index]
      GUIchgConf $Wd.xact $wLab ""

      GUIbuttonToggle $Wd.yact $apANS(T,yActive) grid|$R|2|ew $YA \
                    "GUIoptsToggle $Wd.yact apANS(T,yActive) ALT" 6
      set Index [lsearch $GUIoptAlts($Wd.yact) $apANS(T,yActive)]
      set wLab [lindex $GUIoptPri($Wd.yact) $Index]
      GUIchgConf $Wd.yact $wLab ""

      incr R
      GUILabel $Wd.l$R "AutoScale" c grid|$R|0|w 6 0 "" $LFonT
      GUIbuttonToggle $Wd.xas $apANS(T,aScaX) grid|$R|1|ew $YN \
                      "GUIoptsToggle $Wd.xas apANS(T,aScaX) PRI" 6
      GUIbuttonToggle $Wd.yas $apANS(T,aScaY) grid|$R|2|ew $YN \
                      "GUIoptsToggle $Wd.yas apANS(T,aScaY) PRI" 6
      GUIbuttonToggle $Wd.zas $apANS(T,aScaZ) grid|$R|3|ew $YN \
                      "GUIoptsToggle $Wd.zas apANS(T,aScaZ) PRI" 6
      GUIbuttonToggle $Wd.ias $apANS(T,aScaI) grid|$R|4|ew $YN \
                      "GUIoptsToggle $Wd.ias apANS(T,aScaI) PRI" 6

      incr R
      GUIblankRow $Wd $R 1.0

      set R 0
      GUILabel $We.cll "Contour" c grid|$R|1|ew 0 0 "" $LFonT
      incr R
      GUIblankRow $We $R 1.0
      incr R
      GUILabel $We.lnm "Number " c grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $We.lnum grid|$R|1|news 9 apANS(T,cNum)
      incr R
      GUILabel $We.lcf "Format " c grid|$R|0|e 0 0 "" $LFonT
      GUIbuttonToggle $We.cfmt $apANS(T,cFmt) grid|$R|1|ew $CFMT \
                      "GUIoptsToggle $We.cfmt apANS(T,cFmt) PRI" 6 

      set R 0
      GUILabel $Wh.tll "Lines" c grid|$R|1|ew 0 0 "" $LFonT
      GUIblankCol $Wh 2 1.0
      GUILabel $Wh.tls "Symbols" c grid|$R|3|ew 0 0 "" $LFonT

      incr R
      GUIblankRow $Wh $R 1.0

      incr R
      GUILabel $Wh.lst "Style " c grid|$R|0|e 0 0 "" $LFonT
      GUIbuttonMenu $Wh.lstyle $apANS(T,lStyle) grid|$R|1|w $STYLE  \
	             "GUIoptsProcess $Wh.lstyle apANS(T,lStyle) PRI " 0 9
      GUIboxEntry $Wh.sym grid|$R|3|news 9 apANS(T,Sym)
      GUILabel $Wh.lsy "Sym " c grid|$R|4|e 0 0 "" $LFonT

      incr R
      GUILabel $Wh.llc "Color " c grid|$R|0|e 0 0 "" $LFonT
      GUIbuttonPush $Wh.lcol "" grid|$R|1|news \
               "GUIcolorPick $Wh.lcol apANS(T,lColor)" 0,0.5
      GUIchgConf $Wh.lcol "" "" "" $apANS(T,lColor)  ridge
      GUIbuttonPush $Wh.scol "" grid|$R|3|news \
               "GUIcolorPick $Wh.scol apANS(T,sColor)" 0,0.5
      GUIchgConf $Wh.scol "" "" "" $apANS(T,sColor) ridge
      GUILabel $Wh.lsc "Color " c grid|$R|4|e 0 0 "" $LFonT

      incr R
      GUILabel $Wh.llw "Width " c grid|$R|0|e 0 0 "" $LFonT
      GUIboxEntry $Wh.lwdth grid|$R|1|news 9 apANS(T,lWidth)
      GUIboxEntry $Wh.ssize grid|$R|3|news 9 apANS(T,sSize)
      GUILabel $Wh.lss "Size " c grid|$R|4|e 0 0 "" $LFonT

      incr R
      GUIboxEntry $Wh.sfont grid|$R|3|news 9 apANS(T,sFont)
      GUILabel $Wh.lsf "Font " c grid|$R|4|e 0 0 "" $LFonT

      bind $W <Down> { APtwinCmd MenU %W MOVE DOWN }
      bind $W <Up> { APtwinCmd MenU %W MOVE UP }
      bind $Wh.sym <Button-3> { GUIsymPick .apPlot.pprop.sym apANS(T,Sym) }

      APfillLBox PLOT
      APfillGUI PLOT T

      set apANS(PLOT,sN) [$Wb.list index end]

   } else { GUIwindowCtrl .apPLOT }
}
