package provide UDFAnalysis 1.0

proc APplot3DLabels { I J } {
   global apANS GphInfo PltInfo WinInfo

   set ScA [list LINEAR LOG]

   set P $apANS($I,pID)
   set pS [lindex $apANS($P) 0]
   set pN $apANS($pS,Col).$apANS($pS,Row)

   TextProp $apANS($I,Lsize$J) HOLD $apANS($I,Lbold$J)

   set xbs [lindex $ScA $WinInfo($pN,pa0)]
   set xts [lindex $ScA $WinInfo($pN,pa1)]
   set yls [lindex $ScA $WinInfo($pN,sa0)]
   set yrs [lindex $ScA $WinInfo($pN,sa1)]
   set zs  [lindex $ScA $WinInfo($pN,pa2)]

   SetAxis $pN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD LINEAR LINEAR LINEAR 1
   SetAxis $pN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD LINEAR LINEAR LINEAR 1

   set GphInfo(curWin) $pN
   set xC [GPHtextLen 2 X]
   set yC [GPHtextLen 2 Y]
   set Axis $apANS($I,Laxis$J)
   set Loc  $apANS($I,Lpos$J)
   set xO   $apANS($I,Lxoff$J)
   set yO   $apANS($I,Lyoff$J)
   set Just $apANS($I,Ljust$J)

   if [string match Xb $Axis] { set yO [expr -$yO] }
   if [string match Yl $Axis] { set xO [expr -$xO] }

   if [string match Y [string index $Axis 0]] {
      set Level $xO
      set Pos [expr [PLTlabPos $pN $Axis $Loc] + $yO * $yC]
   } else {
      set Level $yO
      set Pos [expr [PLTlabPos $pN $Axis $Loc] + $xO * $xC]
   }

   if [info exists GphInfo($apANS($I,Lcol$J))] {
      set C $GphInfo($apANS($I,Lcol$J))
   } else { set C $apANS($I,Lcol$J) }

   PLTinfoChg $pN $Axis NUMBERS TCOLOR $C
   PLTinfoChg $pN $Axis NUMBERS TSIZE $apANS($I,Lsize$J)
   set LaB [APgenLab $I $J]

   PLTaxisRec $pN $Axis NONE AXIS $Level $Pos $Just $LaB 
   TextProp $apANS($I,Lsize$J) HOLD OFF
   SetAxis $pN PRIMARY HOLD HOLD HOLD HOLD HOLD HOLD $xbs $yls $zs 1
   SetAxis $pN SECONDARY HOLD HOLD HOLD HOLD HOLD HOLD $xts $yrs $zs 1
}
