package provide UDFAnalysis 1.0

proc APplot3DAxes { I } {
   global apANS GphInfo PltInfo WinInfo

# SET up all the plot definitions for this plot

   APplotParms $I

   set pN  $apANS($I,Col).$apANS($I,Row)

   set Planes [list XYB XYT XZB XZT YZB YZT]
   set nP [llength $Planes]

# PLOT the axes

   PLTaxis3D $pN $Planes

# ADD tick marks to all axes

   for { set I 0 } { $I < $nP } { incr I } { 
      set pL [lindex $Planes $I]
      for { set J 0 } { $J < 2 } { incr J } { 
         set aX [string index $pL $J]
         PLTticks3D $pN $pL $aX [list MIN MAX]
      }
   }

# ADD numerical annotaton 

  PLTnumbers3D $pN XYB X [list MAX] 1.0
  PLTnumbers3D $pN YZT Y [list MIN] 1.0
  PLTnumbers3D $pN YZT Z [list MIN] 1.0

}
