# FIT as set of data to a gaussian of the form: 
#
#    Y = A * exp(-(X - B)/C)^2)
#
# THE function returns Y, dY/dA, dY/dB and dY/dC for any X.

package provide UDFAnalysis 1.0

proc APgaussFunc { nA dYdA Ops } {
    global _X_

    upvar $dYdA dA
    upvar $Ops  oP

    set xV $_X_($oP(4))

# THE coefficients
    set A $oP(5)
    set B $oP(6)
    set C $oP(7)

    set xS [expr ($xV - $B) / $C]
    set ExP [expr exp(-$xS * $xS)]
    set T [expr $A * $ExP  * 2.0 * $xS]

# THE value of the function

    set yV [expr $A * $ExP]

# Derivitive with respect to A is exp(-(X - B)/C)^2)
    set dA(0) $ExP

# Derivitive with respect to B is (2.0 * A * xS * ExP)/C
    set dA(1) [expr $T / $C]

# Derivitive with respect to C is (2.0 * A * xS * xS * ExP)/C 
    set dA(2) [expr $T * $xS / $C]

    return $yV
}
