package provide UDFAnalysisTh 1.0

proc APsolveStat { fD } {
   global apANS env Prefs

   APkeepTabs "STEP $fD : STATISTICS"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

   set PgmA { 
      source [ file join $env(TCLTOOLS_HOME) TclToolInits.tcl ]
      TclToolInits THREAD UTILS
      lappend auto_path [file join $env(TCLTOOLS_HOME) TclAnalysisTh]
      package require UDFAnalysis
      package require UDFAnalysisTh

      proc sTaT { nE vI vO } {

# INITIALIZE STAT data to junk

         for { set K 0 } { $K <  5} { incr K } { tsv::set $vO $K -1.0 }
         tsv::set $vO nE 0.0 

# GET the input data from tsv 

        THarrayXfer FROM _TmP $vI YES
      
# TRIVIAL COMP

         if { $nE < 2 } { 
            if { $nE == 1 } {
	       tsv::set $vO 0 $_In(0)
	       tsv::set $vO 1 0.0
	    }
         } else {
      
# MEAN VALUE

            set mV [TUarrayMath _TmP AVG _TmP _TmP $nE]

# VARIANCE and AVERAGE DEVIATION

            set Var [TUarrayMath _TmP VAR $mV _TmP $nE]

            TUarrayMath _TmP - $mV _T $nE
            for { set K 0 } { $K <  $nE } { incr K } {
               if { $_T($K) < 0.0 } { 
	          set _S($K) [expr -$_T($K)] 
	       } else { set _S($K) $_T($K) } 
            }
            set aDev [TUarrayMath _S SUM _S _S $nE]
            set aDev [expr $aDev / double($nE)]
     
# STANDARD DEVIATION

            set sD [expr sqrt($Var)]

# SKEW and KURTOSIS

	    if { $sD >  0.0 } { 
               TUarrayMath _T / $sD _T $nE
               TUarrayMath _T * _T _T2 $nE
               TUarrayMath _T2 * _T _Ts $nE
               TUarrayMath _T2 * _T2 _Tk $nE
               set sK [TUarrayMath _Ts SUM _Ts _Ts $nE]
               set kU [TUarrayMath _Tk SUM _Tk _Tk $nE]
               set sK [expr $sK / double($nE)]
               set kU [expr $kU / double($nE) - 3.0]
            } else { set sK 0.0; set kU 0.0 }

            tsv::set $vO nE $nE;
            tsv::set $vO 0 $mV;
            tsv::set $vO 1 $Var;
            tsv::set $vO 2 $sD;
            tsv::set $vO 3 $aDev;
            tsv::set $vO 4 $sK;
            tsv::set $vO 5 $kU;
         }
      }
   }


# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return
 
   if { $nF == 0 } { return }

# START up the thread pool

   set tPoolID [THpoolOpen $PgmA]
   set joBs ""

# LOOP over the instances

   set rN 0
   set oV ""

   for { set I 0 } { $I < $nF } { incr I } {

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s" _vI _vO _lT _gT

# GET the input variable list

      set rV [APgetVNames $_vI]
      set iNames [lindex $rV 0]
      set nI [llength $iNames]

# GET the output variable list

      set rV [APgetVNames $_vO]
      set oNames [lindex $rV 0]
      set nO [llength $oNames]

      for { set J 0 } { $J <  $nI } { incr J } {

         set vRi [lindex $iNames $J]
         global [set vRi]
         upvar 0 [set vRi] _In

	 APtimeSpan _In BeG EnD

         set vRo [lindex $oNames $J]
	 lappend oV $vRo

# WORK only with data within the specified time and data range.  Put the
#   data into tsv space
   
         set nE 0
         for { set K $BeG } { $K <  $EnD } { incr K } {
            if { ($_In($K) < $_gT) && ($_In($K) > $_lT) } { 
	       tsv::set $vRi $nE $_In($K)
	       incr nE
            }
         }

	 lappend JoBs [THschdTask $tPoolID [list sTaT $nE $vRi $vRo]]
	 incr rN
      }
   }

   THjobsDone $tPoolID $JoBs
   THpoolClose $tPoolID

   set nV [llength $oV]
   for { set I 0 } { $I < $nV } { incr I } {
      set ovN [lindex $oV $I] 
      global [set ovN]
      upvar 0 [set ovN] _Out
      THarrayXfer FROM _Out $ovN YES
      set _Out(Dim) [list 5 1]
      set _Out(aType) STAT
   }
}
