# PLASMA parameter computations

package provide UDFAnalysis 1.0

proc APsolvePlasma { fD } {
   global apANS env Prefs RtoD PI

   APkeepTabs "STEP $fD : PLASMA"

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# Proton and electron mass in gm

   set Mp 1.6726e-24 
   set Me 9.1095e-28 

# LOOP over the conversion definitions

   set FmT "%s %s %s %s %s %s %s %s %s %s"
   for { set I 0 } { $I < $nF } { incr I } {

# GET the conversion definition
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe $FmT _vO _pP _cO _eD _iD _eT _iT _bF _ChG _AmU

# GET the and output varaible(s)

      set oNames [lindex [APgetVNames $_vO] 0]
      set vR [lindex $oNames 0]
      global  [set vR] ; upvar 0 [set vR] _OuT

# DO inital checks to see what variables have been defined.  Might as well
#   do all the setups up front.

       set vL [list $_eD $_iD $_eT $_iT $_bF $_ChG $_AmU]
       set vN [list _dE _dI _tE _tI _mF _Q _aN]
       set nV [llength $vL]
       for { set J 0 } { $J < $nV } { incr J } {
          set VaR  [lindex $vL $J]
          set VarN [lindex $vN $J]
          if ![string match $apANS(EmptyVar) $VaR] { 
             set rV [APgetVNames $VaR]
	     set vR [lindex $rV 0]
	     if [lindex $rV 1] {
	        set ${VarN}(0) $VaR
	        set nE($VarN) 1
	     } else {
                global  [set VaR] ; upvar 0 [set VaR] $VarN
		upvar 0 $VarN _X
	        set nE($VarN) [lindex $_X(Dim) 0]
	        if [info exists _X(gInE)] { 
		   APxferGInfo _X gI$VarN DATA REVERSE 
		}
             }
          } else { set nE($VarN) 0 }
       }

# DO the computation

      set gI ""
      switch -exact -- $_pP {
         GyroFreq {

# eGF = 2.80e6 * B  (Hz)
# iGF = 1.52e3 * B * Q / aN  (Hz)

	    if [string match E $_cO] {
	       set _Q(0) 1.0  ; set nE(_Q) 1
	       set _aN(0) 1.0 ; set nE(_aN) 1
	       set FaC 2.80e6
            }  else { set FaC 1.52e3 }

	    if { $nE(_mF) == 0 } { puts stderr "$_pP needs MF data" ; return }
	    if { $nE(_Q) == 0 } { puts stderr "$_pP needs ChG data" ; return }
	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }

            set nP $nE(_mF) ; set Base _mF
            if { $nE(_Q) > $nP } { set nP $nE(_Q) ; set Base _Q }
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nE(_mF)]
	       set Jb [expr $J % $nE(_Q)]
	       set Jc [expr $J % $nE(_aN)]
	       set _OuT($J) [expr $FaC * $_mF($Ja) * $_Q($Jb) / $_aN($Jc)]
	    }
         }
         GyroRadius {

# eGR = 2.38e-2 * sqrt(Te) / B  (m)
# iGR = 1.02 * sqrt(Ti * aN / Q) / B  (m)

	    if [string match E $_cO] {
	       set _Q(0) 1.0  ; set nE(_Q) 1
	       set _aN(0) 1.0 ; set nE(_aN) 1
	       set FaC 2.38e-2
	       set Base _tE
            } else { 
	       set FaC 1.02 
	       set Base _tI
            }

	    if { $nE($Base) == 0 } { 
	       puts stderr "$_pP needs Temp data" ; return 
	    } else { upvar 0 $Base _T }
	    set nT $nE($Base)

	    if { $nE(_mF) == 0 } { puts stderr "$_pP needs MF data" ; return }
	    if { $nE(_Q) == 0 } { puts stderr "$_pP needs ChG data" ; return }
	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }

            set nP $nT ;
            if { $nE(_Q) > $nP } { set nP $nE(_Q) ; set Base _Q }
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }
            if { $nE(_mF) > $nP } { set nP $nE(_mF) ; set Base _mF }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nE(_mF)]
	       set Jb [expr $J % $nE(_Q)]
	       set Jc [expr $J % $nE(_aN)]
	       set Jd [expr $J % $nT]
	       set RooT [expr sqrt( $_T($Jd) * $_aN($Jb) / $_Q($Jc))]
	       set _OuT($J) [expr $FaC * $RooT / $_mF($Ja)]
	    }
         }
         InertialLen -
         PlasmaFreq {

# ePF = 8.89e3 * sqrt(dE) (Hz)
# iPF = 2.10e2 * sqrt(dI / aN) / Q (Hz)
# InertialLen = c/iPF (km)

	    if [string match E $_cO] {
	       set _Q(0) 1.0  ; set nE(_Q) 1
	       set _aN(0) 1.0 ; set nE(_aN) 1
	       set FaC 8.89e3
	       set Base _dE
            }  else { 
	        set FaC 2.10e2 
	       set Base _dI
            }

	    if { $nE($Base) == 0 } { 
	       puts stderr "$_pP needs Den data" ; return 
	    } else { upvar 0 $Base _N }
	    set nD $nE($Base)

	    if { $nE(_Q) == 0 } { puts stderr "$_pP needs ChG data" ; return }
	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }

            set nP $nD
            if { $nE(_Q) > $nP } { set nP $nE(_Q) ; set Base _Q }
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nD]
	       set Jb [expr $J % $nE(_Q)]
	       set Jc [expr $J % $nE(_aN)]
	       if { $_N($Ja) >= 0.0 } {
	          set RooT [expr sqrt( $_N($Ja) / $_aN($Jb))]
               } else { set RooT 0 }
	       set _OuT($J) [expr $FaC * $RooT / $_Q($Jb)]
	    }

            if [string match InertialLen $_pP] {
                for { set J 0  } { $J < $nP } { incr J } {
	           set _OuT($J) [expr 3.0e5 / $_OuT($J)]
		}
	    }
         }
         ThermalVel {

# eVth = 9.79e3 * sqrt(Te) (m/s)
# iVth = 9.79e3 * sqrt(Ti / aN) (m/s)

	    set FaC 9.79e3
	    if [string match E $_cO] {
	       set _aN(0) 1.0 ; set nE(_aN) 1
	       set Base _eT
            }  else { set Base _iT }

	    if { $nE($Base) == 0 } { 
	       puts stderr "$_pP needs Den data" ; return 
	    } else { upvar 0 $Base _T }
	    set nT $nE($Base)

	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }

            set nP $nT
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nT]
	       set Jb [expr $J % $nE(_aN)]
	       set RooT [expr sqrt( $_T($Ja) / $_aN($Jb))]
	       set _OuT($J) [expr $FaC * $RooT]
	    }
         }
         AlfvenVel {

# iAlfV = 2.18e9 * B / sqrt(Ni * aN) (m/s)
# eAlfV = 2.18e9 * B * sqrt(1836) / sqrt(Ne * aN) (m/s)

	    set FaC 2.18e9
	    if [string match E $_cO] { set FaC [expr $FaC * sqrt(1836.0)] }

	    if { $nE(_dI) == 0 } { puts stderr "$_pP needs Den data" ; return }
	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }
	    if { $nE(_mF) == 0 } { puts stderr "$_pP needs mF data" ; return }

            set Base _dI
            set nP $nE($Base)
            if { $nE(_mF) > $nP } { set nP $nE(_mF) ; set Base _mF }
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nE(_dI)]
	       set Jb [expr $J % $nE(_aN)]
	       set Jc [expr $J % $nE(_mF)]
	       set RooT [expr sqrt($_dI($Ja) * $_aN($Jb))]
	       set _OuT($J) [expr $FaC * $_mF($Jc) / $RooT]
	    }
         }
         LowHybrid {

# LowHyb = 6.53e4 * B * sqrt(Q / aN) (Hz)

	    set FaC 6.53e4

	    if { $nE(_Q) == 0 } { puts stderr "$_pP needs Chg data" ; return }
	    if { $nE(_aN) == 0 } { puts stderr "$_pP needs AmU data" ; return }
	    if { $nE(_mF) == 0 } { puts stderr "$_pP needs mF data" ; return }

            set Base _mF
            set nP $nE($Base)
            if { $nE(_Q) > $nP } { set nP $nE(_Q) ; set Base _Q }
            if { $nE(_aN) > $nP } { set nP $nE(_aN) ; set Base _aN }

            for { set J 0  } { $J < $nP } { incr J } {
	       set Ja [expr $J % $nE(_Q)]
	       set Jb [expr $J % $nE(_aN)]
	       set Jc [expr $J % $nE(_mF)]
	       set RooT [expr sqrt($_Q($Ja) / $_aN($Jb))]
	       set _OuT($J) [expr $FaC * $_mF($Jc) * $RooT]
	    }
         }
      }
      set _OuT(Dim) [list $nP 1]
      if [info exists gI$Base] { APxferGInfo gI$Base _OuT GI }
   }
}
