package provide UDFAnalysis 1.0

proc APsolveFit { fD } {
   global apANS env Prefs _X_

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# LOOP over the instances

   for { set I 0 } { $I < $nF } { incr I } {
       APkeepTabs "STEP $fD : FIT ($I)"

# GET the first line
   
      set LiNe [$W get $I]

# BREAK it apart

      scan $LiNe "%s %s %s %s %s %s %s %s" _LSq _Dim _Vi _Sca _nC _G _FunC _vO

# GET the input variables list

      set iNames [lindex [APgetVNames $_Vi] 0]
      set nI [llength $iNames]

# THE number of elements should be the dimension of the fit + 1 or + 2 if
#   there is a set of weighting factors included.  The order of the data
#   is:
#   
#   Dim 1: XV[W]
#   Dim 2: XYV[W]
#   Dim 3: XYZV[W]

      set nV [expr $_Dim + 1]
      set nVW [expr $_Dim + 2]

      if { ($nV != $nI) && ($nVW != $nI) } { continue }

# OUTPUT array. Always will have at least one of these

      set oNames [lindex [APgetVNames $_vO] 0]
      set nO [llength $oNames]
      set vR [lindex $oNames 0]
      global [set vR] ; upvar 0 [set vR] _Out

# SET the function definition number describing the fit and initiallize the 
#   number of dimensions used in the fit. Set aType to the array type.  This
#   is needed to differentiate this array from a common set of data.

     set _Out(fDEF) $fD
     set _Out(fDim) $_Dim
     set _Out(aType) FIT
     set _Out(fFunc) $_FunC
     set _Out(LSq) $_LSq

# Fits use an external routine to provide the basis functions in the case of
#   linear fits or the derivatives wrt to coefficients in the case of 
#   non-linear fits. Need to source this function if it is a user supplied 
#   function

         if { [string length [info procs $_FunC]] == 0 } { source $_FunC }

# GET the function name supplying the basis functions.  This just strips 
#   off any leading directory info.

         if ![string match "---" $_FunC] {
            set fFunC [file tail $_FunC]
         } else { set fFunC "" }

# GET the input variables.  Append any missing  data locations to the 
#   NoData array.  Also if the data is to have the log taken of it then 
#   any data <= 0.0 is considered missing.

      set P 0
      set vR [lindex $iNames $P]
      global [set vR] ; upvar 0 [set vR] _fX
      if [string match L [string index $_Sca 0]] { 
         set _scaX Linear 
      } else { set _scaX Log }
      set _Out(xSca) $_scaX
      set nX [lindex $_fX(Dim) 0]
      set nY [lindex $_fX(Dim) 1]
      if {$nY > 1 } { set nE $nY } else { set nE $nX }
      if [string match Log $_scaX] { 
          set BaD 0.0 ; set sFlag(X) LOG10
      } else { set BaD $apANS(BaDL) ; set sFlag(X) COPY }
      APbadGrid FLAG $nE _fX NoData 0 $BaD
      incr P

      if { $_Dim > 1 } {
         set vR [lindex $iNames $P]
         global [set vR] ; upvar 0 [set vR] _fY
         if [string match L [string index $_Sca 1]] { 
            set _scaY Linear 
         } else { set _scaY Log }
         set _Out(ySca) $_scaY
         if [string match Log $_scaY] { 
             set BaD 0.0 ; set sFlag(Y) LOG10
         } else { set BaD $apANS(BaDL) ; set sFlag(Y) COPY }
         APbadGrid AFLAG $nE _fY NoData 0 $BaD
         incr P
      }

      if { $_Dim > 2 } {
         set vR [lindex $iNames $P]
         global [set vR] ; upvar 0 [set vR] _fZ
         if [string match L [string index $_Sca 2]] { 
            set _scaZ Linear 
         } else { set _scaZ Log }
         set _Out(zSca) $_scaZ
         if [string match Log $_scaZ] { 
             set BaD 0.0 ; set sFlag(Z) LOG10
         } else { set BaD $apANS(BaDL) ; set sFlag(Z) COPY }
         APbadGrid AFLAG $nE _fZ NoData 0 $BaD
         incr P
      }

      set vR [lindex $iNames $P]
      global [set vR] ; upvar 0 [set vR] _fV
      if [string match L [string index $_Sca 3]] { 
         set _scaV Linear 
      } else { set _scaV Log }
      set _Out(vSca) $_scaV
      if [string match Log $_scaV] { 
          set BaD 0.0 ; set sFlag(V) LOG10
      } else { set BaD $apANS(BaDL) ; set sFlag(V) COPY }
      APbadGrid AFLAG $nE _fV NoData 0 $BaD
      incr P

# STATISTICS array.  If one isn't input then create one and set all elements
#   to 1.0

      if { $nI == $nVW } {
         set vR [lindex $iNames $P]
         global [set vR] ; upvar 0 [set vR] _fW
      } else { for { set J 0 } { $J < $nE } { incr J } { set _fW($J) 1.0 } }

# AT this point split things depending on whether we are doing a linear or
#   a non-linear fit.

      if [string match YES $_LSq] {
         set nP [APcopyGrid COPY 1 $nE _fW _tW NoData]

# NO matter the dimension there is always an X and V array.  Copy these data
#    to new arrays, taking log if necessary

         set nP [APcopyGrid $sFlag(X) 1 $nE _fX _tX NoData]
         set nP [APcopyGrid $sFlag(V) 1 $nE _fV _tV NoData]

# FIT the data.  Calls depend on the fit dimension. 

         if { $_Dim == 1 } {

# NUMBER of coefficients (alwyas one more than order for 1D poly fits)

	    set _Out(nC) $_nC

# FIT the data

	    set _Out(ChiSq) [TUdataLSq1D _tX _tV $nP 0 _Cf _iCf $_nC \
	                    CoVar $fFunC _tW]
         } elseif { $_Dim == 2 } {

# Just need to save off the Y variables

            set nP [APcopyGrid $sFlag(Y) 1 $nE _fY _tY NoData]

            set fOps(OR) $_nC
	    set _Out(ChiSq) [TUdataLSq2D _tX _tY _tV $nP 1 _Cf _iCf fOps \
	                    CoVar $fFunC _tW]
	    
	    set _Out(nC) $fOps(NC)

         } else {

# Just need to save off the Y variables

            set nP [APcopyGrid $sFlag(Z) 1 $nE _fZ _tZ NoData]

            set fOps(OR) $_nC
	    set _Out(ChiSq) [TUdataLSq3D _tX _tY _tZ _tV $nP 1 _Cf _iCf fOps \
	                    CoVar $fFunC _tW]
         }

# SAVE the fit coefficients and the Covariance matrix values associated with
#   them
         set InC [expr $_Out(nC) + 1]
         for { set J 0 ; set K 0 } { $J < $_nC } { incr J ; incr K $InC } {
            set _Out($J) $_Cf($J)
            set _Out(CV$J) $CoVar($K)
         }

      } else {

#  COPY the data to  be fit to temporary arrays

         set nP [APcopyGrid COPY 1 $nE _fX _X_ NoData]
         set nP [APcopyGrid COPY 1 $nE _fV _tV NoData]
         set nP [APcopyGrid COPY 1 $nE _fW _tW NoData]

# Fit requires an initial guess to the coefficients.  Set these up here.
#   All coefficients are to be solved for.

         set vR [lindex [lindex [APgetVNames $_G] 0] 0]
         global [set vR] ; upvar 0 [set vR] _fG
         for { set J 0 } { $J < $_nC } { incr J } { 
            set _Cf($J) $_fG($J)
            set iCf($J) 1
         }

#  Fit is an iteration procedure.  First call initiates the function

         set oP(0) -1
         TUdataNLinLSq _tV _tW $nP _Cf iCf $_nC $fFunC oP

#  NOW iterate.  Allow for 100 iterations or convergence

         set MaxCnt 0
         while { ($MaxCnt < 500) && ($oP(0) < 10000.0) } {
            TUdataNLinLSq _tV _tW $nP _Cf iCf $_nC $fFunC oP
            incr MaxCnt
         }

# FINISH up by computing the covarience matrices

         set oP(0) 0.0
         TUdataNLinLSq _tV _tW $nP _Cf iCf $_nC $fFunC oP

# TIME to save the coefficients and and their covarience values

         set InC [expr $_nC + 1]
         set K [expr 5 + $_nC]
         set _Out(nC) $_nC
         for { set J 0 } { $J < $_nC } { incr J ; incr K $InC } {
            set _Out($J) $_Cf($J)
            set _Out(CV$J) $oP($K)
         }
	 set _Out(ChiSq) $oP(1)

         unset _X_
      }
   }

# IF there are two output variables then the second should contain the model 
#   fit at the same resolution as the input data.

   if { $nO > 1 } {
      set vR [lindex $oNames 1]
      global [set vR] ; upvar 0 [set vR] _mOut
      set rV [APexpandFit -1 _Out _fX _fY _fZ _mOut $nE]  
      set _mOut(Dim) [list $rV 1]
   }
}
