package provide UDFAnalysis 1.0

# Produces a Probability Distribution Function.  
# 
# 1. If the data is time based and gridded it will be run over the 
#    grids which contain the plot time.
#
# 2. You can produce multiple binnings if the input variable is an array.
#    and you specify one binY per input variable. All binnings use the 
#    same xBin definition array. You can place them all into the same binY
#    by specifying only one binY.
#
# 3. You can bin multiple data sets in a single bin simply by not specifying 
#    either the X or Y bin variable.  If you do this using array variables
#    the all array vaiables in a group of data must be of the same size.

proc APsolveBin { fD } {
   global apANS env Prefs

# THIS is the text window for this function definition

   set W .apFDEF$fD.body.list
   if ![winfo exists $W] {
      set GuI [lindex $apANS($apANS($fD,Func)) 0]
      eval $GuI $fD 1
   }

# THIS is the number of instances to run the function

   set nF [$W index end]

# NO instances then return

   if { $nF == 0 } { return }

# GROUP sets of definitions which use a commom bining scheme
 
   set Starts ""
   for { set I 0 } { $I < $nF } { incr I } {

      APkeepTabs "STEP $fD : BIN ($I)"

      set LiNe [$W get $I]
      scan $LiNe "%s %s %s %s %s %s %s" _vI _bX _bY _bL _bU _bN _Norm
      set bXv [string match $apANS(EmptyVar) $_bX]
      set bYv [string match $apANS(EmptyVar) $_bY]
      if { !$bXv && !$bYv } { lappend Starts $I }
   }

# LOOP over the groups
 
   set nS [expr [llength $Starts] - 1 ]
   for { set G 0 } { $G <= $nS } { incr G } {

      if { $G != $nS } {
         set EnD [lindex $Starts [expr $G + 1]]
      } else { set EnD $nF }
      set BeG [lindex $Starts $G]

# Process each definition

      for { set I $BeG } { $I < $EnD } { incr I } {

# GET the definition line
   
         set LiNe [$W get $I]

# BREAK it apart
 
         scan $LiNe "%s %s %s %s %s %s %s" _vI _bX _bY _bL _bU _bN _Norm

# GET the input variable list

         set rV [APgetVNames $_vI]
         set iNames [lindex $rV 0]
         set nI [llength $iNames]

# ONLY need to set up the X and Y bin variables if this is the first 
#    definition in the group
 
         if { $I == $BeG } {

# GET the BinX variable list - should only be one variable so take what
#   you get

            set rV [APgetVNames $_bX]
            set xName [lindex [lindex $rV 0] 0]
            global [set xName ] ; upvar 0 [set xName] _xBin
            set _xBin(Dim) [list $_bN 1]

# CREATE the binX array

            set _xL [expr ($_bU - $_bL)]
            set _bS [expr $_xL / double($_bN)]
            set _bC [expr $_bL + $_bS / 2.0]
            for { set J 0 } { $J < $_bN } { incr J } {
               set _xBin($J) [expr $_bC + $J * $_bS]
            }

# GET the BinY variable list

            set rV [APgetVNames $_bY]
            set yNames [lindex $rV 0]
            set nY [llength $yNames]

# NULL out the binY variable(s)
 
            for { set K 0 } { $K < $nY } { incr K } {
               set vR [lindex $yNames $K]
               global [set vR] ; upvar 0 [set vR] _yBin
               set _yBin(Dim) [list $_bN 1]
               for { set J 0 } { $J < $_bN } { incr J } { set _yBin($J) 0 }
	    } 
         }

# BIN the input variables

         for { set J 0 } { $J <  $nI } { incr J } {

            set vR [lindex $iNames $J]
            global [set vR] ; upvar 0 [set vR] _vIN

	    APtimeSpan _vIN bT eT

            if { $nY > 1 } {
               set vR [lindex $yNames $J]
               global [set vR] ; upvar 0 [set vR] _yBin
            }

            for { set K $bT } { $K < $eT } { incr K } {
               if {$_vIN($K) > $apANS(BaDL) } { 
                  set _bP [expr ($_vIN($K) - $_bL) / $_bS]
	          if { ($_bP >= 0) && ($_bP < $_bN) } { 
	             set _bP [expr int($_bP)]
	             incr _yBin($_bP) 
	          }
	       }
            }
         }
      }

# NORMALIZE the PDF(s) if we are need to
 
      for { set K 0 } { $K < $nY } { incr K } {
         set vR [lindex $yNames $K]
         global [set vR] ; upvar 0 [set vR] _yBin

         set mPos [TUdataMxMn _yBin $_bN > $apANS(BaDL) $apANS(BaDU)]
         set _yBin(MaxV) $_yBin($mPos)
         set _yBin(MaxP) $_xBin($mPos)

         switch -exact -- $_Norm {
	    Area {
	       set _Area 0.0
               for { set K 0 } { $K < $_bN } { incr K } { 
	          set _Area [expr $_Area + $_yBin($K)]
	       }
	       set _Area [expr $_Area * $_bS]
               if { $_Area > 0.0 } {
                  for { set K 0 } { $K < $_bN } { incr K } { 
                     set _yBin($K) [expr $_yBin($K) / $_Area]
                  }
               }
            }
	    MaxV {
               set Mx $_yBin($mPos)
               if { $Mx > 0 } {
                  for { set K 0 } { $K < $_bN } { incr K } { 
                     set _yBin($K) [expr $_yBin($K) / double($Mx) ]
                  }
               }
            }
         }
      }
   }
}
